/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import github.jorgaomc.ModItems;
import github.jorgaomc.blocks.entity.ModBlockEntities;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class EternatusCocoonBlockEntity
extends BlockEntity {
    private static final int REQUIRED_PARTICLES = 500;
    private int particlesConsumed = 0;
    private boolean isReady = false;

    public EternatusCocoonBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ETERNATUS_COCOON_BE, pos, state);
    }

    public boolean consumeGalarParticles(Player player) {
        boolean justReachedMax;
        int particlesToConsume;
        if (this.isReady) {
            return true;
        }
        int particleCount = 0;
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            if (!player.getInventory().getItem(i).is(ModItems.GALAR_PARTICLE)) continue;
            particleCount += player.getInventory().getItem(i).getCount();
        }
        if (particleCount == 0) {
            return false;
        }
        int remaining = particlesToConsume = Math.min(particleCount, 500 - this.particlesConsumed);
        for (int i = 0; i < player.getInventory().getContainerSize() && remaining > 0; ++i) {
            if (!player.getInventory().getItem(i).is(ModItems.GALAR_PARTICLE)) continue;
            int stackSize = player.getInventory().getItem(i).getCount();
            int toRemove = Math.min(stackSize, remaining);
            player.getInventory().getItem(i).shrink(toRemove);
            remaining -= toRemove;
        }
        this.particlesConsumed += particlesToConsume;
        boolean bl = justReachedMax = this.particlesConsumed >= 500 && !this.isReady;
        if (justReachedMax) {
            this.isReady = true;
            player.displayClientMessage((Component)Component.literal((String)"The cocoon is ready to break").withStyle(ChatFormatting.LIGHT_PURPLE), false);
        }
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
        return false;
    }

    public int getParticlesConsumed() {
        return this.particlesConsumed;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void reset() {
        this.particlesConsumed = 0;
        this.isReady = false;
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("particlesConsumed", this.particlesConsumed);
        nbt.putBoolean("isReady", this.isReady);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.particlesConsumed = nbt.getInt("particlesConsumed");
        this.isReady = nbt.getBoolean("isReady");
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithoutMetadata(registryLookup);
    }
}

