/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.ModItems;
import github.jorgaomc.blocks.entity.BasePedestalBlockEntity;
import github.jorgaomc.blocks.entity.ModBlockEntities;
import github.jorgaomc.config.PedestalConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class HeatranPedestalBlockEntity
extends BasePedestalBlockEntity {
    private static final RandomSource RANDOM = RandomSource.create();
    private static final double SHINY_CHANCE = 0.02;

    public HeatranPedestalBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.HEATRAN_PEDESTAL_BE, pos, state);
    }

    @Override
    public boolean handleSpecialAction(Player player, ItemStack stack) {
        Level level;
        Item requiredItem = this.getRequiredItem();
        if (!stack.is(requiredItem)) {
            return false;
        }
        if (this.hasPlayerUsed(player)) {
            if (!this.level.isClientSide) {
                player.displayClientMessage((Component)Component.literal((String)"This pedestal has already been used by you.").withStyle(ChatFormatting.RED), true);
            }
            return false;
        }
        this.clearContent();
        if (!this.level.isClientSide && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            try {
                boolean isShiny;
                this.markPlayerUsed(player);
                PokemonProperties properties = new PokemonProperties();
                properties.setSpecies("heatran");
                properties.setLevel(Integer.valueOf(50));
                boolean bl = isShiny = RANDOM.nextDouble() < 0.02;
                if (isShiny) {
                    properties.setShiny(Boolean.valueOf(true));
                }
                Pokemon pokemon = properties.create();
                BlockPos spawnPos = this.worldPosition.above();
                this.spawnHeatranEffect(serverWorld, spawnPos);
                PokemonEntity entity = new PokemonEntity((Level)serverWorld, pokemon, CobblemonEntities.POKEMON);
                entity.moveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, 0.0f, 0.0f);
                serverWorld.addFreshEntity((Entity)entity);
                if (isShiny) {
                    player.displayClientMessage((Component)Component.literal((String)"The magma churns violently! ").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).append((Component)Component.literal((String)"A SHINY Heatran appears!").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})), false);
                } else {
                    player.displayClientMessage((Component)Component.literal((String)"The magma begins to bubble! ").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}).append((Component)Component.literal((String)"Heatran appears!").withStyle(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD})), false);
                }
                return true;
            }
            catch (Exception e) {
                System.err.println("Error spawning Heatran: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return false;
    }

    private Item getRequiredItem() {
        String itemName = PedestalConfig.HEATRAN_PEDESTAL_ITEM;
        if ("magma_stone".equals(itemName)) {
            return ModItems.MAGMA_STONE;
        }
        try {
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item != null) {
                return item;
            }
        }
        catch (Exception e) {
            System.err.println("Could not find item: " + itemName + ", falling back to default");
        }
        return ModItems.MAGMA_STONE;
    }

    private void spawnHeatranEffect(ServerLevel world, BlockPos pos) {
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LAVA_AMBIENT, SoundSource.AMBIENT, 1.0f, 0.5f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.AMBIENT, 0.7f, 0.6f);
        RandomSource random = world.random;
        for (int i = 0; i < 100; ++i) {
            double x = (double)pos.getX() + 0.5 + (random.nextDouble() - 0.5) * 6.0;
            double y = (double)(pos.getY() + 1) + (random.nextDouble() - 0.5) * 2.0;
            double z = (double)pos.getZ() + 0.5 + (random.nextDouble() - 0.5) * 6.0;
            world.sendParticles((ParticleOptions)ParticleTypes.LAVA, x, y, z, 1, 0.0, 0.0, 0.0, 0.1);
            world.sendParticles((ParticleOptions)ParticleTypes.FLAME, x, y, z, 1, 0.0, 0.0, 0.0, 0.05);
        }
        world.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, (double)pos.getX() + 0.5, (double)(pos.getY() + 1), (double)pos.getZ() + 0.5, 5, 2.0, 0.5, 2.0, 0.1);
    }
}

