/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.ModItems;
import github.jorgaomc.blocks.entity.BasePedestalBlockEntity;
import github.jorgaomc.blocks.entity.ModBlockEntities;
import github.jorgaomc.config.PedestalConfig;
import github.jorgaomc.util.LegendaryEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class HoOhPedestalBlockEntity
extends BasePedestalBlockEntity {
    private static final RandomSource RANDOM = RandomSource.create();
    private static final double SHINY_CHANCE = 0.02;

    public HoOhPedestalBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.HO_OH_PEDESTAL_BE, pos, state);
    }

    @Override
    public boolean handleSpecialAction(Player player, ItemStack stack) {
        Level level;
        Item requiredItem = this.getRequiredItem();
        if (!stack.is(requiredItem)) {
            return false;
        }
        if (this.hasPlayerUsed(player)) {
            if (!this.level.isClientSide) {
                player.displayClientMessage((Component)Component.literal((String)"This pedestal has already been used by you.").withStyle(ChatFormatting.RED), true);
            }
            return false;
        }
        this.clearContent();
        if (!this.level.isClientSide && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            try {
                boolean isShiny;
                this.markPlayerUsed(player);
                PokemonProperties properties = new PokemonProperties();
                properties.setSpecies("hooh");
                properties.setLevel(Integer.valueOf(60));
                boolean bl = isShiny = RANDOM.nextDouble() < 0.02;
                if (isShiny) {
                    properties.setShiny(Boolean.valueOf(true));
                }
                Pokemon pokemon = properties.create();
                ItemStack heldItem = new ItemStack((ItemLike)ModItems.SACRED_ASH);
                pokemon.swapHeldItem(heldItem, false);
                BlockPos spawnPos = this.worldPosition.above();
                LegendaryEffects.spawnHoOhEffect(serverWorld, spawnPos);
                PokemonEntity entity = new PokemonEntity((Level)serverWorld, pokemon, CobblemonEntities.POKEMON);
                entity.moveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, 0.0f, 0.0f);
                serverWorld.addFreshEntity((Entity)entity);
                if (isShiny) {
                    player.displayClientMessage((Component)Component.literal((String)"The rainbow shines with brilliant colors! ").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).append((Component)Component.literal((String)"A SHINY Ho-Oh appears!").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})), false);
                } else {
                    player.displayClientMessage((Component)Component.literal((String)"A rainbow forms in the sky! ").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).append((Component)Component.literal((String)"Ho-Oh appears!").withStyle(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD})), false);
                }
                player.displayClientMessage((Component)Component.literal((String)"Ho-Oh is holding Sacred Ash!").withStyle(ChatFormatting.GOLD), true);
                return true;
            }
            catch (Exception e) {
                System.err.println("Error spawning Ho-Oh: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return false;
    }

    private Item getRequiredItem() {
        String itemName = PedestalConfig.HOOH_PEDESTAL_ITEM;
        if ("rainbow_feather".equals(itemName)) {
            return ModItems.RAINBOW_FEATHER;
        }
        try {
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item != null) {
                return item;
            }
        }
        catch (Exception e) {
            System.err.println("Could not find item: " + itemName + ", falling back to default");
        }
        return ModItems.RAINBOW_FEATHER;
    }
}

