/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import github.jorgaomc.ModItems;
import github.jorgaomc.blocks.entity.DualPedestalBlockEntity;
import github.jorgaomc.blocks.entity.ModBlockEntities;
import github.jorgaomc.config.PedestalConfig;
import github.jorgaomc.util.LegendaryEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class HoopaPedestalBlockEntity
extends DualPedestalBlockEntity {
    public HoopaPedestalBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.HOOPA_PEDESTAL_BE, pos, state, HoopaPedestalBlockEntity.getFirstRequiredItem(), HoopaPedestalBlockEntity.getSecondRequiredItem(), "hoopasummon", "A dimensional portal opens! ", "A powerful dimensional rift appears! ", ChatFormatting.DARK_PURPLE, ChatFormatting.LIGHT_PURPLE);
    }

    @Override
    protected void spawnEffects(ServerLevel world, BlockPos pos) {
        LegendaryEffects.spawnLegendaryEffect(world, pos);
    }

    @Override
    protected String getPokemonName() {
        return "Hoopa";
    }

    @Override
    protected void giveReward(Player player) {
        ItemStack prisonBottle = new ItemStack((ItemLike)Items.NETHERITE_SWORD);
        if (!player.getInventory().add(prisonBottle)) {
            player.drop(prisonBottle, false);
        }
        player.displayClientMessage((Component)Component.literal((String)"You received a Prison Bottle!").withStyle(ChatFormatting.LIGHT_PURPLE), true);
    }

    private static Item getFirstRequiredItem() {
        String itemName = PedestalConfig.HOOPA_PEDESTAL_FIRST_ITEM;
        if ("temple_key".equals(itemName)) {
            return ModItems.TEMPLE_KEY;
        }
        try {
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item != null) {
                return item;
            }
        }
        catch (Exception e) {
            System.err.println("Could not find first item: " + itemName + ", falling back to default");
        }
        return ModItems.TEMPLE_KEY;
    }

    private static Item getSecondRequiredItem() {
        String itemName = PedestalConfig.HOOPA_PEDESTAL_SECOND_ITEM;
        if ("prison_bottle".equals(itemName)) {
            return Items.ENDER_PEARL;
        }
        try {
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item != null) {
                return item;
            }
        }
        catch (Exception e) {
            System.err.println("Could not find second item: " + itemName + ", falling back to default");
        }
        return Items.ENDER_PEARL;
    }
}

