/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import github.jorgaomc.ModItems;
import github.jorgaomc.blocks.entity.DualPedestalBlockEntity;
import github.jorgaomc.blocks.entity.ModBlockEntities;
import github.jorgaomc.config.PedestalConfig;
import github.jorgaomc.util.LegendaryEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.state.BlockState;

public class KyuremPedestalBlockEntity
extends DualPedestalBlockEntity {
    public KyuremPedestalBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.KYUREM_PEDESTAL_BE, pos, state, KyuremPedestalBlockEntity.getFirstRequiredItem(), KyuremPedestalBlockEntity.getSecondRequiredItem(), "kyuremsummon", "Ancient ice begins to form! ", "A primal frost engulfs the area! ", ChatFormatting.AQUA, ChatFormatting.BLUE);
    }

    @Override
    protected void spawnEffects(ServerLevel world, BlockPos pos) {
        LegendaryEffects.spawnRegiceEffect(world, pos);
    }

    @Override
    protected String getPokemonName() {
        return "Kyurem";
    }

    private static Item getFirstRequiredItem() {
        String itemName = PedestalConfig.KYUREM_PEDESTAL_FIRST_ITEM;
        if ("truth_bottle".equals(itemName)) {
            return ModItems.TRUTH_BOTTLE;
        }
        try {
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item != null) {
                return item;
            }
        }
        catch (Exception e) {
            System.err.println("Could not find first item: " + itemName + ", falling back to default");
        }
        return ModItems.TRUTH_BOTTLE;
    }

    private static Item getSecondRequiredItem() {
        String itemName = PedestalConfig.KYUREM_PEDESTAL_SECOND_ITEM;
        if ("ideals_bottle".equals(itemName)) {
            return ModItems.IDEALS_BOTTLE;
        }
        try {
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item != null) {
                return item;
            }
        }
        catch (Exception e) {
            System.err.println("Could not find second item: " + itemName + ", falling back to default");
        }
        return ModItems.IDEALS_BOTTLE;
    }
}

