/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.ModItems;
import github.jorgaomc.blocks.entity.BasePedestalBlockEntity;
import github.jorgaomc.blocks.entity.ModBlockEntities;
import github.jorgaomc.config.PedestalConfig;
import github.jorgaomc.util.LegendaryEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class LugiaPedestalBlockEntity
extends BasePedestalBlockEntity {
    private static final RandomSource RANDOM = RandomSource.create();
    private static final double SHINY_CHANCE = 0.02;

    public LugiaPedestalBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.LUGIA_PEDESTAL_BE, pos, state);
    }

    @Override
    public boolean handleSpecialAction(Player player, ItemStack stack) {
        Level level;
        Item requiredItem = this.getRequiredItem();
        if (!stack.is(requiredItem)) {
            return false;
        }
        if (this.hasPlayerUsed(player)) {
            if (!this.level.isClientSide) {
                player.displayClientMessage((Component)Component.literal((String)"This pedestal has already been used by you.").withStyle(ChatFormatting.RED), true);
            }
            return false;
        }
        this.clearContent();
        if (!this.level.isClientSide && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            try {
                boolean isShiny;
                this.markPlayerUsed(player);
                PokemonProperties properties = new PokemonProperties();
                properties.setSpecies("lugia");
                properties.setLevel(Integer.valueOf(60));
                boolean bl = isShiny = RANDOM.nextDouble() < 0.02;
                if (isShiny) {
                    properties.setShiny(Boolean.valueOf(true));
                }
                Pokemon pokemon = properties.create();
                ItemStack heldItem = new ItemStack((ItemLike)ModItems.SILVER_WING);
                pokemon.swapHeldItem(heldItem, false);
                BlockPos spawnPos = this.worldPosition.above();
                LegendaryEffects.spawnLugiaEffect(serverWorld, spawnPos);
                PokemonEntity entity = new PokemonEntity((Level)serverWorld, pokemon, CobblemonEntities.POKEMON);
                entity.moveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, 0.0f, 0.0f);
                serverWorld.addFreshEntity((Entity)entity);
                if (isShiny) {
                    player.displayClientMessage((Component)Component.literal((String)"A mighty wind whips around you! ").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).append((Component)Component.literal((String)"A SHINY Lugia appears!").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})), false);
                } else {
                    player.displayClientMessage((Component)Component.literal((String)"A strong wind surrounds you! ").withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.BOLD}).append((Component)Component.literal((String)"Lugia appears!").withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD})), false);
                }
                player.displayClientMessage((Component)Component.literal((String)"Lugia is holding a Silver Wing!").withStyle(ChatFormatting.AQUA), true);
                ItemStack lugiaKey = new ItemStack((ItemLike)ModItems.LUGIA_KEY);
                player.addItem(lugiaKey);
                player.displayClientMessage((Component)Component.literal((String)"You received a Lugia Key!").withStyle(ChatFormatting.AQUA), true);
                return true;
            }
            catch (Exception e) {
                System.err.println("Error spawning Lugia: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return false;
    }

    private Item getRequiredItem() {
        String itemName = PedestalConfig.LUGIA_PEDESTAL_ITEM;
        if ("vortex_stone".equals(itemName)) {
            return ModItems.VORTEX_STONE;
        }
        try {
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item != null) {
                return item;
            }
        }
        catch (Exception e) {
            System.err.println("Could not find item: " + itemName + ", falling back to default");
        }
        return ModItems.VORTEX_STONE;
    }
}

