/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import github.jorgaomc.blocks.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MeltanBoxBlockEntity
extends BlockEntity {
    private static final int REQUIRED_POINTS = 50;
    private int pointsCollected = 0;
    private boolean isReady = false;

    public MeltanBoxBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.MELTAN_BOX_BE, pos, state);
    }

    public boolean addPoints(int points) {
        boolean justReachedMax;
        if (this.isReady) {
            return true;
        }
        this.pointsCollected += points;
        boolean bl = justReachedMax = this.pointsCollected >= 50 && !this.isReady;
        if (justReachedMax) {
            this.isReady = true;
        }
        this.setChanged();
        if (this.level != null && !this.level.isClientSide) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        }
        return justReachedMax;
    }

    public int getPointsCollected() {
        return this.pointsCollected;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public void reset() {
        this.pointsCollected = 0;
        this.isReady = false;
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putInt("pointsCollected", this.pointsCollected);
        nbt.putBoolean("isReady", this.isReady);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        this.pointsCollected = nbt.getInt("pointsCollected");
        this.isReady = nbt.getBoolean("isReady");
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithoutMetadata(registryLookup);
    }
}

