/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.ModItems;
import github.jorgaomc.blocks.entity.BasePedestalBlockEntity;
import github.jorgaomc.blocks.entity.ModBlockEntities;
import github.jorgaomc.util.LegendaryEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class PalkiaPedestalBlockEntity
extends BasePedestalBlockEntity {
    private static final RandomSource RANDOM = RandomSource.create();
    private static final double SHINY_CHANCE = 0.02;

    public PalkiaPedestalBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.PALKIA_PEDESTAL_BE, pos, state);
    }

    @Override
    public boolean handleSpecialAction(Player player, ItemStack stack) {
        Level level;
        if (!stack.is(ModItems.RED_CHAIN)) {
            return false;
        }
        if (this.hasPlayerUsed(player)) {
            if (!this.level.isClientSide) {
                player.displayClientMessage((Component)Component.literal((String)"This pedestal has already been used by you.").withStyle(ChatFormatting.RED), true);
            }
            return false;
        }
        this.clearContent();
        if (!this.level.isClientSide && (level = this.level) instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            try {
                boolean isShiny;
                this.markPlayerUsed(player);
                PokemonProperties properties = new PokemonProperties();
                properties.setSpecies("palkia");
                properties.setLevel(Integer.valueOf(70));
                boolean bl = isShiny = RANDOM.nextDouble() < 0.02;
                if (isShiny) {
                    properties.setShiny(Boolean.valueOf(true));
                }
                Pokemon pokemon = properties.create();
                BlockPos spawnPos = this.worldPosition.above();
                LegendaryEffects.spawnPalkiaEffect(serverWorld, spawnPos);
                PokemonEntity entity = new PokemonEntity((Level)serverWorld, pokemon, CobblemonEntities.POKEMON);
                entity.moveTo((double)spawnPos.getX() + 0.5, (double)spawnPos.getY(), (double)spawnPos.getZ() + 0.5, 0.0f, 0.0f);
                serverWorld.addFreshEntity((Entity)entity);
                if (isShiny) {
                    player.displayClientMessage((Component)Component.literal((String)"Distorted space ripples intensely! ").withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.BOLD}).append((Component)Component.literal((String)"A SHINY Palkia appears!").withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.BOLD})), false);
                } else {
                    player.displayClientMessage((Component)Component.literal((String)"Distorted space ripples! ").withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.BOLD}).append((Component)Component.literal((String)"Palkia appears!").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD})), false);
                }
                ItemStack reward = new ItemStack((ItemLike)ModItems.SPACE_GLOBE);
                if (!player.getInventory().add(reward)) {
                    player.drop(reward, false);
                }
                player.displayClientMessage((Component)Component.literal((String)"You've received a Space Globe!").withStyle(ChatFormatting.LIGHT_PURPLE), true);
                return true;
            }
            catch (Exception e) {
                System.err.println("Error spawning Palkia: " + e.getMessage());
                e.printStackTrace();
            }
        }
        return false;
    }
}

