/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.blocks.PokemonTrialSpawnerBlock;
import github.jorgaomc.blocks.entity.ModBlockEntities;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.scores.PlayerTeam;

public class PokemonTrialSpawnerBlockEntity
extends BlockEntity {
    private static final int ACTIVATION_RADIUS = 5;
    private static final int LEASH_RADIUS = 30;
    private static final int SPAWN_RANGE = 4;
    private static final int MAX_POKEMON_PER_WAVE = 3;
    private static final int COOLDOWN_TICKS = 36000;
    private final Random random = new Random();
    private final Set<UUID> participatingPlayers = new HashSet<UUID>();
    private final List<UUID> spawnedPokemonUUIDs = new ArrayList<UUID>();
    private int currentWave = 0;
    private int maxWaves = 3;
    private int ticksSinceLastSpawn = 0;
    private boolean isActive = false;
    private int cooldownTicks = 0;
    private int ambientTick = 0;
    private long lastPlayerScanTick = -100L;
    private List<ServerPlayer> cachedNearbySurvivalPlayers = Collections.emptyList();
    private final List<Wave> waves = new ArrayList<Wave>();
    private final List<RewardEntry> rewards = new ArrayList<RewardEntry>();
    private static final String[] NORMAL_POKEMON = new String[]{"gengar", "malamar", "raichu", "altaria", "snorlax"};
    private static final String[] OMINOUS_POKEMON = new String[]{"garchomp", "gardevoir", "charizard", "venusaur", "blastoise"};

    public PokemonTrialSpawnerBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.POKEMON_TRIAL_SPAWNER_BE, pos, state);
        if (!state.hasProperty(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE) && state.getBlock() instanceof PokemonTrialSpawnerBlock) {
            this.setBlockState(state.getBlock().defaultBlockState());
        }
        this.initDefaultConfigIfEmpty();
    }

    public void serverTick(ServerLevel world, BlockPos pos, BlockState state) {
        if (!(state.getBlock() instanceof PokemonTrialSpawnerBlock) || !state.hasProperty(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE)) {
            if (world.getBlockState(pos).getBlock() instanceof PokemonTrialSpawnerBlock) {
                BlockState newState = (BlockState)((BlockState)world.getBlockState(pos).getBlock().defaultBlockState().setValue((Property)PokemonTrialSpawnerBlock.OMINOUS, (Comparable)Boolean.valueOf(false))).setValue(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)TrialSpawnerState.INACTIVE);
                world.setBlockAndUpdate(pos, newState);
            }
            return;
        }
        TrialSpawnerState currentState = (TrialSpawnerState)state.getValue(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE);
        switch (currentState) {
            case INACTIVE: {
                if (this.getNearbySurvivalPlayersCached(world, 5).isEmpty()) break;
                world.setBlockAndUpdate(pos, (BlockState)state.setValue(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)TrialSpawnerState.WAITING_FOR_PLAYERS));
                break;
            }
            case WAITING_FOR_PLAYERS: {
                this.handleWaitingForPlayers(world, pos, state);
                break;
            }
            case ACTIVE: {
                this.handleActiveTrial(world, pos, state);
                break;
            }
            case WAITING_FOR_REWARD_EJECTION: {
                this.handleWaitingForReward(world, pos, state);
                break;
            }
            case EJECTING_REWARD: {
                this.handleEjectingReward(world, pos, state);
                break;
            }
            case COOLDOWN: {
                this.handleCooldown(world, pos, state);
            }
        }
    }

    public void startTrial(Player player) {
        Level level = this.level;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            this.participatingPlayers.clear();
            this.participatingPlayers.add(player.getUUID());
            this.currentWave = 0;
            this.spawnedPokemonUUIDs.clear();
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)TrialSpawnerState.WAITING_FOR_PLAYERS));
            this.level.playSound(null, this.worldPosition, SoundEvents.TRIAL_SPAWNER_SPAWN_MOB, SoundSource.BLOCKS, 1.0f, 1.0f);
            player.displayClientMessage((Component)Component.literal((String)"Trial Started! Defeat the Pokemon!").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}), true);
        }
    }

    private void handleWaitingForPlayers(ServerLevel world, BlockPos pos, BlockState state) {
        List<ServerPlayer> nearbyPlayers = this.getNearbySurvivalPlayersCached(world, 5);
        if (!nearbyPlayers.isEmpty()) {
            for (ServerPlayer player : nearbyPlayers) {
                this.participatingPlayers.add(player.getUUID());
            }
            world.setBlockAndUpdate(pos, (BlockState)state.setValue(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)TrialSpawnerState.ACTIVE));
            this.isActive = true;
            this.spawnNextWave(world);
        }
    }

    private void handleActiveTrial(ServerLevel world, BlockPos pos, BlockState state) {
        this.spawnedPokemonUUIDs.removeIf(uuid -> {
            Entity entity = world.getEntity(uuid);
            return entity == null || !entity.isAlive();
        });
        ++this.ambientTick;
        if (this.ambientTick % 20 == 0) {
            double cx = (double)pos.getX() + 0.5;
            double cy = (double)pos.getY() + 1.2;
            double cz = (double)pos.getZ() + 0.5;
            world.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, cx, cy, cz, 4, 0.4, 0.2, 0.4, 0.0);
            if (((Boolean)state.getValue((Property)PokemonTrialSpawnerBlock.OMINOUS)).booleanValue()) {
                world.sendParticles((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, cx, cy + 0.2, cz, 1, 0.2, 0.1, 0.2, 0.0);
            }
        }
        if (this.ambientTick % 200 == 0) {
            try {
                Field ambientField = SoundEvents.class.getField("BLOCK_TRIAL_SPAWNER_AMBIENT");
                Object ambientObj = ambientField.get(null);
                if (ambientObj instanceof SoundEvent) {
                    SoundEvent ambient = (SoundEvent)ambientObj;
                    world.playSound(null, pos, ambient, SoundSource.BLOCKS, 0.6f, 1.0f);
                } else {
                    world.playSound(null, pos, SoundEvents.TRIAL_SPAWNER_SPAWN_MOB, SoundSource.BLOCKS, 0.5f, 1.0f);
                }
            }
            catch (Throwable t) {
                world.playSound(null, pos, SoundEvents.TRIAL_SPAWNER_SPAWN_MOB, SoundSource.BLOCKS, 0.5f, 1.0f);
            }
        }
        if (this.spawnedPokemonUUIDs.isEmpty()) {
            ++this.ticksSinceLastSpawn;
            if (this.ticksSinceLastSpawn > 40) {
                ++this.currentWave;
                if (this.currentWave >= this.maxWaves) {
                    world.setBlockAndUpdate(pos, (BlockState)state.setValue(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)TrialSpawnerState.WAITING_FOR_REWARD_EJECTION));
                } else {
                    this.spawnNextWave(world);
                    this.ticksSinceLastSpawn = 0;
                }
            }
        }
        if (this.getNearbySurvivalPlayersCached(world, 30).isEmpty()) {
            this.resetTrial(world, pos, state);
        }
    }

    private void handleWaitingForReward(ServerLevel world, BlockPos pos, BlockState state) {
        world.setBlockAndUpdate(pos, (BlockState)state.setValue(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)TrialSpawnerState.EJECTING_REWARD));
    }

    private void handleEjectingReward(ServerLevel world, BlockPos pos, BlockState state) {
        this.rollAndDropRewards(world);
        world.setBlockAndUpdate(pos, (BlockState)state.setValue(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)TrialSpawnerState.COOLDOWN));
        this.cooldownTicks = 36000;
        world.playSound(null, pos, SoundEvents.TRIAL_SPAWNER_EJECT_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
    }

    private void handleCooldown(ServerLevel world, BlockPos pos, BlockState state) {
        --this.cooldownTicks;
        if (this.cooldownTicks <= 0) {
            world.setBlockAndUpdate(pos, (BlockState)((BlockState)state.setValue(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)TrialSpawnerState.WAITING_FOR_PLAYERS)).setValue((Property)PokemonTrialSpawnerBlock.OMINOUS, (Comparable)Boolean.valueOf(false)));
            this.participatingPlayers.clear();
            this.spawnedPokemonUUIDs.clear();
            this.isActive = false;
            this.currentWave = 0;
        }
    }

    private void spawnNextWave(ServerLevel world) {
        this.maxWaves = Math.max(this.waves.size(), 1);
        if (this.currentWave < this.waves.size() && !this.waves.get((int)this.currentWave).spawns.isEmpty()) {
            for (SpawnEntry entry : this.waves.get((int)this.currentWave).spawns) {
                int c = Math.max(1, entry.count);
                for (int i = 0; i < c; ++i) {
                    this.spawnPokemon(world, entry.species, entry.species_features, entry.level);
                }
            }
        } else {
            boolean ominous = (Boolean)world.getBlockState(this.worldPosition).getValue((Property)PokemonTrialSpawnerBlock.OMINOUS);
            String[] pool = ominous ? OMINOUS_POKEMON : NORMAL_POKEMON;
            int count = Math.min(3, pool.length);
            for (int i = 0; i < count; ++i) {
                this.spawnPokemon(world, pool[this.random.nextInt(pool.length)], ominous ? 60 : 50);
            }
        }
    }

    private void spawnPokemon(ServerLevel world, String species, int level) {
        this.spawnPokemon(world, species, null, level);
    }

    private String normalizeFormName(String form) {
        String normalized;
        if (form == null) {
            return "";
        }
        return switch (normalized = form.toLowerCase(Locale.ROOT).replace('-', '_').trim()) {
            case "hisui" -> "hisuian";
            case "alola" -> "alolan";
            case "galar" -> "galarian";
            case "paldea" -> "paldean";
            default -> normalized;
        };
    }

    private void spawnPokemon(ServerLevel world, String species, List<String> speciesFeatures, int level) {
        try {
            PokemonEntity entity;
            block21: {
                StringBuilder propsBuilder = new StringBuilder();
                String baseSpecies = species == null ? "missingno" : species.trim();
                propsBuilder.append(baseSpecies);
                if (speciesFeatures != null && !speciesFeatures.isEmpty()) {
                    for (String feature : speciesFeatures) {
                        if (feature == null || feature.isEmpty()) continue;
                        normalized = this.normalizeFormName(feature);
                        propsBuilder.append(" ").append(normalized).append("=true");
                    }
                } else {
                    String[] parts = baseSpecies.split("\\s+");
                    if (parts.length > 1) {
                        propsBuilder = new StringBuilder(parts[0]);
                        for (int i = 1; i < parts.length; ++i) {
                            normalized = this.normalizeFormName(parts[i]);
                            propsBuilder.append(" ").append(normalized).append("=true");
                        }
                    }
                }
                propsBuilder.append(" level=").append(level);
                propsBuilder.append(" uncatchable=yes");
                String propsString = propsBuilder.toString();
                PokemonProperties properties = PokemonProperties.Companion.parse(propsString);
                Pokemon pokemon = properties.create();
                try {
                    this.setTrialPokemonUncatchable(pokemon, null);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                entity = new PokemonEntity((Level)world, pokemon, CobblemonEntities.POKEMON);
                try {
                    this.setTrialPokemonUncatchable(null, entity);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                double angle = this.random.nextDouble() * Math.PI * 2.0;
                double radius = 1.5 + this.random.nextDouble() * 0.75;
                double sx = (double)this.worldPosition.getX() + 0.5 + Math.cos(angle) * radius;
                double sz = (double)this.worldPosition.getZ() + 0.5 + Math.sin(angle) * radius;
                double sy = this.worldPosition.getY();
                entity.moveTo(sx, sy, sz, this.random.nextFloat() * 360.0f, 0.0f);
                entity.addEffect(new MobEffectInstance(MobEffects.GLOWING, Integer.MAX_VALUE, 0, false, false));
                try {
                    entity.setGlowingTag(true);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                world.addFreshEntity((Entity)entity);
                try {
                    ServerScoreboard scoreboard = world.getScoreboard();
                    PlayerTeam team = scoreboard.getPlayerTeam("lm_glow_dark_gray");
                    if (team == null) {
                        team = scoreboard.addPlayerTeam("lm_glow_dark_gray");
                        team.setColor(ChatFormatting.DARK_GRAY);
                    } else if (team.getColor() != ChatFormatting.DARK_GRAY) {
                        team.setColor(ChatFormatting.DARK_GRAY);
                    }
                    String entry = entity.getStringUUID();
                    scoreboard.addPlayerToTeam(entry, team);
                }
                catch (Throwable ignore) {
                    try {
                        ServerScoreboard scoreboard = world.getScoreboard();
                        PlayerTeam team = scoreboard.getPlayerTeam("lm_glow_dark_gray");
                        if (team == null) break block21;
                        String entry = entity.getStringUUID();
                        for (Method m : scoreboard.getClass().getMethods()) {
                            if (!m.getName().equals("addPlayerToTeam") || m.getParameterCount() != 2) continue;
                            m.invoke((Object)scoreboard, entry, team);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            this.spawnedPokemonUUIDs.add(entity.getUUID());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initDefaultConfigIfEmpty() {
        if (this.waves.isEmpty()) {
            Wave w1 = new Wave();
            w1.spawns.add(new SpawnEntry("zorua", 25, 3));
            this.waves.add(w1);
            Wave w2 = new Wave();
            w2.spawns.add(new SpawnEntry("zorua", 35, 3));
            this.waves.add(w2);
            Wave w3 = new Wave();
            w3.spawns.add(new SpawnEntry("zoroark", 50, 1));
            this.waves.add(w3);
        }
        if (this.rewards.isEmpty()) {
            this.rewards.add(new RewardEntry("minecraft:emerald", 2, 5, 0.8));
            this.rewards.add(new RewardEntry("minecraft:gold_ingot", 3, 8, 0.7));
            this.rewards.add(new RewardEntry("minecraft:diamond", 1, 2, 0.25));
        }
        this.maxWaves = this.waves.size();
    }

    private void rollAndDropRewards(ServerLevel world) {
        for (RewardEntry r : this.rewards) {
            if (r == null || r.itemId == null || !(this.random.nextDouble() <= Math.max(0.0, Math.min(1.0, r.chance)))) continue;
            int min = Math.max(1, r.min);
            int max = Math.max(min, r.max);
            int count = min + this.random.nextInt(max - min + 1);
            Item item = (Item)BuiltInRegistries.ITEM.get(this.safeId(r.itemId));
            if (item == null) continue;
            ItemStack stack = new ItemStack((ItemLike)item, count);
            ItemEntity drop = new ItemEntity((Level)world, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 1.0, (double)this.worldPosition.getZ() + 0.5, stack);
            world.addFreshEntity((Entity)drop);
        }
    }

    private ResourceLocation safeId(String str) {
        if (str == null || str.isEmpty()) {
            return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"air");
        }
        if (str.contains(":")) {
            return ResourceLocation.parse((String)str);
        }
        return ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)str);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ListTag wavesList = new ListTag();
        for (Wave w : this.waves) {
            CompoundTag wTag = new CompoundTag();
            ListTag spawnsList = new ListTag();
            for (SpawnEntry e : w.spawns) {
                CompoundTag eTag = new CompoundTag();
                eTag.putString("species", e.species);
                if (e.species_features != null && !e.species_features.isEmpty()) {
                    ListTag features = new ListTag();
                    for (String f : e.species_features) {
                        features.add((Object)StringTag.valueOf((String)f));
                    }
                    eTag.put("species_features", (Tag)features);
                }
                eTag.putInt("level", e.level);
                eTag.putInt("count", e.count);
                spawnsList.add((Object)eTag);
            }
            wTag.put("spawns", (Tag)spawnsList);
            wavesList.add((Object)wTag);
        }
        nbt.put("waves", (Tag)wavesList);
        ListTag rewardsList = new ListTag();
        for (RewardEntry r : this.rewards) {
            CompoundTag rTag = new CompoundTag();
            rTag.putString("item", r.itemId);
            rTag.putInt("min", r.min);
            rTag.putInt("max", r.max);
            rTag.putDouble("chance", r.chance);
            rewardsList.add((Object)rTag);
        }
        nbt.put("rewards", (Tag)rewardsList);
        nbt.putInt("cooldownTicks", this.cooldownTicks);
        nbt.putInt("currentWave", this.currentWave);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        int i;
        super.loadAdditional(nbt, registryLookup);
        this.waves.clear();
        this.rewards.clear();
        if (nbt.contains("waves", 9)) {
            ListTag wavesList = nbt.getList("waves", 10);
            for (i = 0; i < wavesList.size(); ++i) {
                CompoundTag wTag = wavesList.getCompound(i);
                Wave w = new Wave();
                ListTag spawnsList = wTag.getList("spawns", 10);
                for (int j = 0; j < spawnsList.size(); ++j) {
                    CompoundTag eTag = spawnsList.getCompound(j);
                    SpawnEntry e = new SpawnEntry();
                    e.species = eTag.getString("species");
                    if (eTag.contains("species_features", 9)) {
                        ListTag fList = eTag.getList("species_features", 8);
                        for (int k = 0; k < fList.size(); ++k) {
                            e.species_features.add(fList.getString(k));
                        }
                    }
                    e.level = eTag.getInt("level");
                    e.count = eTag.getInt("count");
                    w.spawns.add(e);
                }
                this.waves.add(w);
            }
        }
        if (nbt.contains("rewards", 9)) {
            ListTag rewardsList = nbt.getList("rewards", 10);
            for (i = 0; i < rewardsList.size(); ++i) {
                CompoundTag rTag = rewardsList.getCompound(i);
                RewardEntry r = new RewardEntry();
                r.itemId = rTag.getString("item");
                r.min = rTag.getInt("min");
                r.max = rTag.getInt("max");
                r.chance = rTag.getDouble("chance");
                this.rewards.add(r);
            }
        }
        this.cooldownTicks = nbt.getInt("cooldownTicks");
        this.currentWave = nbt.getInt("currentWave");
        this.initDefaultConfigIfEmpty();
    }

    private boolean isSurvival(ServerPlayer p) {
        GameType gm = p.gameMode != null ? p.gameMode.getGameModeForPlayer() : null;
        return gm == GameType.SURVIVAL;
    }

    private List<ServerPlayer> getNearbySurvivalPlayers(ServerLevel world, int radius) {
        AABB searchBox = new AABB(this.worldPosition).inflate((double)radius);
        return world.getEntitiesOfClass(ServerPlayer.class, searchBox, this::isSurvival);
    }

    private List<ServerPlayer> getNearbySurvivalPlayersCached(ServerLevel world, int radius) {
        long now = world.getGameTime();
        if (now - this.lastPlayerScanTick >= 10L) {
            AABB searchBox = new AABB(this.worldPosition).inflate(30.0);
            this.cachedNearbySurvivalPlayers = world.getEntitiesOfClass(ServerPlayer.class, searchBox, this::isSurvival);
            this.lastPlayerScanTick = now;
        }
        if (radius >= 30) {
            return this.cachedNearbySurvivalPlayers;
        }
        double cx = (double)this.worldPosition.getX() + 0.5;
        double cy = (double)this.worldPosition.getY() + 0.5;
        double cz = (double)this.worldPosition.getZ() + 0.5;
        double maxDistSq = (double)radius * (double)radius;
        ArrayList<ServerPlayer> filtered = new ArrayList<ServerPlayer>();
        for (ServerPlayer p : this.cachedNearbySurvivalPlayers) {
            if (!(p.distanceToSqr(cx, cy, cz) <= maxDistSq)) continue;
            filtered.add(p);
        }
        return filtered;
    }

    private void resetTrial(ServerLevel world, BlockPos pos, BlockState state) {
        for (UUID uuid : this.spawnedPokemonUUIDs) {
            Entity entity = world.getEntity(uuid);
            if (entity == null) continue;
            entity.discard();
        }
        this.spawnedPokemonUUIDs.clear();
        this.participatingPlayers.clear();
        this.isActive = false;
        this.currentWave = 0;
        this.ticksSinceLastSpawn = 0;
        world.setBlockAndUpdate(pos, (BlockState)state.setValue(PokemonTrialSpawnerBlock.TRIAL_SPAWNER_STATE, (Comparable)TrialSpawnerState.INACTIVE));
    }

    private void setTrialPokemonUncatchable(Pokemon pokemon, PokemonEntity entity) {
        if (pokemon != null) {
            this.tryToggleCaptureViaReflection(pokemon, new String[]{"setCapturable", "setCatchable", "setCanBeCaptured", "setCatchingAllowed"}, new String[]{"capturable", "catchable", "canBeCaptured", "catchingAllowed"});
        }
        if (entity != null) {
            this.tryToggleCaptureViaReflection(entity, new String[]{"setCapturable", "setCatchable", "setCanBeCaptured", "setCatchingAllowed", "setCaptureAllowed"}, new String[]{"capturable", "catchable", "canBeCaptured", "catchingAllowed", "captureAllowed"});
            try {
                entity.addTag("lm_trial_uncatchable");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void tryToggleCaptureViaReflection(Object target, String[] methodNames, String[] fieldNames) {
        Class<?> cls = target.getClass();
        for (String name : methodNames) {
            try {
                Method m = cls.getMethod(name, Boolean.TYPE);
                m.setAccessible(true);
                m.invoke(target, false);
                return;
            }
            catch (Throwable m) {
            }
        }
        for (String fname : fieldNames) {
            try {
                Field f = cls.getDeclaredField(fname);
                f.setAccessible(true);
                if (f.getType() != Boolean.TYPE && f.getType() != Boolean.class) continue;
                f.set(target, false);
                return;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static class Wave {
        public final List<SpawnEntry> spawns = new ArrayList<SpawnEntry>();
    }

    public static class SpawnEntry {
        public String species;
        public List<String> species_features = new ArrayList<String>();
        public int level;
        public int count;

        public SpawnEntry() {
        }

        public SpawnEntry(String species, int level, int count) {
            this.species = species;
            this.level = level;
            this.count = count;
        }

        public SpawnEntry(String species, List<String> speciesFeatures, int level, int count) {
            this.species = species;
            if (speciesFeatures != null) {
                this.species_features.addAll(speciesFeatures);
            }
            this.level = level;
            this.count = count;
        }
    }

    public static class RewardEntry {
        public String itemId;
        public int min = 1;
        public int max = 1;
        public double chance = 1.0;

        public RewardEntry() {
        }

        public RewardEntry(String itemId, int min, int max, double chance) {
            this.itemId = itemId;
            this.min = min;
            this.max = max;
            this.chance = chance;
        }
    }
}

