/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import com.cobblemon.mod.common.CobblemonItems;
import github.jorgaomc.ModItems;
import github.jorgaomc.blocks.entity.DualPedestalBlockEntity;
import github.jorgaomc.blocks.entity.ModBlockEntities;
import github.jorgaomc.config.PedestalConfig;
import github.jorgaomc.util.LegendaryEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class ReshiramPedestalBlockEntity
extends DualPedestalBlockEntity {
    public ReshiramPedestalBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.RESHIRAM_PEDESTAL_BE, pos, state, ReshiramPedestalBlockEntity.getFirstRequiredItem(), ReshiramPedestalBlockEntity.getSecondRequiredItem(), "reshiramsummon", "The essence of truth resonates! ", "The blinding light of truth shines! ", ChatFormatting.WHITE, ChatFormatting.GRAY);
    }

    @Override
    protected void spawnEffects(ServerLevel world, BlockPos pos) {
        LegendaryEffects.spawnHoOhEffect(world, pos);
    }

    @Override
    protected String getPokemonName() {
        return "Reshiram";
    }

    @Override
    protected boolean activateDualPedestals(Player player, ServerLevel world, DualPedestalBlockEntity otherPedestal) {
        boolean result = super.activateDualPedestals(player, world, otherPedestal);
        if (result) {
            ItemStack truthBottle = new ItemStack((ItemLike)ModItems.TRUTH_BOTTLE);
            player.addItem(truthBottle);
            player.displayClientMessage((Component)Component.literal((String)"You received a Truth Bottle!").withStyle(ChatFormatting.WHITE), true);
        }
        return result;
    }

    private static Item getFirstRequiredItem() {
        String itemName = PedestalConfig.RESHIRAM_PEDESTAL_FIRST_ITEM;
        if ("lightstone".equals(itemName)) {
            return ModItems.LIGHTSTONE;
        }
        try {
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item != null) {
                return item;
            }
        }
        catch (Exception e) {
            System.err.println("Could not find first item: " + itemName + ", falling back to default");
        }
        return ModItems.LIGHTSTONE;
    }

    private static Item getSecondRequiredItem() {
        String itemName = PedestalConfig.RESHIRAM_PEDESTAL_SECOND_ITEM;
        if ("cobblemon:fire_gem".equals(itemName)) {
            return CobblemonItems.FIRE_GEM;
        }
        try {
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item != null) {
                return item;
            }
        }
        catch (Exception e) {
            System.err.println("Could not find second item: " + itemName + ", falling back to default");
        }
        return CobblemonItems.FIRE_GEM;
    }
}

