/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import github.jorgaomc.blocks.SanctuaryBlock;
import github.jorgaomc.blocks.entity.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class SanctuaryBlockEntity
extends BlockEntity {
    public boolean active = true;
    public boolean explosionProtection = true;
    public boolean blockPlacement = true;
    public boolean blockBreaking = true;
    public boolean mobSpawning = true;
    public int horizontalRadius = 50;
    public int verticalRadius = 50;

    public SanctuaryBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.SANCTUARY_BE, pos, state);
    }

    public void fromData(SanctuaryBlock.SanctuaryData data) {
        this.active = data.active;
        this.explosionProtection = data.explosionProtection;
        this.blockPlacement = data.blockPlacement;
        this.blockBreaking = data.blockBreaking;
        this.mobSpawning = data.mobSpawning;
        this.horizontalRadius = data.horizontalRadius;
        this.verticalRadius = data.verticalRadius;
        this.setChanged();
    }

    public SanctuaryBlock.SanctuaryData toData() {
        return new SanctuaryBlock.SanctuaryData(this.active, this.explosionProtection, this.blockPlacement, this.blockBreaking, this.mobSpawning, this.horizontalRadius, this.verticalRadius);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        nbt.putBoolean("Active", this.active);
        nbt.putBoolean("ExplosionProtection", this.explosionProtection);
        nbt.putBoolean("BlockPlacement", this.blockPlacement);
        nbt.putBoolean("BlockBreaking", this.blockBreaking);
        nbt.putBoolean("MobSpawning", this.mobSpawning);
        nbt.putInt("HorizontalRadius", this.horizontalRadius);
        nbt.putInt("VerticalRadius", this.verticalRadius);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.loadAdditional(nbt, registryLookup);
        if (nbt.contains("Active")) {
            this.active = nbt.getBoolean("Active");
        }
        if (nbt.contains("ExplosionProtection")) {
            this.explosionProtection = nbt.getBoolean("ExplosionProtection");
        }
        if (nbt.contains("BlockPlacement")) {
            this.blockPlacement = nbt.getBoolean("BlockPlacement");
        }
        if (nbt.contains("BlockBreaking")) {
            this.blockBreaking = nbt.getBoolean("BlockBreaking");
        }
        if (nbt.contains("MobSpawning")) {
            this.mobSpawning = nbt.getBoolean("MobSpawning");
        }
        if (nbt.contains("HorizontalRadius")) {
            this.horizontalRadius = nbt.getInt("HorizontalRadius");
        }
        if (nbt.contains("VerticalRadius")) {
            this.verticalRadius = nbt.getInt("VerticalRadius");
        }
    }

    public void setLevel(Level world) {
        super.setLevel(world);
        if (world != null && !world.isClientSide) {
            SanctuaryBlock.SanctuaryData data = SanctuaryBlock.getSanctuaryData(this.worldPosition);
            data.active = this.active;
            data.explosionProtection = this.explosionProtection;
            data.blockPlacement = this.blockPlacement;
            data.blockBreaking = this.blockBreaking;
            data.mobSpawning = this.mobSpawning;
            data.horizontalRadius = this.horizontalRadius;
            data.verticalRadius = this.verticalRadius;
        }
    }
}

