/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import github.jorgaomc.blocks.entity.DualPedestalBlockEntity;
import github.jorgaomc.blocks.entity.ModBlockEntities;
import github.jorgaomc.config.PedestalConfig;
import github.jorgaomc.util.LegendaryEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class ZacianPedestalBlockEntity
extends DualPedestalBlockEntity {
    public ZacianPedestalBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ZACIAN_PEDESTAL_BE, pos, state, ZacianPedestalBlockEntity.getFirstRequiredItem(), ZacianPedestalBlockEntity.getSecondRequiredItem(), "zaciansummon", "The rusted sword resonates with ancient power! ", "The rusted sword glows with brilliant light! ", ChatFormatting.BLUE, ChatFormatting.AQUA);
    }

    @Override
    protected void spawnEffects(ServerLevel world, BlockPos pos) {
        LegendaryEffects.spawnLegendaryEffect(world, pos);
    }

    @Override
    protected String getPokemonName() {
        return "Zacian";
    }

    @Override
    protected void giveReward(Player player) {
        ItemStack rustedSword = new ItemStack((ItemLike)Items.IRON_SWORD);
        if (!player.getInventory().add(rustedSword)) {
            player.drop(rustedSword, false);
        }
        player.displayClientMessage((Component)Component.literal((String)"You received a Rusted Sword!").withStyle(ChatFormatting.AQUA), true);
    }

    private static Item getFirstRequiredItem() {
        String itemName = PedestalConfig.ZACIAN_PEDESTAL_FIRST_ITEM;
        if ("minecraft:totem_of_undying".equals(itemName)) {
            return Items.TOTEM_OF_UNDYING;
        }
        try {
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item != null) {
                return item;
            }
        }
        catch (Exception e) {
            System.err.println("Could not find first item: " + itemName + ", falling back to default");
        }
        return Items.TOTEM_OF_UNDYING;
    }

    private static Item getSecondRequiredItem() {
        String itemName = PedestalConfig.ZACIAN_PEDESTAL_SECOND_ITEM;
        if ("rusted_sword".equals(itemName)) {
            return Items.IRON_SWORD;
        }
        try {
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item != null) {
                return item;
            }
        }
        catch (Exception e) {
            System.err.println("Could not find second item: " + itemName + ", falling back to default");
        }
        return Items.IRON_SWORD;
    }
}

