/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import github.jorgaomc.blocks.entity.DualPedestalBlockEntity;
import github.jorgaomc.blocks.entity.ModBlockEntities;
import github.jorgaomc.config.PedestalConfig;
import github.jorgaomc.util.LegendaryEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class ZamazentaPedestalBlockEntity
extends DualPedestalBlockEntity {
    public ZamazentaPedestalBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ZAMAZENTA_PEDESTAL_BE, pos, state, ZamazentaPedestalBlockEntity.getFirstRequiredItem(), ZamazentaPedestalBlockEntity.getSecondRequiredItem(), "zamazentasummon", "The rusted shield radiates protective energy! ", "The rusted shield shines with brilliant light! ", ChatFormatting.RED, ChatFormatting.DARK_RED);
    }

    @Override
    protected void spawnEffects(ServerLevel world, BlockPos pos) {
        LegendaryEffects.spawnLegendaryEffect(world, pos);
    }

    @Override
    protected String getPokemonName() {
        return "Zamazenta";
    }

    @Override
    protected void giveReward(Player player) {
        ItemStack rustedShield = new ItemStack((ItemLike)Items.SHIELD);
        if (!player.getInventory().add(rustedShield)) {
            player.drop(rustedShield, false);
        }
        player.displayClientMessage((Component)Component.literal((String)"You received a Rusted Shield!").withStyle(ChatFormatting.RED), true);
    }

    private static Item getFirstRequiredItem() {
        String itemName = PedestalConfig.ZAMAZENTA_PEDESTAL_FIRST_ITEM;
        if ("minecraft:totem_of_undying".equals(itemName)) {
            return Items.TOTEM_OF_UNDYING;
        }
        try {
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item != null) {
                return item;
            }
        }
        catch (Exception e) {
            System.err.println("Could not find first item: " + itemName + ", falling back to default");
        }
        return Items.TOTEM_OF_UNDYING;
    }

    private static Item getSecondRequiredItem() {
        String itemName = PedestalConfig.ZAMAZENTA_PEDESTAL_SECOND_ITEM;
        if ("rusted_shield".equals(itemName)) {
            return Items.SHIELD;
        }
        try {
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item != null) {
                return item;
            }
        }
        catch (Exception e) {
            System.err.println("Could not find second item: " + itemName + ", falling back to default");
        }
        return Items.SHIELD;
    }
}

