/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity;

import com.cobblemon.mod.common.CobblemonItems;
import github.jorgaomc.ModItems;
import github.jorgaomc.blocks.entity.DualPedestalBlockEntity;
import github.jorgaomc.blocks.entity.ModBlockEntities;
import github.jorgaomc.config.PedestalConfig;
import github.jorgaomc.util.LegendaryEffects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;

public class ZekromPedestalBlockEntity
extends DualPedestalBlockEntity {
    public ZekromPedestalBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ZEKROM_PEDESTAL_BE, pos, state, ZekromPedestalBlockEntity.getFirstRequiredItem(), ZekromPedestalBlockEntity.getSecondRequiredItem(), "zekromsummon", "The power of ideals surges! ", "The ideals manifest with intense power! ", ChatFormatting.DARK_GRAY, ChatFormatting.BLACK);
    }

    @Override
    protected void spawnEffects(ServerLevel world, BlockPos pos) {
        LegendaryEffects.spawnElekiEffect(world, pos);
    }

    @Override
    protected String getPokemonName() {
        return "Zekrom";
    }

    @Override
    protected boolean activateDualPedestals(Player player, ServerLevel world, DualPedestalBlockEntity otherPedestal) {
        boolean result = super.activateDualPedestals(player, world, otherPedestal);
        if (result) {
            ItemStack idealsBottle = new ItemStack((ItemLike)ModItems.IDEALS_BOTTLE);
            player.addItem(idealsBottle);
            player.displayClientMessage((Component)Component.literal((String)"You received an Ideals Bottle!").withStyle(ChatFormatting.BLACK), true);
        }
        return result;
    }

    private static Item getFirstRequiredItem() {
        String itemName = PedestalConfig.ZEKROM_PEDESTAL_FIRST_ITEM;
        if ("darkstone".equals(itemName)) {
            return ModItems.DARKSTONE;
        }
        try {
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item != null) {
                return item;
            }
        }
        catch (Exception e) {
            System.err.println("Could not find first item: " + itemName + ", falling back to default");
        }
        return ModItems.DARKSTONE;
    }

    private static Item getSecondRequiredItem() {
        String itemName = PedestalConfig.ZEKROM_PEDESTAL_SECOND_ITEM;
        if ("cobblemon:electric_gem".equals(itemName)) {
            return CobblemonItems.ELECTRIC_GEM;
        }
        try {
            ResourceLocation itemId = ResourceLocation.parse((String)itemName);
            Item item = (Item)BuiltInRegistries.ITEM.get(itemId);
            if (item != null) {
                return item;
            }
        }
        catch (Exception e) {
            System.err.println("Could not find second item: " + itemName + ", falling back to default");
        }
        return CobblemonItems.ELECTRIC_GEM;
    }
}

