/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import github.jorgaomc.blocks.entity.DualPedestalBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class DualPedestalBlockEntityRenderer
implements BlockEntityRenderer<DualPedestalBlockEntity> {
    private static final RandomSource RANDOM = RandomSource.create();

    public DualPedestalBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(DualPedestalBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        ItemStack stack = entity.getItem(0);
        if (!stack.isEmpty()) {
            matrices.pushPose();
            matrices.translate(0.5f, 1.05f, 0.5f);
            matrices.scale(0.75f, 0.75f, 0.75f);
            float rotationSpeed = 2.0f;
            matrices.mulPose(Axis.YP.rotationDegrees(((float)entity.getLevel().getGameTime() + tickDelta) * rotationSpeed));
            float offset = (float)Math.sin((double)((float)entity.getLevel().getGameTime() + tickDelta) / 10.0) * 0.1f;
            matrices.translate(0.0f, offset, 0.0f);
            int lightLevel = 0xF000F0;
            itemRenderer.renderStatic(stack, ItemDisplayContext.GROUND, lightLevel, OverlayTexture.NO_OVERLAY, matrices, vertexConsumers, entity.getLevel(), 0);
            matrices.popPose();
        }
    }
}

