/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.entity.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import github.jorgaomc.blocks.entity.PedestalBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;

public class PedestalBlockEntityRenderer
implements BlockEntityRenderer<PedestalBlockEntity> {
    public PedestalBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(PedestalBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        ItemStack stack = entity.getItem(0);
        if (stack.isEmpty()) {
            return;
        }
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        matrices.pushPose();
        matrices.translate(0.5, 1.0, 0.5);
        matrices.scale(0.75f, 0.75f, 0.75f);
        long time = entity.getLevel() != null ? entity.getLevel().getGameTime() : 0L;
        float rotation = ((float)time + tickDelta) * 2.0f;
        matrices.mulPose(Axis.YP.rotationDegrees(rotation));
        int lightLevel = this.getLightLevel(entity.getLevel(), entity.getBlockPos());
        itemRenderer.renderStatic(stack, ItemDisplayContext.GROUND, lightLevel, OverlayTexture.NO_OVERLAY, matrices, vertexConsumers, entity.getLevel(), 0);
        matrices.popPose();
    }

    private int getLightLevel(Level world, BlockPos pos) {
        if (world == null) {
            return 0xF000F0;
        }
        BlockPos lightPos = pos.above();
        int blockLight = world.getBrightness(LightLayer.BLOCK, lightPos);
        int skyLight = world.getBrightness(LightLayer.SKY, lightPos);
        return LightTexture.pack((int)blockLight, (int)skyLight);
    }
}

