/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.blocks.shrine;

import com.mojang.serialization.MapCodec;
import github.jorgaomc.ShrineTracker;
import github.jorgaomc.blocks.ShrineBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.Vec3;

public class IcerendShrine
extends ShrineBlock {
    public static final MapCodec<IcerendShrine> CODEC = IcerendShrine.simpleCodec(IcerendShrine::new);

    public IcerendShrine(BlockBehaviour.Properties settings) {
        super(settings, ShrineBlock.ShrineType.ICEREND);
    }

    public MapCodec<? extends Block> codec() {
        return CODEC;
    }

    @Override
    protected int getPlayerProgress(Player player) {
        return ShrineTracker.getProgress(player, ShrineTracker.ShrineType.ICEREND);
    }

    @Override
    protected void setPlayerProgress(Player player, int progress) {
        ShrineTracker.setProgress(player, ShrineTracker.ShrineType.ICEREND, progress);
    }

    @Override
    protected String getShrineTypeName() {
        return "Icerend";
    }

    @Override
    protected void spawnPokemon(ServerLevel world, BlockPos pos, Player player) {
        world.playSound(null, (double)pos.getX() + 0.5, (double)pos.getY() + 1.5, (double)pos.getZ() + 0.5, SoundEvents.GLASS_BREAK, SoundSource.BLOCKS, 1.0f, 0.8f);
        for (int i = 0; i < 100; ++i) {
            double offsetX = world.random.nextDouble() * 3.0 - 1.5;
            double offsetY = world.random.nextDouble() * 3.0;
            double offsetZ = world.random.nextDouble() * 3.0 - 1.5;
            world.addParticle((ParticleOptions)ParticleTypes.SNOWFLAKE, (double)pos.getX() + 0.5 + offsetX, (double)pos.getY() + 1.0 + offsetY, (double)pos.getZ() + 0.5 + offsetZ, offsetX * 0.1, offsetY * 0.1, offsetZ * 0.1);
        }
        boolean isShiny = world.getRandom().nextFloat() < 0.02f;
        Object command = String.format("pokespawnat %d %d %d chien-pao lvl=50", pos.getX(), pos.getY() + 1, pos.getZ());
        if (isShiny) {
            command = (String)command + " shiny";
        }
        world.getServer().getCommands().performPrefixedCommand(world.getServer().createCommandSourceStack().withLevel(world).withPosition(new Vec3((double)pos.getX(), (double)(pos.getY() + 1), (double)pos.getZ())).withSuppressedOutput(), (String)command);
        MutableComponent message = isShiny ? Component.literal((String)"The Icerend Shrine has summoned a SHINY Chien-pao!").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}) : Component.literal((String)"The Icerend Shrine has summoned a Chien-pao!").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD});
        player.displayClientMessage((Component)message, false);
    }
}

