/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import github.jorgaomc.entities.DistortionPortalEntity;
import github.jorgaomc.entities.distortion_portal;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class DistortionPortalEntityRenderer
extends EntityRenderer<DistortionPortalEntity> {
    private final distortion_portal model;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"textures/entity/distortion_portal.png");

    public DistortionPortalEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.model = new distortion_portal(context.bakeLayer(distortion_portal.LAYER_LOCATION));
    }

    public void render(DistortionPortalEntity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        matrices.pushPose();
        matrices.translate(0.0, 1.5, 0.0);
        matrices.scale(1.0f, -1.0f, 1.0f);
        float animationTime = ((float)entity.tickCount + tickDelta) % 200.0f / 20.0f;
        this.model.setAnimationProgress(animationTime);
        int fullBright = 0xF000F0;
        int noOverlay = OverlayTexture.NO_OVERLAY;
        this.model.renderToBuffer(matrices, vertexConsumers.getBuffer(this.model.renderType(this.getTexture(entity))), fullBright, noOverlay, -1);
        matrices.popPose();
        super.render((Entity)entity, yaw, tickDelta, matrices, vertexConsumers, light);
    }

    public ResourceLocation getTexture(DistortionPortalEntity entity) {
        return TEXTURE;
    }
}

