/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.client.screen;

import com.cobblemon.mod.common.api.storage.player.client.ClientPokedexManager;
import com.cobblemon.mod.common.client.CobblemonClient;
import com.cobblemon.mod.common.client.gui.pokedex.PokedexGUI;
import com.cobblemon.mod.common.client.pokedex.PokedexType;
import com.mojang.blaze3d.systems.RenderSystem;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.client.screen.LegendaryTrackingScreen;
import github.jorgaomc.client.screen.SystemUpgradesScreen;
import github.jorgaomc.data.ClientPlayerDataCache;
import github.jorgaomc.data.PlayerAppData;
import github.jorgaomc.network.EnderChestOpenPacket;
import github.jorgaomc.network.HealPacket;
import github.jorgaomc.network.KeyItemsOpenPacket;
import github.jorgaomc.network.PCOpenPacket;
import github.jorgaomc.screen.ArcPhoneScreenHandler;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class ArcPhoneScreen
extends AbstractContainerScreen<ArcPhoneScreenHandler> {
    private static final ResourceLocation PHONE_OUTLINE = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"textures/gui/arc_phone_outline.png");
    private static final ResourceLocation PHONE_SCREEN = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"textures/gui/arc_phone_screen.png");
    private static final ResourceLocation APP_ICONS = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"textures/gui/arc_phone_app_icons.png");
    private static final int SCREEN_WIDTH = 336;
    private static final int SCREEN_HEIGHT = 200;
    private static final int APP_ICON_SIZE = 48;
    private static final int OUTLINE_X_OFFSET = 81;
    private static final int OUTLINE_Y_OFFSET = 0;
    private static final int LEFT_BAR_SPACE = 40;
    private static final int GAP_X = 20;
    private static final int GAP_Y = 8;
    private static final int TOP_PADDING = 20;
    private static final int LEFT_PADDING = 10;
    private static final int APPS_PER_ROW = 4;
    private static final AppIcon[] ALL_APP_ICONS = new AppIcon[]{new AppIcon(0, 0, "Quests"), new AppIcon(0, 0, "Legendary Tracking"), new AppIcon(0, 0, "Key Items"), new AppIcon(0, 0, "System Upgrades"), new AppIcon(0, 0, "Wiki"), new AppIcon(0, 0, "PC"), new AppIcon(0, 0, "Pok\u00e9dex"), new AppIcon(0, 0, "Heal"), new AppIcon(0, 0, "Ender Chest")};
    private AppIcon[] displayedApps = new AppIcon[0];

    public ArcPhoneScreen(ArcPhoneScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, (Component)Component.empty());
        this.imageWidth = 336;
        this.imageHeight = 200;
    }

    protected void init() {
        super.init();
        this.titleLabelX = (this.imageWidth - this.font.width((FormattedText)this.title)) / 2;
        ClientPlayerDataCache.update();
        ArrayList<AppIcon> unlockedApps = new ArrayList<AppIcon>();
        PlayerAppData appData = ClientPlayerDataCache.getAppData();
        Set<String> playerUnlockedApps = appData.getUnlockedApps();
        for (AppIcon app : ALL_APP_ICONS) {
            if (!playerUnlockedApps.contains(app.name) && !"Wiki".equals(app.name)) continue;
            unlockedApps.add(app);
        }
        this.displayedApps = unlockedApps.toArray(new AppIcon[0]);
        LegendaryMonuments.LOGGER.info("ArcPhone showing {} unlocked apps for current world", (Object)this.displayedApps.length);
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        int outlineWidth = 700;
        int outlineHeight = 390;
        int outlineX = (this.width - outlineWidth) / 2 + 81;
        int outlineY = (this.height - outlineHeight) / 2 + 0;
        int screenX = (this.width - 336) / 2;
        int screenY = (this.height - 200) / 2;
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.blit(PHONE_OUTLINE, outlineX, outlineY, 0.0f, 0.0f, outlineWidth, outlineHeight, outlineWidth, outlineHeight);
        context.blit(PHONE_SCREEN, screenX, screenY, 0.0f, 0.0f, 336, 200, 336, 200);
        for (int i = 0; i < this.displayedApps.length; ++i) {
            AppIcon app = this.displayedApps[i];
            int row = i / 4;
            int col = i % 4;
            int appX = 50 + col * 68;
            int appY = 20 + row * 56;
            app.x = appX;
            app.y = appY;
            int textureIndex = 0;
            for (int j = 0; j < ALL_APP_ICONS.length; ++j) {
                if (!ArcPhoneScreen.ALL_APP_ICONS[j].name.equals(app.name)) continue;
                textureIndex = j;
                break;
            }
            context.blit(APP_ICONS, screenX + appX, screenY + appY, 0.0f, (float)(textureIndex * 48), 48, 48, 48, 48 * ALL_APP_ICONS.length);
        }
        RenderSystem.disableBlend();
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
        int screenX = (this.width - 336) / 2;
        int screenY = (this.height - 200) / 2;
        for (AppIcon app : this.displayedApps) {
            if (!this.isMouseOverApp(mouseX, mouseY, screenX + app.x, screenY + app.y)) continue;
            context.renderTooltip(this.font, Component.nullToEmpty((String)app.name), mouseX, mouseY);
        }
    }

    protected void renderLabels(GuiGraphics context, int mouseX, int mouseY) {
    }

    private boolean isMouseOverApp(int mouseX, int mouseY, int appX, int appY) {
        return mouseX >= appX && mouseX < appX + 48 && mouseY >= appY && mouseY < appY + 48;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int screenX = (this.width - 336) / 2;
            int screenY = (this.height - 200) / 2;
            for (int i = 0; i < this.displayedApps.length; ++i) {
                AppIcon app = this.displayedApps[i];
                if (!this.isMouseOverApp((int)mouseX, (int)mouseY, screenX + app.x, screenY + app.y)) continue;
                this.handleAppClick(app.name);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void handleAppClick(String appName) {
        if (appName.equals("Legendary Tracking")) {
            if (this.minecraft != null) {
                this.onClose();
                Thread delayThread = new Thread(() -> {
                    try {
                        Thread.sleep(150L);
                        this.minecraft.execute(() -> {
                            this.minecraft.setScreen((Screen)new LegendaryTrackingScreen(new ArcPhoneScreenHandler(0, this.minecraft.player.getInventory()), this.minecraft.player.getInventory(), Component.nullToEmpty((String)"Legendary Tracking")));
                            LegendaryMonuments.LOGGER.info("Opening Legendary Tracking screen");
                        });
                    }
                    catch (InterruptedException e) {
                        LegendaryMonuments.LOGGER.error("Error while waiting to open Legendary Tracking", (Throwable)e);
                    }
                });
                delayThread.setDaemon(true);
                delayThread.start();
            }
        } else if (appName.equals("System Upgrades")) {
            if (this.minecraft != null) {
                this.onClose();
                Thread delayThread = new Thread(() -> {
                    try {
                        Thread.sleep(150L);
                        this.minecraft.execute(() -> {
                            this.minecraft.setScreen((Screen)new SystemUpgradesScreen());
                            LegendaryMonuments.LOGGER.info("Opening System Upgrades screen");
                        });
                    }
                    catch (InterruptedException e) {
                        LegendaryMonuments.LOGGER.error("Error while waiting to open System Upgrades", (Throwable)e);
                    }
                });
                delayThread.setDaemon(true);
                delayThread.start();
            }
        } else if (appName.equals("Key Items")) {
            if (this.minecraft != null && this.minecraft.player != null) {
                this.onClose();
                Thread delayThread = new Thread(() -> {
                    try {
                        Thread.sleep(150L);
                        this.minecraft.execute(() -> {
                            KeyItemsOpenPacket.sendToServer();
                            LegendaryMonuments.LOGGER.info("Opening Key Items screen");
                        });
                    }
                    catch (InterruptedException e) {
                        LegendaryMonuments.LOGGER.error("Error while waiting to open Key Items", (Throwable)e);
                    }
                });
                delayThread.setDaemon(true);
                delayThread.start();
            }
        } else if (appName.equals("PC")) {
            if (this.minecraft != null && this.minecraft.player != null) {
                this.onClose();
                Thread delayThread = new Thread(() -> {
                    try {
                        Thread.sleep(150L);
                        this.minecraft.execute(() -> {
                            PCOpenPacket.sendToServer();
                            LegendaryMonuments.LOGGER.info("Opening PC for player " + this.minecraft.player.getName().getString());
                        });
                    }
                    catch (InterruptedException e) {
                        LegendaryMonuments.LOGGER.error("Error while waiting to open PC", (Throwable)e);
                    }
                });
                delayThread.setDaemon(true);
                delayThread.start();
            }
        } else if (appName.equals("Pok\u00e9dex")) {
            if (this.minecraft != null && this.minecraft.player != null) {
                this.onClose();
                Thread delayThread = new Thread(() -> {
                    try {
                        Thread.sleep(150L);
                        this.minecraft.execute(() -> {
                            ClientPokedexManager pokedex = CobblemonClient.INSTANCE.getClientPokedexData();
                            if (pokedex != null) {
                                PokedexGUI.Companion.open(pokedex, PokedexType.WHITE, null, null);
                                LegendaryMonuments.LOGGER.info("Opening Pok\u00e9dex for player " + this.minecraft.player.getName().getString());
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        LegendaryMonuments.LOGGER.error("Error while waiting to open Pok\u00e9dex", (Throwable)e);
                    }
                });
                delayThread.setDaemon(true);
                delayThread.start();
            }
        } else if (appName.equals("Heal")) {
            if (this.minecraft != null && this.minecraft.player != null) {
                this.onClose();
                Thread delayThread = new Thread(() -> {
                    try {
                        Thread.sleep(150L);
                        this.minecraft.execute(() -> {
                            HealPacket.sendToServer();
                            LegendaryMonuments.LOGGER.info("Healing Pokemon for player " + this.minecraft.player.getName().getString());
                        });
                    }
                    catch (InterruptedException e) {
                        LegendaryMonuments.LOGGER.error("Error while waiting to heal Pokemon", (Throwable)e);
                    }
                });
                delayThread.setDaemon(true);
                delayThread.start();
            }
        } else if (appName.equals("Ender Chest")) {
            if (this.minecraft != null && this.minecraft.player != null) {
                this.onClose();
                Thread delayThread = new Thread(() -> {
                    try {
                        Thread.sleep(150L);
                        this.minecraft.execute(() -> {
                            EnderChestOpenPacket.sendToServer();
                            LegendaryMonuments.LOGGER.info("Opening Ender Chest for player " + this.minecraft.player.getName().getString());
                        });
                    }
                    catch (InterruptedException e) {
                        LegendaryMonuments.LOGGER.error("Error while waiting to open Ender Chest", (Throwable)e);
                    }
                });
                delayThread.setDaemon(true);
                delayThread.start();
            }
        } else if (appName.equals("Wiki")) {
            if (this.minecraft != null) {
                this.onClose();
                String url = "https://legendary-monuments.gitbook.io/legendary-monuments-wiki";
                Thread delayThread = new Thread(() -> {
                    try {
                        Thread.sleep(150L);
                        this.minecraft.execute(() -> {
                            this.minecraft.setScreen((Screen)new ConfirmLinkScreen(confirmed -> {
                                if (confirmed) {
                                    Util.getPlatform().openUri("https://legendary-monuments.gitbook.io/legendary-monuments-wiki");
                                }
                                this.minecraft.setScreen(null);
                            }, "https://legendary-monuments.gitbook.io/legendary-monuments-wiki", true));
                            LegendaryMonuments.LOGGER.info("Prompting to open Wiki link: https://legendary-monuments.gitbook.io/legendary-monuments-wiki");
                        });
                    }
                    catch (InterruptedException e) {
                        LegendaryMonuments.LOGGER.error("Error while waiting to open Wiki link", (Throwable)e);
                    }
                });
                delayThread.setDaemon(true);
                delayThread.start();
            }
        } else {
            LegendaryMonuments.LOGGER.info("Clicked on app: " + appName);
        }
    }

    private static class AppIcon {
        public int x;
        public int y;
        public final String name;

        public AppIcon(int x, int y, String name) {
            this.x = x;
            this.y = y;
            this.name = name;
        }
    }
}

