/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import github.jorgaomc.client.screen.KeyItemsScreenHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;

public class KeyItemsScreen
extends AbstractContainerScreen<KeyItemsScreenHandler> {
    private static final ResourceLocation PHONE_OUTLINE = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"textures/gui/arc_phone_outline.png");
    private static final ResourceLocation PHONE_APP_SCREEN = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"textures/gui/arc_phone_app_screen.png");
    private static final ResourceLocation KEY_ITEM_STORAGE = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"textures/gui/arc_phone_key_item_storage.png");
    private static final ResourceLocation KEY_ITEM_AVAILABLE = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"textures/gui/arc_phone_key_item_available.png");
    private static final ResourceLocation PLAYER_INVENTORY_BG = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/gui/container/generic_54.png");
    private static final int PHONE_OUTLINE_WIDTH = 700;
    private static final int PHONE_OUTLINE_HEIGHT = 390;
    private static final int PHONE_SCREEN_WIDTH = 330;
    private static final int PHONE_SCREEN_HEIGHT = 194;
    private static final int STORAGE_WIDTH = 175;
    private static final int STORAGE_HEIGHT = 173;
    private static final int AVAILABLE_WIDTH = 90;
    private static final int AVAILABLE_HEIGHT = 173;
    private static final int OUTLINE_X_OFFSET = 81;
    private static final int PHONE_VERTICAL_OFFSET = -50;
    private static final int STORAGE_VERTICAL_OFFSET = 10;

    public KeyItemsScreen(KeyItemsScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.imageWidth = 305;
        this.imageHeight = 273;
    }

    protected void init() {
        super.init();
        this.titleLabelX = -1000;
        this.titleLabelY = -1000;
        this.inventoryLabelY = this.imageHeight - 94;
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int outlineX = centerX - 350 + 81;
        int outlineY = centerY - 195 + -50;
        int phoneScreenX = centerX - 165;
        int phoneScreenY = centerY - 97 + -50;
        int combinedWidth = 265;
        int storageX = phoneScreenX - (combinedWidth - 330) / 2;
        int availableX = storageX + 175;
        int storageY = phoneScreenY + 10;
        int playerInvBgX = storageX;
        int playerInvBgY = storageY + 173 + 14;
        int playerInvBgWidth = 265;
        int playerInvBgHeight = 76;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.blit(PHONE_OUTLINE, outlineX, outlineY, 0.0f, 0.0f, 700, 390, 700, 390);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        context.blit(PHONE_APP_SCREEN, phoneScreenX, phoneScreenY, 0.0f, 0.0f, 330, 194, 330, 194);
        context.blit(KEY_ITEM_STORAGE, storageX, storageY, 0.0f, 0.0f, 175, 173, 175, 173);
        context.blit(KEY_ITEM_AVAILABLE, availableX, storageY, 0.0f, 0.0f, 90, 173, 90, 173);
        RenderSystem.disableBlend();
        context.fill(playerInvBgX, playerInvBgY, playerInvBgX + playerInvBgWidth, playerInvBgY + playerInvBgHeight, -2146430960);
        context.renderOutline(playerInvBgX, playerInvBgY, playerInvBgWidth, playerInvBgHeight, -1433695349);
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
        this.renderTooltip(context, mouseX, mouseY);
    }

    public void renderBackground(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.renderBackground(context, mouseX, mouseY, delta);
    }

    protected void renderLabels(GuiGraphics context, int mouseX, int mouseY) {
        int centerX = this.width / 2 - this.leftPos;
        int centerY = this.height / 2 - this.topPos;
        int phoneScreenX = centerX - 165;
        int phoneScreenY = centerY - 97 + -50;
        int combinedWidth = 265;
        int storageStartX = phoneScreenX - (combinedWidth - 330) / 2;
        int baseLabelY = phoneScreenY + 10 + 25;
        Component storageLabel = Component.nullToEmpty((String)"Key Items Storage");
        int storageLabelX = storageStartX + 87 - this.font.width((FormattedText)storageLabel) / 2;
        int storageLabelY = baseLabelY + 3;
        context.drawString(this.font, storageLabel, storageLabelX, storageLabelY, 0xFFFFFF, false);
        Component validLine1 = Component.nullToEmpty((String)"Valid");
        Component validLine2 = Component.nullToEmpty((String)"Items");
        int availableLabelX = storageStartX + 175 + 45;
        int validLabelY = baseLabelY - 10;
        int valid1X = availableLabelX - this.font.width((FormattedText)validLine1) / 2;
        int valid2X = availableLabelX - this.font.width((FormattedText)validLine2) / 2;
        context.drawString(this.font, validLine1, valid1X, validLabelY, 0xFFFFFF, false);
        context.drawString(this.font, validLine2, valid2X, validLabelY + 10, 0xFFFFFF, false);
        context.drawString(this.font, this.playerInventoryTitle, this.inventoryLabelX, this.inventoryLabelY, 0x404040, false);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

