/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.client.screen;

import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModItems;
import github.jorgaomc.data.KeyItemsDataManager;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class KeyItemsScreenHandler
extends AbstractContainerMenu {
    public static final int STORAGE_ROWS = 7;
    public static final int STORAGE_COLS = 9;
    public static final int STORAGE_SIZE = 63;
    private final Container storageInventory;
    private final Player player;
    private static final Set<Item> ALLOWED_KEY_ITEMS = Set.of(ModItems.GRASSWITHER_SEAL, ModItems.ICEREND_SEAL, ModItems.GROUNDBLIGHT_SEAL, ModItems.FIRESCOURGE_SEAL, ModItems.MAGMA_STONE, ModItems.YELLOW_FEATHER, ModItems.BLUE_FEATHER, ModItems.RED_FEATHER, ModItems.ZAP_STONE, ModItems.ARCTIC_STONE, ModItems.MOLTEN_STONE, ModItems.VORTEX_STONE, ModItems.GS_BALL, ModItems.RAINBOW_FEATHER, ModItems.IDEALS_BOTTLE, ModItems.TRUTH_BOTTLE, ModItems.DARKSTONE, ModItems.DARKSTONE_SHARD, ModItems.LIGHTSTONE, ModItems.LIGHTSTONE_SHARD, ModItems.DYNA_APPLE, ModItems.SPECIAL_MEAT_CHUNKS, ModItems.SPECIAL_SPICES, ModItems.SPECIAL_LEAFY_GREENS, ModItems.GALAR_PARTICLE, ModItems.UXIE_CLAW, ModItems.AZELF_FANG, ModItems.MESPRIT_PLUME, ModItems.RED_CHAIN, ModItems.POKETREAT_BOX, ModItems.LATIAS_TREAT, ModItems.LATIOS_TREAT, ModItems.SUICUNE_TREAT, ModItems.RAIKOU_TREAT, ModItems.ENTEI_TREAT, ModItems.TIME_GLOBE, ModItems.SPACE_GLOBE, ModItems.ANTIMATTER_GLOBE, ModItems.CELESTICA_FLUTE, ModItems.TITAN_KEY, ModItems.ELECTRIC_GOLEM_KEY, ModItems.ROCK_GOLEM_KEY, ModItems.DRAGON_GOLEM_KEY, ModItems.ICE_GOLEM_KEY, ModItems.STEEL_GOLEM_KEY, ModItems.OLD_SEA_MAP);

    public KeyItemsScreenHandler(int syncId, Inventory playerInventory) {
        super(LegendaryMonuments.KEY_ITEMS_SCREEN_HANDLER, syncId);
        Player player;
        this.player = playerInventory.player;
        LegendaryMonuments.LOGGER.info("=== KeyItemsScreenHandler Constructor ===");
        LegendaryMonuments.LOGGER.info("Player: {}", (Object)this.player.getName().getString());
        LegendaryMonuments.LOGGER.info("World is client: {}", (Object)this.player.level().isClientSide());
        LegendaryMonuments.LOGGER.info("Player is ServerPlayerEntity: {}", (Object)(this.player instanceof ServerPlayer));
        if (!this.player.level().isClientSide() && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            LegendaryMonuments.LOGGER.info("SERVER SIDE - Loading persistent inventory");
            ServerLevel world = (ServerLevel)serverPlayer.level();
            KeyItemsDataManager dataManager = KeyItemsDataManager.getOrCreate(world);
            this.storageInventory = dataManager.getKeyItemsInventory(this.player);
            int existingItems = 0;
            for (int i = 0; i < this.storageInventory.getContainerSize(); ++i) {
                if (this.storageInventory.getItem(i).isEmpty()) continue;
                ++existingItems;
            }
            LegendaryMonuments.LOGGER.info("Loaded existing inventory with {} items", (Object)existingItems);
        } else {
            LegendaryMonuments.LOGGER.info("CLIENT SIDE - Creating temporary inventory");
            this.storageInventory = new SimpleContainer(63);
        }
        this.setupSlots(playerInventory);
    }

    private void setupSlots(Inventory playerInventory) {
        int col;
        int storageStartX = 28;
        int storageStartY = 44;
        for (int row = 0; row < 7; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                int slotIndex = row * 9 + col2;
                this.addSlot(new KeyItemSlot(this.storageInventory, slotIndex, storageStartX + col2 * 18, storageStartY + row * 18));
            }
        }
        int invStartY = storageStartY + 126 + 14;
        for (int row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                int slotIndex = col + row * 9 + 9;
                this.addSlot(new Slot((Container)playerInventory, slotIndex, storageStartX + col * 18, invStartY + row * 18));
            }
        }
        int hotbarY = invStartY + 54 + 4;
        for (col = 0; col < 9; ++col) {
            this.addSlot(new Slot((Container)playerInventory, col, storageStartX + col * 18, hotbarY));
        }
    }

    public ItemStack quickMoveStack(Player player, int slotIndex) {
        LegendaryMonuments.LOGGER.info("=== QUICKMOVE DEBUG ===");
        LegendaryMonuments.LOGGER.info("Slot index: {}, Player: {}", (Object)slotIndex, (Object)player.getName().getString());
        LegendaryMonuments.LOGGER.info("World is client: {}", (Object)player.level().isClientSide());
        if (slotIndex < 0 || slotIndex >= this.slots.size()) {
            return ItemStack.EMPTY;
        }
        Slot slot = (Slot)this.slots.get(slotIndex);
        if (!slot.hasItem()) {
            return ItemStack.EMPTY;
        }
        ItemStack original = slot.getItem();
        ItemStack copy = original.copy();
        LegendaryMonuments.LOGGER.info("Moving item: {} x{}", (Object)original.getItem().toString(), (Object)original.getCount());
        if (slotIndex < 63) {
            if (!this.moveItemStackTo(original, 63, this.slots.size(), true)) {
                return ItemStack.EMPTY;
            }
        } else {
            if (!ALLOWED_KEY_ITEMS.contains(original.getItem())) {
                return ItemStack.EMPTY;
            }
            if (!this.moveItemStackTo(original, 0, 63, false)) {
                return ItemStack.EMPTY;
            }
        }
        if (original.isEmpty()) {
            slot.setByPlayer(ItemStack.EMPTY);
        } else {
            slot.setChanged();
        }
        this.saveInventoryDataDebug("quickMove");
        return copy;
    }

    public void clicked(int slotIndex, int button, ClickType actionType, Player player) {
        LegendaryMonuments.LOGGER.info("=== SLOT CLICK DEBUG ===");
        LegendaryMonuments.LOGGER.info("Slot: {}, Button: {}, Action: {}, Player: {}", new Object[]{slotIndex, button, actionType, player.getName().getString()});
        super.clicked(slotIndex, button, actionType, player);
        this.saveInventoryDataDebug("slotClick");
    }

    public void removed(Player player) {
        LegendaryMonuments.LOGGER.info("=== SCREEN CLOSED DEBUG ===");
        LegendaryMonuments.LOGGER.info("Player: {}", (Object)player.getName().getString());
        LegendaryMonuments.LOGGER.info("World is client: {}", (Object)player.level().isClientSide());
        super.removed(player);
        int itemCount = 0;
        for (int i = 0; i < this.storageInventory.getContainerSize(); ++i) {
            if (this.storageInventory.getItem(i).isEmpty()) continue;
            ItemStack stack = this.storageInventory.getItem(i);
            LegendaryMonuments.LOGGER.info("Slot {}: {} x{}", new Object[]{i, stack.getItem().toString(), stack.getCount()});
            ++itemCount;
        }
        LegendaryMonuments.LOGGER.info("Total items to save: {}", (Object)itemCount);
        this.saveInventoryDataDebug("screenClose");
    }

    private void saveInventoryDataDebug(String trigger) {
        LegendaryMonuments.LOGGER.info("=== SAVE ATTEMPT ({}) ===", (Object)trigger);
        LegendaryMonuments.LOGGER.info("Player: {}", (Object)this.player.getName().getString());
        LegendaryMonuments.LOGGER.info("World is client: {}", (Object)this.player.level().isClientSide());
        LegendaryMonuments.LOGGER.info("Player instanceof ServerPlayerEntity: {}", (Object)(this.player instanceof ServerPlayer));
        if (this.player.level().isClientSide()) {
            LegendaryMonuments.LOGGER.info("SKIPPING SAVE - Client side");
            return;
        }
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            LegendaryMonuments.LOGGER.error("SKIPPING SAVE - Player is not ServerPlayerEntity");
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        try {
            LegendaryMonuments.LOGGER.info("Attempting server-side save...");
            ServerLevel world = (ServerLevel)serverPlayer.level();
            LegendaryMonuments.LOGGER.info("Got ServerWorld: {}", (Object)world.dimension().location());
            KeyItemsDataManager dataManager = KeyItemsDataManager.getOrCreate(world);
            LegendaryMonuments.LOGGER.info("Got DataManager: {}", (Object)(dataManager != null ? "SUCCESS" : "NULL"));
            if (dataManager == null) {
                LegendaryMonuments.LOGGER.error("DataManager is null! Cannot save.");
                return;
            }
            int itemCount = 0;
            for (int i = 0; i < this.storageInventory.getContainerSize(); ++i) {
                if (this.storageInventory.getItem(i).isEmpty()) continue;
                ++itemCount;
            }
            LegendaryMonuments.LOGGER.info("Saving {} items to data manager", (Object)itemCount);
            dataManager.savePlayerKeyItems(this.player, this.storageInventory);
            LegendaryMonuments.LOGGER.info("Save method completed successfully");
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("SAVE FAILED with exception: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean fromLast) {
        boolean result = super.moveItemStackTo(stack, startIndex, endIndex, fromLast);
        if (result) {
            LegendaryMonuments.LOGGER.info("insertItem successful, triggering save");
            this.saveInventoryDataDebug("insertItem");
        }
        return result;
    }

    private static class KeyItemSlot
    extends Slot {
        public KeyItemSlot(Container inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean mayPlace(ItemStack stack) {
            return ALLOWED_KEY_ITEMS.contains(stack.getItem());
        }
    }
}

