/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import github.jorgaomc.ModItems;
import github.jorgaomc.client.screen.ChunkImage;
import github.jorgaomc.network.LegendaryTrackingPayloads;
import github.jorgaomc.screen.ArcPhoneScreenHandler;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegendaryTrackingScreen
extends AbstractContainerScreen<ArcPhoneScreenHandler> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegendaryTrackingScreen.class);
    private static final ResourceLocation PHONE_OUTLINE = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"textures/gui/arc_phone_outline.png");
    private static final ResourceLocation PHONE_SCREEN = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"textures/gui/arc_phone_app_screen.png");
    private static final ResourceLocation TRACKING_ARROW = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"textures/gui/tracking_arrow.png");
    private static final ResourceLocation ICON_FALLBACK = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/item/barrier.png");
    private static final ResourceLocation LOCATE_REQUEST_ID = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"locate_request");
    private static final ResourceLocation LOCATE_RESPONSE_ID = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"locate_response");
    private static final ResourceLocation KEYITEM_REQUEST_ID = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"keyitem_check_request");
    private static final ResourceLocation KEYITEM_RESPONSE_ID = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"keyitem_check_response");
    private static final int PHONE_OUTLINE_WIDTH = 700;
    private static final int PHONE_OUTLINE_HEIGHT = 390;
    private static final int PHONE_SCREEN_WIDTH = 330;
    private static final int PHONE_SCREEN_HEIGHT = 194;
    private static final int MAP_WIDTH = 240;
    private static final int MAP_HEIGHT = 112;
    private static final int MAP_CELL_SIZE = 16;
    private static final int OUTLINE_X_OFFSET = 81;
    private static final int OUTLINE_Y_OFFSET = 0;
    private Button dropdownButton;
    private boolean dropdownOpen = false;
    private int scrollOffset = 0;
    private static final int DROPDOWN_HEIGHT = 100;
    private static final int ITEM_HEIGHT = 15;
    private static final Map<String, Boolean> KEY_ITEM_CACHE = new HashMap<String, Boolean>();
    private static final Map<String, Long> KEY_ITEM_LAST_REQUEST = new HashMap<String, Long>();
    private static final long KEY_ITEM_REQUEST_COOLDOWN_MS = 3000L;
    private static int staticSelectedStructureIndex = 0;
    private int selectedStructureIndex = staticSelectedStructureIndex;
    private static Set<String> completedStructures = new HashSet<String>();
    private static final int STRUCTURE_ICON_SIZE = 12;
    private static final StructureData[] STRUCTURES = new StructureData[]{new StructureData("Dragonspiral Tower", ModItems.LIGHTSTONE_SHARD, "legendarymonuments:dragonspiraltower"), new StructureData("Turnback Cave", Items.TRIAL_KEY, "legendarymonuments:turnback_cave"), new StructureData("Bell Tower", ModItems.RAINBOW_FEATHER, "legendarymonuments:bell_tower"), new StructureData("Burned Tower", Items.FIRE_CHARGE, "legendarymonuments:burned_tower"), new StructureData("Heatran Cave", ModItems.MAGMA_STONE, "legendarymonuments:heatran_cave"), new StructureData("Firescourge Shrine", ModItems.FIRESCOURGE_SEAL, "legendarymonuments:firescourge_shrine"), new StructureData("Grasswither Shrine", ModItems.GRASSWITHER_SEAL, "legendarymonuments:grasswither_shrine"), new StructureData("Groundblight Shrine", ModItems.GROUNDBLIGHT_SEAL, "legendarymonuments:groundblight_shrine"), new StructureData("Icerend Shrine", ModItems.ICEREND_SEAL, "legendarymonuments:icerend_shrine"), new StructureData("Outskirt Stand", Items.EMERALD, "legendarymonuments:outskirt_stand"), new StructureData("Southern Island", Items.AXOLOTL_BUCKET, "legendarymonuments:southern_island"), new StructureData("SV Pokemon Center", Items.GOLDEN_APPLE, "legendarymonuments:svpokecenter"), new StructureData("Lugia Temple", ModItems.VORTEX_STONE, "legendarymonuments:lugia_temple"), new StructureData("Eternatus Cocoon", ModItems.GALAR_PARTICLE, "legendarymonuments:eternatus_cocoon"), new StructureData("Sword Monument", Items.IRON_SWORD, "legendarymonuments:sword"), new StructureData("Shield Monument", Items.SHIELD, "legendarymonuments:shield"), new StructureData("Kyurem Cave", ModItems.IDEALS_BOTTLE, "legendarymonuments:kyuremcave"), new StructureData("Dyna Tree", Items.CHERRY_SAPLING, "legendarymonuments:dyna_tree"), new StructureData("Giratina Island", Items.NETHERITE_SCRAP, "legendarymonuments:giratina_island"), new StructureData("Final Island", ModItems.OLD_SEA_MAP, "legendarymonuments:final_island"), new StructureData("Snowpoint Temple", ModItems.GOLEM_SCRAP, "legendarymonuments:snowpoint_temple"), new StructureData("Spear Pillar", ModItems.RED_CHAIN, "legendarymonuments:spear_pillar"), new StructureData("Lake Valor", Items.FERMENTED_SPIDER_EYE, "legendarymonuments:lake_valor"), new StructureData("Lake Acuity", Items.SWEET_BERRIES, "legendarymonuments:lake_acuity"), new StructureData("Lake Verity", Items.GLOW_BERRIES, "legendarymonuments:lake_verity")};
    private String errorMessage = null;
    private int errorTimer = 0;
    private static final int MAX_CHUNK_CACHE = 300;
    private final Map<ChunkPos, ChunkImage> chunkImageCache = new LinkedHashMap<ChunkPos, ChunkImage>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<ChunkPos, ChunkImage> eldest) {
            if (this.size() > 300) {
                try {
                    if (eldest.getValue() != null) {
                        eldest.getValue().dispose();
                    }
                }
                catch (Throwable t) {
                    LOGGER.warn("Failed to dispose chunk image", t);
                }
                return true;
            }
            return false;
        }
    };
    private int cachedMapX = 0;
    private int cachedMapY = 0;
    private int locateRequestCooldown = 0;
    private static final int LOCATE_REQUEST_COOLDOWN_TICKS = 20;
    private static final long STRUCTURE_REQUEST_COOLDOWN_MS = 5000L;

    private static boolean idsMatch(String idA, String idB) {
        String bB;
        String nsB;
        if (idA == null || idB == null) {
            return false;
        }
        if (idA.equals(idB)) {
            return true;
        }
        int ca = idA.indexOf(58);
        int cb = idB.indexOf(58);
        if (ca <= 0 || cb <= 0) {
            return false;
        }
        String nsA = idA.substring(0, ca);
        if (!nsA.equals(nsB = idB.substring(0, cb))) {
            return false;
        }
        String pA = idA.substring(ca + 1);
        String pB = idB.substring(cb + 1);
        String bA = LegendaryTrackingScreen.basePath(pA);
        if (bA.equals(bB = LegendaryTrackingScreen.basePath(pB))) {
            return true;
        }
        return pA.startsWith(bB) || pB.startsWith(bA);
    }

    private static String basePath(String path) {
        int i;
        if (path == null || path.isEmpty()) {
            return path;
        }
        for (i = path.length() - 1; i >= 0 && Character.isDigit(path.charAt(i)); --i) {
        }
        if (i >= 0 && (path.charAt(i) == '_' || path.charAt(i) == '-')) {
            return path.substring(0, i);
        }
        return path.substring(0, i + 1);
    }

    public static void registerPayloadTypes() {
        try {
            PayloadTypeRegistry.playC2S().register(LocateRequestPayload.ID, LocateRequestPayload.CODEC);
            PayloadTypeRegistry.playS2C().register(LocateResponsePayload.ID, LocateResponsePayload.CODEC);
            PayloadTypeRegistry.playC2S().register(KeyItemCheckRequestPayload.ID, KeyItemCheckRequestPayload.CODEC);
            PayloadTypeRegistry.playS2C().register(KeyItemCheckResponsePayload.ID, KeyItemCheckResponsePayload.CODEC);
            LOGGER.info("Registered LegendaryTrackingScreen payload types");
        }
        catch (Exception e) {
            LOGGER.error("Failed to register LegendaryTrackingScreen payload types", (Throwable)e);
            throw e;
        }
    }

    public LegendaryTrackingScreen(ArcPhoneScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, (Component)Component.empty());
        this.imageWidth = 330;
        this.imageHeight = 194;
        this.selectedStructureIndex = staticSelectedStructureIndex;
        LOGGER.info("LegendaryTrackingScreen initialized with selected index: {}", (Object)this.selectedStructureIndex);
    }

    protected void init() {
        super.init();
        this.titleLabelX = -1000;
        if (this.selectedStructureIndex < 0 || this.selectedStructureIndex >= STRUCTURES.length) {
            this.selectedStructureIndex = 0;
            staticSelectedStructureIndex = 0;
        }
        int buttonX = (this.width - 120) / 2;
        int buttonY = this.height / 2 - 75;
        this.dropdownButton = Button.builder((Component)Component.nullToEmpty((String)this.getSelectedStructureName()), button -> this.toggleDropdown()).bounds(buttonX, buttonY, 120, 20).build();
        this.addRenderableWidget((GuiEventListener)this.dropdownButton);
        LOGGER.info("Screen initialized with structure: {}", (Object)this.getSelectedStructureName());
    }

    public void removed() {
        super.removed();
        staticSelectedStructureIndex = this.selectedStructureIndex;
        LOGGER.info("Screen closed, saved selected index: {}", (Object)this.selectedStructureIndex);
        for (ChunkImage ci : this.chunkImageCache.values()) {
            try {
                ci.dispose();
            }
            catch (Throwable t) {
                LOGGER.warn("Error disposing chunk image", t);
            }
        }
        this.chunkImageCache.clear();
    }

    private void toggleDropdown() {
        this.dropdownOpen = !this.dropdownOpen;
    }

    private String getSelectedStructureName() {
        if (this.selectedStructureIndex >= 0 && this.selectedStructureIndex < STRUCTURES.length) {
            return LegendaryTrackingScreen.STRUCTURES[this.selectedStructureIndex].name;
        }
        return "Select Structure";
    }

    private boolean hasRequiredItem(StructureData structure) {
        if (this.minecraft == null || this.minecraft.player == null) {
            return false;
        }
        try {
            for (ItemStack s : this.minecraft.player.getInventory().items) {
                if (s == null || s.isEmpty() || s.getItem() != structure.requiredItem) continue;
                LOGGER.debug("Found {} in player inventory", (Object)structure.requiredItem.getDescription().getString());
                return true;
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Error checking inventory", t);
        }
        try {
            long last;
            String itemId = BuiltInRegistries.ITEM.getKey((Object)structure.requiredItem).toString();
            Boolean cached = KEY_ITEM_CACHE.get(itemId);
            if (cached != null) {
                if (cached.booleanValue()) {
                    LOGGER.debug("Server cache says player has {} in Key Items", (Object)itemId);
                }
                return cached;
            }
            long now = System.currentTimeMillis();
            if (now - (last = KEY_ITEM_LAST_REQUEST.getOrDefault(itemId, 0L).longValue()) > 3000L) {
                KEY_ITEM_LAST_REQUEST.put(itemId, now);
                try {
                    ClientPlayNetworking.send((CustomPacketPayload)new LegendaryTrackingPayloads.KeyItemCheckRequestPayload(itemId));
                    LOGGER.debug("Requested key item presence for {}", (Object)itemId);
                }
                catch (Throwable sendErr) {
                    LOGGER.warn("Failed to send key item check request: {}", (Object)sendErr.getMessage());
                }
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Key item check request failed (non-fatal)", t);
        }
        LOGGER.debug("Required item {} not found locally; awaiting server key-items response for {}", (Object)structure.requiredItem.getDescription().getString(), (Object)structure.name);
        return false;
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int outlineX = centerX - 350 + 81;
        int outlineY = centerY - 195 + 0;
        int phoneScreenX = centerX - 165;
        int phoneScreenY = centerY - 97;
        this.cachedMapX = phoneScreenX + 45;
        this.cachedMapY = phoneScreenY + 50;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.blit(PHONE_OUTLINE, outlineX, outlineY, 0.0f, 0.0f, 700, 390, 700, 390);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        context.blit(PHONE_SCREEN, phoneScreenX, phoneScreenY, 0.0f, 0.0f, 330, 194, 330, 194);
        RenderSystem.disableBlend();
        context.fill(this.cachedMapX, this.cachedMapY, this.cachedMapX + 240, this.cachedMapY + 112, -16777216);
        this.drawMapWithChunks(context, this.cachedMapX, this.cachedMapY);
        int playerX = this.cachedMapX + 120;
        int playerY = this.cachedMapY + 56;
        context.fill(playerX - 2, playerY - 2, playerX + 2, playerY + 2, -16711936);
        RenderSystem.disableBlend();
    }

    private void drawMapWithChunks(GuiGraphics context, int mapX, int mapY) {
        if (this.minecraft == null || this.minecraft.player == null || this.minecraft.level == null) {
            return;
        }
        BlockPos playerPos = this.minecraft.player.blockPosition();
        int playerChunkX = playerPos.getX() >> 4;
        int playerChunkZ = playerPos.getZ() >> 4;
        int chunksHorizontal = Math.max(1, (int)Math.ceil(15.0));
        int chunksVertical = Math.max(1, (int)Math.ceil(7.0));
        int startChunkX = playerChunkX - chunksHorizontal / 2;
        int startChunkZ = playerChunkZ - chunksVertical / 2;
        for (int x = 0; x < chunksHorizontal; ++x) {
            for (int z = 0; z < chunksVertical; ++z) {
                int chunkX = startChunkX + x;
                int chunkZ = startChunkZ + z;
                ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                int cellX = mapX + x * 16;
                int cellY = mapY + z * 16;
                ChunkImage chunkImage = this.chunkImageCache.get(chunkPos);
                if (chunkImage == null) {
                    try {
                        chunkImage = new ChunkImage((Level)this.minecraft.level, chunkPos, playerPos.getY());
                        this.chunkImageCache.put(chunkPos, chunkImage);
                    }
                    catch (Throwable t) {
                        LOGGER.debug("Failed to create ChunkImage", t);
                    }
                }
                if (chunkImage != null) {
                    try {
                        chunkImage.bindTexture();
                        context.blit(chunkImage.textureId, cellX, cellY, 0.0f, 0.0f, 16, 16, 16, 16);
                    }
                    catch (Throwable t) {
                        context.fill(cellX, cellY, cellX + 16, cellY + 16, -12303292);
                    }
                } else {
                    context.fill(cellX, cellY, cellX + 16, cellY + 16, -12303292);
                }
                context.renderOutline(cellX, cellY, 16, 16, -10066330);
            }
        }
        this.drawStructureIcons(context, mapX, mapY, this.minecraft.player.blockPosition());
    }

    private void drawStructureIcons(GuiGraphics context, int mapX, int mapY, BlockPos playerPos) {
        for (StructureData structure : STRUCTURES) {
            if (!structure.isLocated || structure.position == null) continue;
            int structureMapX = mapX + 120 + (structure.position.getX() - playerPos.getX()) * 16 / 16;
            int structureMapY = mapY + 56 + (structure.position.getZ() - playerPos.getZ()) * 16 / 16;
            if (structureMapX < mapX || structureMapX > mapX + 240 - 12 || structureMapY < mapY || structureMapY > mapY + 112 - 12) continue;
            ResourceLocation structureIcon = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)("textures/gui/structure_icons/" + structure.iconName + ".png"));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            try {
                context.blit(structureIcon, structureMapX - 6, structureMapY - 6, 0.0f, 0.0f, 12, 12, 12, 12);
                if (structure.isCompleted) {
                    context.drawString(this.minecraft.font, "\u2713", structureMapX + 6, structureMapY - 6 - 2, -11141291, true);
                }
            }
            catch (Throwable t) {
                int color = structure.isCompleted ? -11141291 : -43691;
                context.fill(structureMapX - 3, structureMapY - 3, structureMapX + 3, structureMapY + 3, color);
            }
            RenderSystem.disableBlend();
        }
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        super.render(context, mouseX, mouseY, delta);
        if (this.errorTimer > 0) {
            --this.errorTimer;
            if (this.errorTimer <= 0) {
                this.errorMessage = null;
            }
        }
        this.drawTrackingInfo(context);
        if (this.dropdownOpen) {
            this.drawDropdown(context, mouseX, mouseY);
        }
        if (this.errorMessage != null && this.minecraft != null) {
            int errorX = this.width / 2 - this.font.width((FormattedText)Component.nullToEmpty((String)this.errorMessage)) / 2;
            int errorY = this.height / 2 + 60;
            context.drawString(this.font, Component.nullToEmpty((String)this.errorMessage), errorX, errorY, -65536, true);
        }
        this.renderTooltip(context, mouseX, mouseY);
        if (this.locateRequestCooldown > 0) {
            --this.locateRequestCooldown;
        }
    }

    private void sendLocateRequest(StructureData structure) {
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        if (this.locateRequestCooldown > 0) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - structure.lastRequestTime < 5000L) {
            LOGGER.debug("Skipping locate request for {} - too soon since last request", (Object)structure.name);
            return;
        }
        try {
            LegendaryTrackingPayloads.LocateRequestPayload payload = new LegendaryTrackingPayloads.LocateRequestPayload(structure.structureId, this.minecraft.player.blockPosition(), structure.isCompleted);
            ClientPlayNetworking.send((CustomPacketPayload)payload);
            this.locateRequestCooldown = 20;
            structure.lastRequestTime = currentTime;
            LOGGER.info("Sent locate request for: {} at player pos: {}", (Object)structure.name, (Object)this.minecraft.player.blockPosition());
        }
        catch (Throwable t) {
            LOGGER.warn("Failed to send locate request packet", t);
            this.errorMessage = "Failed to send locate request: " + t.getMessage();
            this.errorTimer = 100;
        }
    }

    public static void registerClientReceivers() {
        try {
            ClientPlayNetworking.registerGlobalReceiver(LegendaryTrackingPayloads.LocateResponsePayload.ID, (payload, context) -> {
                try {
                    context.client().execute(() -> {
                        LOGGER.info("Received locate response: {} -> found:{} pos:{}", new Object[]{payload.structureId(), payload.found(), payload.pos()});
                        boolean foundStructure = false;
                        for (StructureData s : STRUCTURES) {
                            if (!LegendaryTrackingScreen.idsMatch(s.structureId, payload.structureId())) continue;
                            s.isLocated = payload.found();
                            s.position = payload.found() ? payload.pos() : null;
                            foundStructure = true;
                            if (s.structureId.equals(payload.structureId())) {
                                LOGGER.info("Updated structure: {} -> located:{} pos:{}", new Object[]{s.name, s.isLocated, s.position});
                                break;
                            }
                            LOGGER.info("Updated structure (fuzzy match: {} ~ {}): {} -> located:{} pos:{}", new Object[]{s.structureId, payload.structureId(), s.name, s.isLocated, s.position});
                            break;
                        }
                        if (!foundStructure) {
                            LOGGER.warn("Received locate response for unknown structure: {}", (Object)payload.structureId());
                        }
                    });
                }
                catch (Exception e) {
                    LOGGER.error("Error processing locate response", (Throwable)e);
                }
            });
            ClientPlayNetworking.registerGlobalReceiver(LegendaryTrackingPayloads.KeyItemCheckResponsePayload.ID, (payload, context) -> {
                try {
                    context.client().execute(() -> {
                        KEY_ITEM_CACHE.put(payload.itemId(), payload.has());
                        LOGGER.info("Key item check result: {} -> {}", (Object)payload.itemId(), (Object)payload.has());
                    });
                }
                catch (Exception e) {
                    LOGGER.error("Error processing key item response", (Throwable)e);
                }
            });
            LOGGER.info("Successfully registered locate and key-item response receivers");
        }
        catch (Throwable t) {
            LOGGER.error("Failed to register client locate receiver", t);
        }
    }

    private void drawTrackingInfo(GuiGraphics context) {
        if (this.minecraft == null || this.minecraft.player == null) {
            return;
        }
        StructureData selectedStructure = STRUCTURES[this.selectedStructureIndex];
        boolean clientThinksMissing = !this.hasRequiredItem(selectedStructure);
        int baseY = this.height / 2 + 30;
        if (!selectedStructure.isLocated && this.locateRequestCooldown == 0) {
            LOGGER.debug("Requesting locate for: {}", (Object)selectedStructure.name);
            this.sendLocateRequest(selectedStructure);
        }
        if (selectedStructure.position == null) {
            String notFoundText = selectedStructure.isLocated ? "Structure not found in range" : "Searching for structure...";
            int textX = this.width / 2 - this.font.width((FormattedText)Component.nullToEmpty((String)notFoundText)) / 2;
            int color = selectedStructure.isLocated ? -48060 : -22016;
            context.drawString(this.font, Component.nullToEmpty((String)notFoundText), textX, baseY, color, true);
            return;
        }
        BlockPos playerPos = this.minecraft.player.blockPosition();
        BlockPos structurePos = selectedStructure.position;
        double distance = Math.sqrt(playerPos.distSqr((Vec3i)structurePos));
        double deltaX = structurePos.getX() - playerPos.getX();
        double deltaZ = structurePos.getZ() - playerPos.getZ();
        float playerYaw = this.minecraft.player.getYRot();
        double absoluteAngle = Math.atan2(deltaZ, deltaX);
        double relativeAngle = absoluteAngle - Math.toRadians(playerYaw);
        String distanceText = String.format("Distance: %.0f blocks", distance);
        int textX = this.width / 2 - this.font.width((FormattedText)Component.nullToEmpty((String)distanceText)) / 2;
        int textY = this.height / 2 + 30;
        context.drawString(this.font, Component.nullToEmpty((String)distanceText), textX, textY, 0xFFFFFF, true);
        String directionText = this.getDirectionText(deltaX, deltaZ);
        int dirTextX = this.width / 2 - this.font.width((FormattedText)Component.nullToEmpty((String)directionText)) / 2;
        int dirTextY = this.height / 2 + 42;
        context.drawString(this.font, Component.nullToEmpty((String)directionText), dirTextX, dirTextY, -3355444, true);
        String coordText = String.format("Coords: %d, %d, %d", structurePos.getX(), structurePos.getY(), structurePos.getZ());
        int coordTextX = this.width / 2 - this.font.width((FormattedText)Component.nullToEmpty((String)coordText)) / 2;
        int coordTextY = this.height / 2 + 54;
        context.drawString(this.font, Component.nullToEmpty((String)coordText), coordTextX, coordTextY, -7829368, false);
        int mapCenterX = this.width / 2;
        int mapCenterY = this.height / 2 - 25;
        this.drawDynamicArrow(context, mapCenterX, mapCenterY, relativeAngle, distance);
    }

    private String getDirectionText(double deltaX, double deltaZ) {
        double absZ;
        String ewDirection = deltaX > 0.0 ? "East" : "West";
        String nsDirection = deltaZ > 0.0 ? "South" : "North";
        double absX = Math.abs(deltaX);
        if (absX > (absZ = Math.abs(deltaZ)) * 2.0) {
            return ewDirection;
        }
        if (absZ > absX * 2.0) {
            return nsDirection;
        }
        return nsDirection + "-" + ewDirection;
    }

    private void drawDynamicArrow(GuiGraphics context, int centerX, int centerY, double angle, double distance) {
        int baseSize = 18;
        int arrowSize = (int)Math.max(14.0, Math.min(20.0, (double)baseSize + (1000.0 - Math.min(distance, 1000.0)) / 100.0));
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.pose().pushPose();
        context.pose().translate((float)centerX, (float)centerY, 0.0f);
        context.pose().mulPose(Axis.ZP.rotationDegrees((float)Math.toDegrees(angle)));
        float scale = (float)arrowSize / 16.0f;
        context.pose().scale(scale, scale, 1.0f);
        context.blit(TRACKING_ARROW, -8, -8, 0.0f, 0.0f, 16, 16, 16, 16);
        context.pose().popPose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        context.fill(centerX - 1, centerY - 1, centerX + 1, centerY + 1, -1);
    }

    private void drawDropdown(GuiGraphics context, int mouseX, int mouseY) {
        int buttonX = this.dropdownButton.getX();
        int buttonY = this.dropdownButton.getY() + this.dropdownButton.getHeight();
        int buttonWidth = this.dropdownButton.getWidth();
        context.fill(buttonX, buttonY, buttonX + buttonWidth, buttonY + 100, -14540254);
        context.renderOutline(buttonX, buttonY, buttonWidth, 100, -7829368);
        int visibleItems = 6;
        int maxScroll = Math.max(0, STRUCTURES.length - visibleItems);
        for (int i = this.scrollOffset = Mth.clamp((int)this.scrollOffset, (int)0, (int)maxScroll); i < Math.min(STRUCTURES.length, this.scrollOffset + visibleItems); ++i) {
            boolean hasItem;
            boolean isHovered;
            int itemY = buttonY + (i - this.scrollOffset) * 15;
            StructureData structure = STRUCTURES[i];
            boolean bl = isHovered = mouseX >= buttonX && mouseX <= buttonX + buttonWidth && mouseY >= itemY && mouseY <= itemY + 15;
            if (isHovered) {
                context.fill(buttonX, itemY, buttonX + buttonWidth, itemY + 15, -12303292);
            }
            int textColor = (hasItem = this.hasRequiredItem(structure)) ? -1 : -10066330;
            context.drawString(this.font, Component.nullToEmpty((String)structure.name), buttonX + 5, itemY + 3, textColor, false);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.dropdownOpen) {
            int buttonX = this.dropdownButton.getX();
            int buttonY = this.dropdownButton.getY() + this.dropdownButton.getHeight();
            int buttonWidth = this.dropdownButton.getWidth();
            if (mouseX >= (double)buttonX && mouseX <= (double)(buttonX + buttonWidth) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + 100)) {
                int clickedIndex = (int)((mouseY - (double)buttonY) / 15.0) + this.scrollOffset;
                if (clickedIndex >= 0 && clickedIndex < STRUCTURES.length) {
                    StructureData selected = STRUCTURES[clickedIndex];
                    boolean hadItemClientSide = this.hasRequiredItem(selected);
                    this.selectedStructureIndex = clickedIndex;
                    staticSelectedStructureIndex = clickedIndex;
                    this.dropdownButton.setMessage(Component.nullToEmpty((String)selected.name));
                    this.dropdownOpen = false;
                    this.errorMessage = null;
                    if (!hadItemClientSide) {
                        this.errorMessage = "You don't have " + selected.requiredItem.getDescription().getString();
                        this.errorTimer = 80;
                        LOGGER.info("Selected {} without client-side item; informing player about missing item {}", (Object)selected.name, (Object)selected.requiredItem.getDescription().getString());
                    } else {
                        LOGGER.info("Selected structure: {} (index: {})", (Object)selected.name, (Object)clickedIndex);
                    }
                    selected.isLocated = false;
                    selected.position = null;
                    selected.lastRequestTime = 0L;
                    this.sendLocateRequest(selected);
                }
                return true;
            }
            this.dropdownOpen = false;
        }
        if (button == 0 && this.minecraft != null && this.minecraft.player != null) {
            BlockPos playerPos = this.minecraft.player.blockPosition();
            int mapX = this.cachedMapX;
            int mapY = this.cachedMapY;
            for (StructureData structure : STRUCTURES) {
                if (!structure.isLocated || structure.position == null) continue;
                int structureMapX = mapX + 120 + (structure.position.getX() - playerPos.getX()) * 16 / 16;
                int structureMapY = mapY + 56 + (structure.position.getZ() - playerPos.getZ()) * 16 / 16;
                if (!(mouseX >= (double)(structureMapX - 6)) || !(mouseX <= (double)(structureMapX + 6)) || !(mouseY >= (double)(structureMapY - 6)) || !(mouseY <= (double)(structureMapY + 6))) continue;
                boolean bl = structure.isCompleted = !structure.isCompleted;
                if (structure.isCompleted) {
                    completedStructures.add(structure.structureId);
                    structure.isLocated = false;
                    structure.position = null;
                    structure.lastRequestTime = 0L;
                    this.sendLocateRequest(structure);
                    LOGGER.info("Marked {} as completed, requesting next instance", (Object)structure.name);
                } else {
                    completedStructures.remove(structure.structureId);
                    LOGGER.info("Unmarked {} as completed", (Object)structure.name);
                }
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (this.dropdownOpen) {
            int buttonX = this.dropdownButton.getX();
            int buttonY = this.dropdownButton.getY() + this.dropdownButton.getHeight();
            int buttonWidth = this.dropdownButton.getWidth();
            if (mouseX >= (double)buttonX && mouseX <= (double)(buttonX + buttonWidth) && mouseY >= (double)buttonY && mouseY <= (double)(buttonY + 100)) {
                this.scrollOffset = Mth.clamp((int)(this.scrollOffset - (int)verticalAmount), (int)0, (int)Math.max(0, STRUCTURES.length - 6));
                return true;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    protected void renderLabels(GuiGraphics context, int mouseX, int mouseY) {
        Component titleText = Component.nullToEmpty((String)"Legendary Tracking");
        int titleX = (this.imageWidth - this.font.width((FormattedText)titleText)) / 2;
        context.drawString(this.font, titleText, titleX, 10, 0xFFFFFF, false);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public static void refreshStructureLocations() {
        for (StructureData structure : STRUCTURES) {
            structure.isLocated = false;
            structure.position = null;
            structure.lastRequestTime = 0L;
        }
        LOGGER.info("Refreshed all structure locations");
    }

    public static void debugNetworking() {
        LOGGER.info("=== DEBUG NETWORKING INFO ===");
        LOGGER.info("Locate Request ID: {}", (Object)LOCATE_REQUEST_ID);
        LOGGER.info("Locate Response ID: {}", (Object)LOCATE_RESPONSE_ID);
        LOGGER.info("Structures count: {}", (Object)STRUCTURES.length);
        for (int i = 0; i < STRUCTURES.length; ++i) {
            StructureData s = STRUCTURES[i];
            LOGGER.info("  {}: {} -> located:{} pos:{}", new Object[]{i, s.name, s.isLocated, s.position});
        }
        LOGGER.info("Selected index: {}", (Object)staticSelectedStructureIndex);
        LOGGER.info("==============================");
    }

    public record LocateRequestPayload(String structureId, BlockPos playerPos, boolean isCompleted) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<LocateRequestPayload> ID = new CustomPacketPayload.Type(LOCATE_REQUEST_ID);
        public static final StreamCodec<FriendlyByteBuf, LocateRequestPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, LocateRequestPayload::structureId, (StreamCodec)BlockPos.STREAM_CODEC, LocateRequestPayload::playerPos, (StreamCodec)ByteBufCodecs.BOOL, LocateRequestPayload::isCompleted, LocateRequestPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    public record LocateResponsePayload(String structureId, boolean found, BlockPos pos) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<LocateResponsePayload> ID = new CustomPacketPayload.Type(LOCATE_RESPONSE_ID);
        public static final StreamCodec<FriendlyByteBuf, LocateResponsePayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, LocateResponsePayload::structureId, (StreamCodec)ByteBufCodecs.BOOL, LocateResponsePayload::found, (StreamCodec)BlockPos.STREAM_CODEC, LocateResponsePayload::pos, LocateResponsePayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    public record KeyItemCheckRequestPayload(String itemId) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<KeyItemCheckRequestPayload> ID = new CustomPacketPayload.Type(KEYITEM_REQUEST_ID);
        public static final StreamCodec<FriendlyByteBuf, KeyItemCheckRequestPayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, KeyItemCheckRequestPayload::itemId, KeyItemCheckRequestPayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    public record KeyItemCheckResponsePayload(String itemId, boolean has) implements CustomPacketPayload
    {
        public static final CustomPacketPayload.Type<KeyItemCheckResponsePayload> ID = new CustomPacketPayload.Type(KEYITEM_RESPONSE_ID);
        public static final StreamCodec<FriendlyByteBuf, KeyItemCheckResponsePayload> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, KeyItemCheckResponsePayload::itemId, (StreamCodec)ByteBufCodecs.BOOL, KeyItemCheckResponsePayload::has, KeyItemCheckResponsePayload::new);

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return ID;
        }
    }

    private static class StructureData {
        public final String name;
        public final Item requiredItem;
        public final String structureId;
        public final String iconName;
        public BlockPos position;
        public boolean isLocated = false;
        public boolean isCompleted = false;
        public long lastRequestTime = 0L;

        public StructureData(String name, Item requiredItem, String structureId) {
            this.name = name;
            this.requiredItem = requiredItem;
            this.structureId = structureId;
            this.iconName = structureId.substring(structureId.indexOf(58) + 1);
            this.position = null;
        }
    }
}

