/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.data.ClientPlayerDataCache;
import github.jorgaomc.data.PlayerAppData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class SystemUpgradesScreen
extends Screen {
    private static final ResourceLocation PHONE_OUTLINE = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"textures/gui/arc_phone_outline.png");
    private static final ResourceLocation PHONE_SCREEN = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"textures/gui/arc_phone_app_screen.png");
    private static final ResourceLocation APP_ICONS = ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"textures/gui/arc_phone_app_icons.png");
    private static final int SCREEN_WIDTH = 330;
    private static final int SCREEN_HEIGHT = 194;
    private static final int APP_ICON_SIZE = 48;
    private static final int OUTLINE_X_OFFSET = 81;
    private static final int OUTLINE_Y_OFFSET = 0;
    private static final int TOP_TITLE_SPACE = 40;
    private static final int LEFT_PADDING = 60;
    private static final int LEFT_PADDING_SECOND_COLUMN = 185;
    private static final int APPS_PER_ROW = 2;
    private static final int GAP_Y = 30;
    private static final int TEXT_GAP = 8;
    private static final AppIcon[] UPGRADE_APPS = new AppIcon[]{new AppIcon(0, 0, "PC", "PC Upgrade"), new AppIcon(0, 0, "Pok\u00e9dex", "Pok\u00e9dex Upgrade"), new AppIcon(0, 0, "Heal", "Heal Upgrade"), new AppIcon(0, 0, "Ender Chest", "Ender Chest Upgrade")};

    public SystemUpgradesScreen() {
        super((Component)Component.translatable((String)"screen.legendarymonuments.system_upgrades"));
    }

    protected void init() {
        super.init();
    }

    public void render(GuiGraphics context, int mouseX, int mouseY, float delta) {
        this.renderBackground(context, mouseX, mouseY, delta);
        this.drawScreenElements(context, mouseX, mouseY, delta);
        context.drawCenteredString(this.font, (Component)Component.translatable((String)"screen.legendarymonuments.system_upgrades"), this.width / 2, (this.height - 194) / 2 + 22, 0xFFFFFF);
        int screenX = (this.width - 330) / 2;
        int screenY = (this.height - 194) / 2;
        for (int i = 0; i < UPGRADE_APPS.length; ++i) {
            AppIcon app = UPGRADE_APPS[i];
            if (this.isMouseOverApp(mouseX, mouseY, screenX + app.x, screenY + app.y)) {
                context.renderTooltip(this.font, Component.nullToEmpty((String)app.name), mouseX, mouseY);
            }
            List<ItemStack> costs = this.getCostStacks(app.name);
            int baseX = screenX + app.x + 48 + 10;
            int baseY = screenY + app.y + 4;
            int iconSize = 16;
            for (int ci = 0; ci < costs.size(); ++ci) {
                int cx = baseX;
                int cy = baseY + ci * (iconSize + 6);
                if (mouseX < cx || mouseX >= cx + iconSize || mouseY < cy || mouseY >= cy + iconSize) continue;
                ItemStack stack = costs.get(ci);
                context.renderTooltip(this.font, stack.getHoverName(), mouseX, mouseY);
            }
        }
    }

    private void drawScreenElements(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int outlineWidth = 700;
        int outlineHeight = 390;
        int outlineX = (this.width - outlineWidth) / 2 + 81;
        int outlineY = (this.height - outlineHeight) / 2 + 0;
        int screenX = (this.width - 330) / 2;
        int screenY = (this.height - 194) / 2;
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        context.blit(PHONE_OUTLINE, outlineX, outlineY, 0.0f, 0.0f, outlineWidth, outlineHeight, outlineWidth, outlineHeight);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        context.blit(PHONE_SCREEN, screenX, screenY, 0.0f, 0.0f, 330, 194, 330, 194);
        RenderSystem.disableBlend();
        for (int i = 0; i < UPGRADE_APPS.length; ++i) {
            AppIcon app = UPGRADE_APPS[i];
            int row = i / 2;
            int col = i % 2;
            int appX = col == 0 ? 60 : 185;
            int appY = 40 + row * 78;
            app.x = appX;
            app.y = appY;
            context.blit(APP_ICONS, screenX + appX, screenY + appY, 0.0f, (float)((i + 5) * 48), 48, 48, 48, 432);
            context.drawString(this.font, Component.nullToEmpty((String)app.description), screenX + appX + 24 - this.font.width(app.description) / 2, screenY + appY + 48 + 8, 0xFFFFFF);
            PlayerAppData appData = ClientPlayerDataCache.getAppData();
            boolean isUnlocked = appData.isAppUnlocked(app.name);
            if (isUnlocked) {
                context.drawString(this.font, "\u2713", screenX + appX + 48 - 10, screenY + appY + 48 - 10, 0x55FF55, true);
            } else {
                context.drawString(this.font, "\u2717", screenX + appX + 48 - 10, screenY + appY + 48 - 10, 0xFF5555, true);
            }
            List<ItemStack> costs = this.getCostStacks(app.name);
            int costBaseX = screenX + appX + 48 + 10;
            int costBaseY = screenY + appY + 4;
            int iconSize = 16;
            for (int ci = 0; ci < costs.size(); ++ci) {
                ItemStack stack = costs.get(ci);
                int ix = costBaseX;
                int iy = costBaseY + ci * (iconSize + 6);
                context.renderItem(stack, ix, iy);
                String amount = "x" + stack.getCount();
                context.drawString(this.font, amount, ix + iconSize + 4, iy + 4, 0xFFFFFF);
            }
        }
        RenderSystem.disableBlend();
    }

    private boolean isMouseOverApp(int mouseX, int mouseY, int appX, int appY) {
        return mouseX >= appX && mouseX < appX + 48 && mouseY >= appY && mouseY < appY + 48;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int screenX = (this.width - 330) / 2;
            int screenY = (this.height - 194) / 2;
            for (int i = 0; i < UPGRADE_APPS.length; ++i) {
                AppIcon app = UPGRADE_APPS[i];
                if (!this.isMouseOverApp((int)mouseX, (int)mouseY, screenX + app.x, screenY + app.y)) continue;
                this.handleAppClick(i);
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void handleAppClick(int appIndex) {
        boolean unlocked;
        AppIcon app = UPGRADE_APPS[appIndex];
        String appName = app.name;
        PlayerAppData appData = ClientPlayerDataCache.getAppData();
        if (appData.isAppUnlocked(appName)) {
            if (this.minecraft != null && this.minecraft.player != null) {
                this.minecraft.player.displayClientMessage((Component)Component.translatable((String)"message.legendarymonuments.app_already_unlocked", (Object[])new Object[]{appName}), true);
            }
            LegendaryMonuments.LOGGER.info("App {} is already unlocked", (Object)appName);
            return;
        }
        if (this.minecraft != null && this.minecraft.player != null && (unlocked = appData.unlockApp(appName, (Player)this.minecraft.player))) {
            this.minecraft.player.displayClientMessage((Component)Component.translatable((String)"message.legendarymonuments.app_unlocked", (Object[])new Object[]{appName}), false);
            this.minecraft.player.playSound(SoundEvents.PLAYER_LEVELUP, 1.0f, 1.0f);
            LegendaryMonuments.LOGGER.info("Player {} unlocked app: {}", (Object)this.minecraft.player.getName().getString(), (Object)appName);
            this.onClose();
            Thread delayThread = new Thread(() -> {
                try {
                    Thread.sleep(500L);
                    this.minecraft.execute(() -> this.minecraft.player.getItemInHand(InteractionHand.MAIN_HAND).use((Level)this.minecraft.level, (Player)this.minecraft.player, InteractionHand.MAIN_HAND));
                }
                catch (InterruptedException e) {
                    LegendaryMonuments.LOGGER.error("Error while waiting after app unlock", (Throwable)e);
                }
            });
            delayThread.setDaemon(true);
            delayThread.start();
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private List<ItemStack> getCostStacks(String appName) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        Item upgrade = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"upgrade"));
        list.add(new ItemStack((ItemLike)upgrade, 1));
        switch (appName) {
            case "Pok\u00e9dex": {
                list.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"pokedex_white")), 1));
                break;
            }
            case "PC": {
                list.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"pc")), 1));
                break;
            }
            case "Ender Chest": {
                list.add(new ItemStack((ItemLike)Items.ENDER_CHEST, 1));
                break;
            }
            case "Heal": {
                list.add(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"healing_machine")), 1));
                break;
            }
        }
        return list;
    }

    private static class AppIcon {
        public int x;
        public int y;
        public final String name;
        public final String description;

        public AppIcon(int x, int y, String name, String description) {
            this.x = x;
            this.y = y;
            this.name = name;
            this.description = description;
        }
    }
}

