/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.config;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class PedestalConfig {
    public static String ENTEI_PEDESTAL_ITEM = "entei_treat";
    public static String RAIKOU_PEDESTAL_ITEM = "raikou_treat";
    public static String SUICUNE_PEDESTAL_ITEM = "suicune_treat";
    public static String HEATRAN_PEDESTAL_ITEM = "magma_stone";
    public static String HOOH_PEDESTAL_ITEM = "rainbow_feather";
    public static String LATIAS_PEDESTAL_ITEM = "latias_treat";
    public static String LATIOS_PEDESTAL_ITEM = "latios_treat";
    public static String LUGIA_PEDESTAL_ITEM = "vortex_stone";
    public static String REGICE_PEDESTAL_ITEM = "regiglace";
    public static String REGIROCK_PEDESTAL_ITEM = "registone";
    public static String REGISTEEL_PEDESTAL_ITEM = "regimetal";
    public static String REGIGIGAS_PEDESTAL_ITEM = "regigigassoul";
    public static String REGIELEKI_PEDESTAL_ITEM = "regivolt";
    public static String REGIDRAGO_PEDESTAL_ITEM = "regidrac";
    public static String HOOPA_PEDESTAL_FIRST_ITEM = "temple_key";
    public static String HOOPA_PEDESTAL_SECOND_ITEM = "prison_bottle";
    public static String ZEKROM_PEDESTAL_FIRST_ITEM = "darkstone";
    public static String ZEKROM_PEDESTAL_SECOND_ITEM = "cobblemon:electric_gem";
    public static String RESHIRAM_PEDESTAL_FIRST_ITEM = "lightstone";
    public static String RESHIRAM_PEDESTAL_SECOND_ITEM = "cobblemon:fire_gem";
    public static String KYUREM_PEDESTAL_FIRST_ITEM = "truth_bottle";
    public static String KYUREM_PEDESTAL_SECOND_ITEM = "ideals_bottle";
    public static String ZACIAN_PEDESTAL_FIRST_ITEM = "minecraft:totem_of_undying";
    public static String ZACIAN_PEDESTAL_SECOND_ITEM = "rusted_sword";
    public static String ZAMAZENTA_PEDESTAL_FIRST_ITEM = "minecraft:totem_of_undying";
    public static String ZAMAZENTA_PEDESTAL_SECOND_ITEM = "rusted_shield";

    public static void loadConfig() {
        File configFile;
        File configDir = new File("config/LegendaryMonuments");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        if (!(configFile = new File(configDir, "pedestals.json")).exists()) {
            PedestalConfig.createDefaultConfig(configFile);
        }
        try {
            String content = Files.readString(configFile.toPath());
            PedestalConfig.parseConfig(content);
        }
        catch (Exception e) {
            System.err.println("Error loading config: " + e.getMessage());
        }
    }

    private static void createDefaultConfig(File configFile) {
        try {
            String defaultConfig = "{\n  \"entei_pedestal_item\": \"legendarymonuments:entei_treat\",\n  \"raikou_pedestal_item\": \"legendarymonuments:raikou_treat\",\n  \"suicune_pedestal_item\": \"legendarymonuments:suicune_treat\",\n  \"heatran_pedestal_item\": \"legendarymonuments:magma_stone\",\n  \"hooh_pedestal_item\": \"legendarymonuments:rainbow_feather\",\n  \"latias_pedestal_item\": \"legendarymonuments:latias_treat\",\n  \"latios_pedestal_item\": \"legendarymonuments:latios_treat\",\n  \"lugia_pedestal_item\": \"legendarymonuments:vortex_stone\",\n  \"regice_pedestal_item\": \"legendarymonuments:regiglace\",\n  \"regirock_pedestal_item\": \"legendarymonuments:registone\",\n  \"registeel_pedestal_item\": \"legendarymonuments:regimetal\",\n  \"regigigas_pedestal_item\": \"legendarymonuments:regigigassoul\",\n  \"regieleki_pedestal_item\": \"legendarymonuments:regivolt\",\n  \"regidrago_pedestal_item\": \"legendarymonuments:regidrac\",\n  \"hoopa_pedestal_first_item\": \"legendarymonuments:temple_key\",\n  \"hoopa_pedestal_second_item\": \"mega_showdown:prison_bottle\",\n  \"zekrom_pedestal_first_item\": \"legendarymonuments:darkstone\",\n  \"zekrom_pedestal_second_item\": \"cobblemon:electric_gem\",\n  \"reshiram_pedestal_first_item\": \"legendarymonuments:lightstone\",\n  \"reshiram_pedestal_second_item\": \"cobblemon:fire_gem\",\n  \"kyurem_pedestal_first_item\": \"legendarymonuments:truthbottle\",\n  \"kyurem_pedestal_second_item\": \"legendarymonuments:idealsbottle\",\n  \"zacian_pedestal_first_item\": \"minecraft:totem_of_undying\",\n  \"zacian_pedestal_second_item\": \"mega_showdown:rusted_sword\",\n  \"zamazenta_pedestal_first_item\": \"minecraft:totem_of_undying\",\n  \"zamazenta_pedestal_second_item\": \"mega_showdown:rusted_shield\"\n}\n";
            Files.writeString(configFile.toPath(), (CharSequence)defaultConfig, new OpenOption[0]);
            System.out.println("Created default config at: " + configFile.getPath());
        }
        catch (Exception e) {
            System.err.println("Failed to create default config: " + e.getMessage());
        }
    }

    private static void parseConfig(String content) {
        try {
            String regigigasItem;
            String dragoItem;
            String elekiItem;
            String registeelItem;
            String regirockItem;
            String regiceItem;
            String lugiaItem;
            String latiosItem;
            String latiasItem;
            String zamazenta2Item;
            String zamazenta1Item;
            String zacian2Item;
            String zacian1Item;
            String kyurem2Item;
            String kyurem1Item;
            String reshiram2Item;
            String reshiram1Item;
            String zekrom2Item;
            String zekrom1Item;
            String hoopa2Item;
            String hoopa1Item;
            String heatranItem;
            String hoohItem;
            String suicuneItem;
            String raikouItem;
            String enteiItem;
            if (content.contains("\"entei_pedestal_item\"") && (enteiItem = PedestalConfig.extractJsonValue(content, "entei_pedestal_item")) != null) {
                ENTEI_PEDESTAL_ITEM = enteiItem;
            }
            if (content.contains("\"raikou_pedestal_item\"") && (raikouItem = PedestalConfig.extractJsonValue(content, "raikou_pedestal_item")) != null) {
                RAIKOU_PEDESTAL_ITEM = raikouItem;
            }
            if (content.contains("\"suicune_pedestal_item\"") && (suicuneItem = PedestalConfig.extractJsonValue(content, "suicune_pedestal_item")) != null) {
                SUICUNE_PEDESTAL_ITEM = suicuneItem;
            }
            if (content.contains("\"hooh_pedestal_item\"") && (hoohItem = PedestalConfig.extractJsonValue(content, "hooh_pedestal_item")) != null) {
                HOOH_PEDESTAL_ITEM = hoohItem;
            }
            if (content.contains("\"heatran_pedestal_item\"") && (heatranItem = PedestalConfig.extractJsonValue(content, "heatran_pedestal_item")) != null) {
                HEATRAN_PEDESTAL_ITEM = heatranItem;
            }
            if (content.contains("\"hoopa_pedestal_first_item\"") && (hoopa1Item = PedestalConfig.extractJsonValue(content, "hoopa_pedestal_first_item")) != null) {
                HOOPA_PEDESTAL_FIRST_ITEM = hoopa1Item;
            }
            if (content.contains("\"hoopa_pedestal_second_item\"") && (hoopa2Item = PedestalConfig.extractJsonValue(content, "hoopa_pedestal_second_item")) != null) {
                HOOPA_PEDESTAL_SECOND_ITEM = hoopa2Item;
            }
            if (content.contains("\"zekrom_pedestal_first_item\"") && (zekrom1Item = PedestalConfig.extractJsonValue(content, "zekrom_pedestal_first_item")) != null) {
                ZEKROM_PEDESTAL_FIRST_ITEM = zekrom1Item;
            }
            if (content.contains("\"zekrom_pedestal_second_item\"") && (zekrom2Item = PedestalConfig.extractJsonValue(content, "zekrom_pedestal_second_item")) != null) {
                ZEKROM_PEDESTAL_SECOND_ITEM = zekrom2Item;
            }
            if (content.contains("\"reshiram_pedestal_first_item\"") && (reshiram1Item = PedestalConfig.extractJsonValue(content, "reshiram_pedestal_first_item")) != null) {
                RESHIRAM_PEDESTAL_FIRST_ITEM = reshiram1Item;
            }
            if (content.contains("\"reshiram_pedestal_second_item\"") && (reshiram2Item = PedestalConfig.extractJsonValue(content, "reshiram_pedestal_second_item")) != null) {
                RESHIRAM_PEDESTAL_SECOND_ITEM = reshiram2Item;
            }
            if (content.contains("\"kyurem_pedestal_first_item\"") && (kyurem1Item = PedestalConfig.extractJsonValue(content, "kyurem_pedestal_first_item")) != null) {
                KYUREM_PEDESTAL_FIRST_ITEM = kyurem1Item;
            }
            if (content.contains("\"kyurem_pedestal_second_item\"") && (kyurem2Item = PedestalConfig.extractJsonValue(content, "kyurem_pedestal_second_item")) != null) {
                KYUREM_PEDESTAL_SECOND_ITEM = kyurem2Item;
            }
            if (content.contains("\"zacian_pedestal_first_item\"") && (zacian1Item = PedestalConfig.extractJsonValue(content, "zacian_pedestal_first_item")) != null) {
                ZACIAN_PEDESTAL_FIRST_ITEM = zacian1Item;
            }
            if (content.contains("\"zacian_pedestal_second_item\"") && (zacian2Item = PedestalConfig.extractJsonValue(content, "zacian_pedestal_second_item")) != null) {
                ZACIAN_PEDESTAL_SECOND_ITEM = zacian2Item;
            }
            if (content.contains("\"zamazenta_pedestal_first_item\"") && (zamazenta1Item = PedestalConfig.extractJsonValue(content, "zamazenta_pedestal_first_item")) != null) {
                ZAMAZENTA_PEDESTAL_FIRST_ITEM = zamazenta1Item;
            }
            if (content.contains("\"zamazenta_pedestal_second_item\"") && (zamazenta2Item = PedestalConfig.extractJsonValue(content, "zamazenta_pedestal_second_item")) != null) {
                ZAMAZENTA_PEDESTAL_SECOND_ITEM = zamazenta2Item;
            }
            if (content.contains("\"latias_pedestal_item\"") && (latiasItem = PedestalConfig.extractJsonValue(content, "latias_pedestal_item")) != null) {
                LATIAS_PEDESTAL_ITEM = latiasItem;
            }
            if (content.contains("\"latios_pedestal_item\"") && (latiosItem = PedestalConfig.extractJsonValue(content, "latios_pedestal_item")) != null) {
                LATIOS_PEDESTAL_ITEM = latiosItem;
            }
            if (content.contains("\"lugia_pedestal_item\"") && (lugiaItem = PedestalConfig.extractJsonValue(content, "lugia_pedestal_item")) != null) {
                LUGIA_PEDESTAL_ITEM = lugiaItem;
            }
            if (content.contains("\"regice_pedestal_item\"") && (regiceItem = PedestalConfig.extractJsonValue(content, "regice_pedestal_item")) != null) {
                REGICE_PEDESTAL_ITEM = regiceItem;
            }
            if (content.contains("\"regirock_pedestal_item\"") && (regirockItem = PedestalConfig.extractJsonValue(content, "regirock_pedestal_item")) != null) {
                REGIROCK_PEDESTAL_ITEM = regirockItem;
            }
            if (content.contains("\"registeel_pedestal_item\"") && (registeelItem = PedestalConfig.extractJsonValue(content, "registeel_pedestal_item")) != null) {
                REGISTEEL_PEDESTAL_ITEM = registeelItem;
            }
            if (content.contains("\"regieleki_pedestal_item\"") && (elekiItem = PedestalConfig.extractJsonValue(content, "regieleki_pedestal_item")) != null) {
                REGIELEKI_PEDESTAL_ITEM = elekiItem;
            }
            if (content.contains("\"regidrago_pedestal_item\"") && (dragoItem = PedestalConfig.extractJsonValue(content, "regidrago_pedestal_item")) != null) {
                REGIDRAGO_PEDESTAL_ITEM = dragoItem;
            }
            if (content.contains("\"regigigas_pedestal_item\"") && (regigigasItem = PedestalConfig.extractJsonValue(content, "regigigas_pedestal_item")) != null) {
                REGIGIGAS_PEDESTAL_ITEM = regigigasItem;
            }
        }
        catch (Exception e) {
            System.err.println("Error parsing config: " + e.getMessage());
        }
    }

    private static String extractJsonValue(String json, String key) {
        try {
            String searchFor = "\"" + key + "\"";
            int keyIndex = json.indexOf(searchFor);
            if (keyIndex == -1) {
                return null;
            }
            int colonIndex = json.indexOf(":", keyIndex);
            if (colonIndex == -1) {
                return null;
            }
            int startQuote = json.indexOf("\"", colonIndex);
            if (startQuote == -1) {
                return null;
            }
            int endQuote = json.indexOf("\"", startQuote + 1);
            if (endQuote == -1) {
                return null;
            }
            return json.substring(startQuote + 1, endQuote);
        }
        catch (Exception e) {
            return null;
        }
    }
}

