/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.data;

import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.data.PlayerAppData;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.world.entity.player.Player;

public class ClientPlayerDataCache {
    private static final PlayerAppData appData = new PlayerAppData();

    public static void init() {
        ClientPlayConnectionEvents.JOIN.register(ClientPlayerDataCache::onPlayerJoin);
        ClientPlayConnectionEvents.DISCONNECT.register(ClientPlayerDataCache::onPlayerDisconnect);
        LegendaryMonuments.LOGGER.info("Initialized client player data cache");
    }

    private static void onPlayerJoin(ClientPacketListener handler, PacketSender sender, Minecraft client) {
        if (client.player != null) {
            appData.readFromStorage((Player)client.player);
            LegendaryMonuments.LOGGER.debug("Client joined - loaded app data");
        }
    }

    private static void onPlayerDisconnect(ClientPacketListener handler, Minecraft client) {
        if (client.player != null) {
            appData.writeToStorage((Player)client.player);
        }
        LegendaryMonuments.LOGGER.debug("Client disconnected - cleared app data");
    }

    public static PlayerAppData getAppData() {
        return appData;
    }

    public static void update() {
        Minecraft client = Minecraft.getInstance();
        if (client.player != null) {
            appData.readFromStorage((Player)client.player);
        }
    }
}

