/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.data;

import github.jorgaomc.LegendaryMonuments;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;

public class KeyItemsDataManager
extends SavedData {
    private static final String KEY_ITEMS_DATA_KEY = "legendarymonuments_key_items";
    private static final int STORAGE_SIZE = 63;
    private final Map<UUID, SimpleContainer> playerKeyItems = new HashMap<UUID, SimpleContainer>();

    public static boolean hasKeyItem(Player player, Item item) {
        try {
            if (player == null || item == null) {
                return false;
            }
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                KeyItemsDataManager mgr = KeyItemsDataManager.getOrCreate(serverWorld);
                SimpleContainer inv = mgr.getKeyItemsInventory(player);
                for (int i = 0; i < inv.getContainerSize(); ++i) {
                    ItemStack s = inv.getItem(i);
                    if (s.isEmpty() || s.getItem() != item) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.debug("hasKeyItem(PlayerEntity, Item) failed: {}", (Object)e.getMessage());
        }
        return false;
    }

    public static boolean hasKeyItem(UUID uuid, Item item, ServerLevel world) {
        if (uuid == null || item == null || world == null) {
            return false;
        }
        try {
            KeyItemsDataManager mgr = KeyItemsDataManager.getOrCreate(world);
            Field field = KeyItemsDataManager.class.getDeclaredField("playerKeyItems");
            field.setAccessible(true);
            Map map = (Map)field.get((Object)mgr);
            SimpleContainer inv = (SimpleContainer)map.get(uuid);
            if (inv == null) {
                return false;
            }
            for (int i = 0; i < inv.getContainerSize(); ++i) {
                ItemStack s = inv.getItem(i);
                if (s.isEmpty() || s.getItem() != item) continue;
                return true;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.debug("hasKeyItem(UUID, Item, World) failed: {}", (Object)e.getMessage());
        }
        return false;
    }

    public SimpleContainer getKeyItemsInventory(Player player) {
        UUID playerUuid = player.getUUID();
        return this.playerKeyItems.computeIfAbsent(playerUuid, uuid -> new SimpleContainer(63));
    }

    public void savePlayerKeyItems(Player player, Container inventory) {
        if (player == null || inventory == null) {
            LegendaryMonuments.LOGGER.error("SAVE FAILED: player or inventory is null");
            return;
        }
        UUID playerUuid = player.getUUID();
        SimpleContainer playerInventory = new SimpleContainer(63);
        int copiedItems = 0;
        for (int i = 0; i < Math.min(inventory.getContainerSize(), 63); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty()) continue;
            try {
                ItemStack copy = stack.copy();
                playerInventory.setItem(i, copy);
                ++copiedItems;
                continue;
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error copying item at slot {}: {}", (Object)i, (Object)e.getMessage());
            }
        }
        this.playerKeyItems.put(playerUuid, playerInventory);
        this.setDirty();
        SimpleContainer verified = this.playerKeyItems.get(playerUuid);
        if (verified != null) {
            int verifiedCount = this.countNonEmptySlots(verified);
            if (verifiedCount != copiedItems) {
                LegendaryMonuments.LOGGER.error("VERIFICATION FAILED: Expected {}, but found {}", (Object)copiedItems, (Object)verifiedCount);
            }
        } else {
            LegendaryMonuments.LOGGER.error("VERIFICATION FAILED: Could not retrieve stored inventory!");
        }
    }

    private int countNonEmptySlots(SimpleContainer inventory) {
        int count = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            if (inventory.getItem(i).isEmpty()) continue;
            ++count;
        }
        return count;
    }

    public static KeyItemsDataManager getOrCreate(ServerLevel world) {
        try {
            DimensionDataStorage stateManager = world.getDataStorage();
            Supplier<KeyItemsDataManager> supplier = KeyItemsDataManager::new;
            SavedData.Factory factory = new SavedData.Factory(supplier, KeyItemsDataManager::fromNbt, null);
            return (KeyItemsDataManager)stateManager.computeIfAbsent(factory, KEY_ITEMS_DATA_KEY);
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error in getOrCreate: {}", (Object)e.getMessage(), (Object)e);
            return new KeyItemsDataManager();
        }
    }

    public static KeyItemsDataManager fromNbt(CompoundTag nbt, HolderLookup.Provider wrapperLookup) {
        KeyItemsDataManager manager = new KeyItemsDataManager();
        if (!nbt.contains("players", 10)) {
            return manager;
        }
        CompoundTag playersData = nbt.getCompound("players");
        for (String uuidString : playersData.getAllKeys()) {
            try {
                UUID playerUuid = UUID.fromString(uuidString);
                if (!playersData.contains(uuidString, 9)) continue;
                ListTag inventoryData = playersData.getList(uuidString, 10);
                SimpleContainer inventory = new SimpleContainer(63);
                for (int i = 0; i < inventoryData.size(); ++i) {
                    CompoundTag itemNbt = inventoryData.getCompound(i);
                    try {
                        int slot;
                        if (!itemNbt.contains("Slot", 3) || (slot = itemNbt.getInt("Slot")) < 0 || slot >= 63) continue;
                        CompoundTag cleanItemNbt = itemNbt.copy();
                        cleanItemNbt.remove("Slot");
                        ItemStack stack = ItemStack.parse((HolderLookup.Provider)wrapperLookup, (Tag)cleanItemNbt).orElse(ItemStack.EMPTY);
                        if (stack.isEmpty()) continue;
                        inventory.setItem(slot, stack);
                        continue;
                    }
                    catch (Exception e) {
                        LegendaryMonuments.LOGGER.error("Error parsing item NBT at index {}: {}", (Object)i, (Object)e.getMessage());
                    }
                }
                manager.playerKeyItems.put(playerUuid, inventory);
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error loading data for player {}: {}", (Object)uuidString, (Object)e.getMessage());
            }
        }
        return manager;
    }

    public CompoundTag save(CompoundTag nbt, HolderLookup.Provider wrapperLookup) {
        CompoundTag playersData = new CompoundTag();
        for (Map.Entry<UUID, SimpleContainer> entry : this.playerKeyItems.entrySet()) {
            String uuid = entry.getKey().toString();
            SimpleContainer inventory = entry.getValue();
            ListTag list = new ListTag();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                ItemStack stack = inventory.getItem(i);
                if (stack.isEmpty()) continue;
                try {
                    if (stack.getItem() == null) continue;
                    CompoundTag itemNbt = new CompoundTag();
                    boolean encoded = false;
                    try {
                        stack.save(wrapperLookup, (Tag)itemNbt);
                        if (!itemNbt.isEmpty() && itemNbt.contains("id")) {
                            encoded = true;
                        }
                    }
                    catch (Exception e) {
                        LegendaryMonuments.LOGGER.error("Encode method failed for slot {}: {}", (Object)i, (Object)e.getMessage());
                    }
                    if (!encoded) {
                        try {
                            String itemId = stack.getItemHolder().unwrapKey().map(key -> key.location().toString()).orElse("minecraft:air");
                            itemNbt.putString("id", itemId);
                            itemNbt.putInt("count", stack.getCount());
                            encoded = true;
                        }
                        catch (Exception e) {
                            LegendaryMonuments.LOGGER.error("Manual encoding also failed for slot {}: {}", (Object)i, (Object)e.getMessage());
                        }
                    }
                    if (!encoded || itemNbt.isEmpty()) continue;
                    itemNbt.putInt("Slot", i);
                    list.add((Object)itemNbt);
                    continue;
                }
                catch (Exception e) {
                    LegendaryMonuments.LOGGER.error("Error encoding item at slot {} for player {}: {}", new Object[]{i, uuid, e.getMessage()});
                }
            }
            if (list.isEmpty()) continue;
            playersData.put(uuid, (Tag)list);
        }
        nbt.put("players", (Tag)playersData);
        return nbt;
    }
}

