/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import github.jorgaomc.LegendaryMonuments;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.storage.LevelResource;

public class PlayerAppData {
    private static final String DATA_FILE_NAME = "phone_apps_data.json";
    private static final Map<UUID, Set<String>> currentWorldData = new HashMap<UUID, Set<String>>();
    private static File dataFile;
    private static final Gson GSON;
    private static final Type DATA_TYPE;
    private static final Set<String> DEFAULT_APPS;
    private static final Set<String> UPGRADEABLE_APPS;
    private final Set<String> unlockedApps = new HashSet<String>();

    public static void initializeStorage(MinecraftServer server) {
        try {
            LegendaryMonuments.LOGGER.info("Initializing phone app data storage");
            File worldDir = server.getWorldPath(LevelResource.ROOT).toFile();
            File dataDir = new File(worldDir, "legendary-monuments-data");
            if (!dataDir.exists() && !dataDir.mkdirs()) {
                LegendaryMonuments.LOGGER.error("Failed to create data directory");
                return;
            }
            dataFile = new File(dataDir, DATA_FILE_NAME);
            currentWorldData.clear();
            if (dataFile.exists()) {
                try (FileReader reader = new FileReader(dataFile);){
                    Map loadedData = (Map)GSON.fromJson((Reader)reader, DATA_TYPE);
                    if (loadedData != null) {
                        currentWorldData.putAll(loadedData);
                        LegendaryMonuments.LOGGER.info("Loaded app data for {} players", (Object)loadedData.size());
                    }
                }
                catch (IOException e) {
                    LegendaryMonuments.LOGGER.error("Failed to load app data", (Throwable)e);
                }
            }
            LegendaryMonuments.LOGGER.info("App data storage initialized");
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Failed to initialize storage", (Throwable)e);
        }
    }

    public void readFromStorage(Player player) {
        UUID playerUUID;
        Set<String> storedApps;
        this.unlockedApps.clear();
        this.unlockedApps.addAll(DEFAULT_APPS);
        if (player != null && (storedApps = currentWorldData.get(playerUUID = player.getUUID())) != null) {
            this.unlockedApps.addAll(storedApps);
        }
    }

    public void writeToStorage(Player player) {
        if (player != null) {
            UUID playerUUID = player.getUUID();
            HashSet<String> upgradeableOnly = new HashSet<String>();
            for (String app : this.unlockedApps) {
                if (!UPGRADEABLE_APPS.contains(app)) continue;
                upgradeableOnly.add(app);
            }
            currentWorldData.put(playerUUID, upgradeableOnly);
            PlayerAppData.saveAllPlayerData();
        }
    }

    public static void saveAllPlayerData() {
        if (dataFile == null) {
            LegendaryMonuments.LOGGER.error("Cannot save: dataFile is null");
            return;
        }
        try (FileWriter writer = new FileWriter(dataFile);){
            GSON.toJson(currentWorldData, (Appendable)writer);
            LegendaryMonuments.LOGGER.debug("Saved app data for {} players", (Object)currentWorldData.size());
        }
        catch (IOException e) {
            LegendaryMonuments.LOGGER.error("Failed to save app data", (Throwable)e);
        }
    }

    public boolean isAppUnlocked(String appName) {
        return this.unlockedApps.contains(appName);
    }

    public boolean unlockApp(String appName, Player player) {
        if (!UPGRADEABLE_APPS.contains(appName) || this.unlockedApps.contains(appName)) {
            return false;
        }
        if (player == null) {
            return false;
        }
        HashMap<Item, Integer> cost = new HashMap<Item, Integer>();
        Item upgradeItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"upgrade"));
        cost.put(upgradeItem, 1);
        switch (appName) {
            case "Pok\u00e9dex": {
                cost.put((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"pokedex_white")), 1);
                break;
            }
            case "PC": {
                cost.put((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"pc")), 1);
                break;
            }
            case "Ender Chest": {
                cost.put(Items.ENDER_CHEST, 1);
                break;
            }
            case "Heal": {
                cost.put((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"cobblemon", (String)"healing_machine")), 1);
                break;
            }
        }
        if (!this.hasItems(player, cost)) {
            player.displayClientMessage((Component)Component.translatable((String)"message.legendarymonuments.system_upgrades.missing_items"), true);
            return false;
        }
        this.consumeItems(player, cost);
        this.unlockedApps.add(appName);
        this.writeToStorage(player);
        return true;
    }

    private boolean hasItems(Player player, Map<Item, Integer> cost) {
        HashMap<Item, Integer> counts = new HashMap<Item, Integer>();
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (stack.isEmpty()) continue;
            counts.merge(stack.getItem(), stack.getCount(), Integer::sum);
        }
        for (Map.Entry<Item, Integer> e : cost.entrySet()) {
            int have = counts.getOrDefault(e.getKey(), 0);
            if (have >= e.getValue()) continue;
            return false;
        }
        return true;
    }

    private void consumeItems(Player player, Map<Item, Integer> cost) {
        for (Map.Entry<Item, Integer> e : cost.entrySet()) {
            Item item = e.getKey();
            int toRemove = e.getValue();
            for (int i = 0; i < player.getInventory().getContainerSize() && toRemove > 0; ++i) {
                ItemStack stack = player.getInventory().getItem(i);
                if (stack.isEmpty() || stack.getItem() != item) continue;
                int remove = Math.min(stack.getCount(), toRemove);
                stack.shrink(remove);
                if (stack.isEmpty()) {
                    player.getInventory().setItem(i, ItemStack.EMPTY);
                }
                toRemove -= remove;
            }
        }
        player.getInventory().setChanged();
    }

    public Set<String> getUnlockedApps() {
        return new HashSet<String>(this.unlockedApps);
    }

    public static void loadPlayerData(ServerPlayer player) {
        if (dataFile == null && player.getServer() != null) {
            PlayerAppData.initializeStorage(player.getServer());
        }
        UUID playerUUID = player.getUUID();
        currentWorldData.putIfAbsent(playerUUID, new HashSet());
        LegendaryMonuments.LOGGER.debug("Loaded data for player {}", (Object)player.getName().getString());
    }

    public static void savePlayerData(ServerPlayer player) {
        PlayerAppData.saveAllPlayerData();
        LegendaryMonuments.LOGGER.debug("Saved data for player {}", (Object)player.getName().getString());
    }

    public static boolean isUpgradeable(String appName) {
        return UPGRADEABLE_APPS.contains(appName);
    }

    public static boolean isDefaultApp(String appName) {
        return DEFAULT_APPS.contains(appName);
    }

    static {
        GSON = new GsonBuilder().setPrettyPrinting().create();
        DATA_TYPE = new TypeToken<Map<UUID, Set<String>>>(){}.getType();
        DEFAULT_APPS = Set.of("Map", "Legendary Tracking", "Key Items", "System Upgrades", "Settings");
        UPGRADEABLE_APPS = Set.of("PC", "Pok\u00e9dex", "Heal", "Ender Chest");
    }
}

