/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DistortionPortalEntity
extends Entity {
    private static final EntityDimensions DIMENSIONS = EntityDimensions.fixed((float)3.0f, (float)3.0f);
    private static final ResourceKey<Level> DISTORTION_WORLD = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"distortion_world"));

    public DistortionPortalEntity(EntityType<?> type, Level world) {
        super(type, world);
        this.noPhysics = true;
        this.setInvulnerable(true);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (this.level().isClientSide && this.tickCount % 3 == 0) {
            RandomSource random = this.level().getRandom();
            for (int i = 0; i < 2; ++i) {
                double x = this.getX() + (random.nextDouble() - 0.5) * 3.0;
                double y = this.getY() + random.nextDouble() * 0.5;
                double z = this.getZ() + (random.nextDouble() - 0.5) * 3.0;
                double velocityX = (random.nextDouble() - 0.5) * 0.1;
                double velocityY = random.nextDouble() * 0.2;
                double velocityZ = (random.nextDouble() - 0.5) * 0.1;
                this.level().addParticle((ParticleOptions)ParticleTypes.SOUL, x, y, z, velocityX, velocityY, velocityZ);
            }
        }
        if (!this.level().isClientSide && this.tickCount % 5 == 0) {
            AABB box = this.getBoundingBox();
            for (Entity entity : this.level().getEntities((Entity)this, box)) {
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer player = (ServerPlayer)entity;
                if (player.level().dimension().equals(DISTORTION_WORLD)) {
                    this.teleportToOverworldSpawn(player);
                    continue;
                }
                this.teleportToDistortionWorld(player);
            }
        }
    }

    private void teleportToDistortionWorld(ServerPlayer player) {
        ServerLevel targetWorld = player.getServer().getLevel(DISTORTION_WORLD);
        if (targetWorld == null) {
            return;
        }
        BlockPos targetPos = player.blockPosition();
        Vec3 targetVec = new Vec3((double)targetPos.getX() + 0.5, (double)targetPos.getY(), (double)targetPos.getZ() + 0.5);
        DimensionTransition target = new DimensionTransition(targetWorld, targetVec, player.getDeltaMovement(), player.getYRot(), player.getXRot(), DimensionTransition.DO_NOTHING);
        player.changeDimension(target);
    }

    private void teleportToOverworldSpawn(ServerPlayer player) {
        ServerLevel overworld = player.getServer().overworld();
        if (overworld == null) {
            return;
        }
        BlockPos spawnPos = player.getRespawnPosition();
        ResourceKey spawnDim = player.getRespawnDimension();
        BlockPos targetPos = spawnPos != null && spawnDim != null && spawnDim.equals(Level.OVERWORLD) ? spawnPos : overworld.getSharedSpawnPos();
        Vec3 targetVec = new Vec3((double)targetPos.getX() + 0.5, (double)targetPos.getY(), (double)targetPos.getZ() + 0.5);
        DimensionTransition target = new DimensionTransition(overworld, targetVec, player.getDeltaMovement(), player.getYRot(), player.getXRot(), DimensionTransition.DO_NOTHING);
        player.changeDimension(target);
    }

    protected void readAdditionalSaveData(CompoundTag nbt) {
    }

    protected void addAdditionalSaveData(CompoundTag nbt) {
    }

    public EntityDimensions getDimensions(Pose pose) {
        return DIMENSIONS;
    }

    protected AABB makeBoundingBox() {
        Vec3 pos = this.position();
        return new AABB(pos.x - 1.5, pos.y - 1.5, pos.z - 1.5, pos.x + 1.5, pos.y + 1.5, pos.z + 1.5);
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        return true;
    }

    public boolean isPickable() {
        return false;
    }

    public boolean isPushable() {
        return false;
    }

    public boolean isInvulnerable() {
        return true;
    }

    public boolean hurt(DamageSource source, float amount) {
        return false;
    }
}

