/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.event;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.world.dimension.HallOfOriginTeleporter;
import github.jorgaomc.world.dimension.HallOfOriginWorld;
import kotlin.Unit;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;

public class ArceusEventHandler {
    public static void register() {
        CobblemonEvents.POKEMON_FAINTED.subscribe(Priority.NORMAL, event -> {
            try {
                Pokemon pokemon = event.getPokemon();
                if (pokemon == null) {
                    return Unit.INSTANCE;
                }
                if (ArceusEventHandler.isArceus(pokemon)) {
                    ArceusEventHandler.handleArceusResolvedNearbyPlayers(pokemon);
                }
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error handling Arceus fainted event", (Throwable)e);
            }
            return Unit.INSTANCE;
        });
        CobblemonEvents.POKEMON_CAPTURED.subscribe(Priority.NORMAL, event -> {
            try {
                Pokemon pokemon = event.getPokemon();
                if (pokemon == null) {
                    return Unit.INSTANCE;
                }
                if (ArceusEventHandler.isArceus(pokemon)) {
                    ServerPlayer player = event.getPlayer();
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = player;
                        ArceusEventHandler.maybeTeleportFromHallOfOrigin(serverPlayer);
                    } else {
                        ArceusEventHandler.handleArceusResolvedNearbyPlayers(pokemon);
                    }
                }
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error handling Arceus captured event", (Throwable)e);
            }
            return Unit.INSTANCE;
        });
        LegendaryMonuments.LOGGER.info("Registered Arceus event handler (faint/capture -> teleport from Hall of Origin)");
    }

    private static boolean isArceus(Pokemon pokemon) {
        try {
            return pokemon.getSpecies() != null && "arceus".equalsIgnoreCase(pokemon.getSpecies().getName());
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static void handleArceusResolvedNearbyPlayers(Pokemon arceus) {
        try {
            if (arceus.getEntity() == null || arceus.getEntity().level() == null) {
                return;
            }
            Level world = arceus.getEntity().level();
            world.players().forEach(player -> {
                if (player instanceof ServerPlayer) {
                    ServerLevel sw;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (world instanceof ServerLevel && (sw = (ServerLevel)world).dimension() == HallOfOriginWorld.HALL_OF_ORIGIN_WORLD_KEY && arceus.getEntity() != null && (double)player.distanceTo((Entity)arceus.getEntity()) <= 64.0) {
                        ArceusEventHandler.maybeTeleportFromHallOfOrigin(serverPlayer);
                    }
                }
            });
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Failed handling nearby players for Arceus resolution", (Throwable)e);
        }
    }

    private static void maybeTeleportFromHallOfOrigin(ServerPlayer player) {
        try {
            ServerLevel sw;
            Level level = player.level();
            if (level instanceof ServerLevel && (sw = (ServerLevel)level).dimension() == HallOfOriginWorld.HALL_OF_ORIGIN_WORLD_KEY) {
                LegendaryMonuments.LOGGER.info("Teleporting {} from Hall of Origin after Arceus event", (Object)player.getName().getString());
                HallOfOriginTeleporter.teleportFromHallOfOrigin(player);
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error teleporting player from Hall of Origin", (Throwable)e);
        }
    }
}

