/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.event;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModItems;
import java.util.Random;
import kotlin.Unit;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DreamStringEventHandler {
    private static final Random RANDOM = new Random();
    private static final float DROP_CHANCE = 0.1f;

    public static void register() {
        CobblemonEvents.POKEMON_FAINTED.subscribe(Priority.NORMAL, event -> {
            try {
                Pokemon faintedPokemon = event.getPokemon();
                if (faintedPokemon == null) {
                    return Unit.INSTANCE;
                }
                if (faintedPokemon.getOwnerUUID() == null) {
                    DreamStringEventHandler.processWildPokemonDefeat(faintedPokemon);
                }
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error processing Pok\u00e9mon fainted event for Dream String", (Throwable)e);
            }
            return Unit.INSTANCE;
        });
        LegendaryMonuments.LOGGER.info("Registered Dream String drop handler");
    }

    private static void processWildPokemonDefeat(Pokemon defeatedPokemon) {
        try {
            if (defeatedPokemon.getEntity() != null && defeatedPokemon.getEntity().level() != null) {
                defeatedPokemon.getEntity().level().players().forEach(player -> {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        double distance = player.distanceTo((Entity)defeatedPokemon.getEntity());
                        if (distance <= 32.0) {
                            DreamStringEventHandler.maybeDropDreamString(serverPlayer);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Could not process wild pokemon defeat for Dream String drop", (Throwable)e);
        }
    }

    private static void maybeDropDreamString(ServerPlayer player) {
        try {
            long timeOfDay = player.level().getDayTime() % 24000L;
            if (timeOfDay >= 13000L && timeOfDay <= 23000L && RANDOM.nextFloat() < 0.1f) {
                LegendaryMonuments.LOGGER.info("Player {} defeated a Pok\u00e9mon at night, dropping Dream String", (Object)player.getName().getString());
                ItemStack dreamString = new ItemStack((ItemLike)ModItems.DREAM_STRING);
                player.getInventory().add(dreamString);
                player.displayClientMessage((Component)Component.translatable((String)"item.legendarymonuments.dream_string.drop"), false);
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error attempting to drop Dream String for player {}", (Object)player.getName().getString(), (Object)e);
        }
    }
}

