/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.event;

import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.data.KeyItemsDataManager;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;

public class KeyItemsEventHandler {
    public static void register() {
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            ServerPlayer player = handler.getPlayer();
            if (player != null) {
                try {
                    ServerLevel world = (ServerLevel)player.level();
                    KeyItemsDataManager dataManager = KeyItemsDataManager.getOrCreate(world);
                    dataManager.setDirty();
                    LegendaryMonuments.LOGGER.info("Triggered save for disconnecting player: {}", (Object)player.getName().getString());
                }
                catch (Exception e) {
                    LegendaryMonuments.LOGGER.error("Error saving key items data for disconnecting player: {}", (Object)player.getName().getString(), (Object)e);
                }
            }
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            LegendaryMonuments.LOGGER.info("Server stopping, performing final save of all key items data...");
            try {
                for (ServerLevel world : server.getAllLevels()) {
                    KeyItemsDataManager dataManager = KeyItemsDataManager.getOrCreate(world);
                    dataManager.setDirty();
                    LegendaryMonuments.LOGGER.info("Final save triggered for world: {}", (Object)world.dimension().location());
                }
                Thread.sleep(100L);
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error during final save of key items data", (Throwable)e);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            Thread autoSaveThread = new Thread(() -> {
                while (!server.isStopped()) {
                    try {
                        Thread.sleep(300000L);
                        if (server.isStopped()) continue;
                        server.execute(() -> {
                            try {
                                for (ServerLevel world : server.getAllLevels()) {
                                    KeyItemsDataManager dataManager = KeyItemsDataManager.getOrCreate(world);
                                    dataManager.setDirty();
                                }
                                LegendaryMonuments.LOGGER.debug("Periodic key items auto-save completed");
                            }
                            catch (Exception e) {
                                LegendaryMonuments.LOGGER.error("Error in periodic auto-save", (Throwable)e);
                            }
                        });
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                }
            });
            autoSaveThread.setDaemon(true);
            autoSaveThread.setName("KeyItems-AutoSave");
            autoSaveThread.start();
            LegendaryMonuments.LOGGER.info("Key Items auto-save thread started (5-minute intervals)");
        });
    }
}

