/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.event;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModItems;
import java.util.Random;
import kotlin.Unit;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class SacredAshEventHandler {
    private static final Random RANDOM = new Random();
    private static final float DROP_CHANCE = 0.05f;

    public static void register() {
        CobblemonEvents.POKEMON_FAINTED.subscribe(Priority.NORMAL, event -> {
            try {
                Pokemon faintedPokemon = event.getPokemon();
                if (faintedPokemon == null) {
                    return Unit.INSTANCE;
                }
                if (faintedPokemon.getOwnerUUID() == null) {
                    SacredAshEventHandler.processWildPokemonDefeat(faintedPokemon);
                }
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error processing Pok\u00e9mon fainted event for Sacred Ash", (Throwable)e);
            }
            return Unit.INSTANCE;
        });
        LegendaryMonuments.LOGGER.info("Registered Sacred Ash drop handler");
    }

    private static void processWildPokemonDefeat(Pokemon defeatedPokemon) {
        try {
            if (defeatedPokemon.getEntity() != null && defeatedPokemon.getEntity().level() != null) {
                defeatedPokemon.getEntity().level().players().forEach(player -> {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        double distance = player.distanceTo((Entity)defeatedPokemon.getEntity());
                        if (distance <= 15.0 && SacredAshEventHandler.hasHoOhInParty(serverPlayer)) {
                            SacredAshEventHandler.maybeDropSacredAsh(serverPlayer);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Could not process wild pokemon defeat for Sacred Ash drop", (Throwable)e);
        }
    }

    private static boolean hasHoOhInParty(ServerPlayer player) {
        try {
            PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(player);
            for (int i = 0; i < party.size(); ++i) {
                String speciesName;
                Pokemon pokemon = party.get(i);
                if (pokemon == null || !(speciesName = pokemon.getSpecies().getName()).equalsIgnoreCase("ho-oh") && !speciesName.equalsIgnoreCase("hooh") && !speciesName.equalsIgnoreCase("ho_oh")) continue;
                LegendaryMonuments.LOGGER.info("Found Ho-Oh in player's party!");
                return true;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error checking for Ho-Oh in player's party", (Throwable)e);
        }
        return false;
    }

    private static void maybeDropSacredAsh(ServerPlayer player) {
        try {
            float roll = RANDOM.nextFloat();
            LegendaryMonuments.LOGGER.info("Sacred Ash drop roll: {} (needs < {})", (Object)Float.valueOf(roll), (Object)Float.valueOf(0.05f));
            if (roll < 0.05f) {
                LegendaryMonuments.LOGGER.info("Success! Player {} will receive Sacred Ash", (Object)player.getName().getString());
                ItemStack sacredAsh = new ItemStack((ItemLike)ModItems.SACRED_ASH);
                boolean added = player.getInventory().add(sacredAsh);
                LegendaryMonuments.LOGGER.info("Sacred Ash added to inventory: {}", (Object)added);
                player.displayClientMessage((Component)Component.translatable((String)"item.legendarymonuments.sacred_ash.drop"), false);
            } else {
                LegendaryMonuments.LOGGER.info("Failed roll, no Sacred Ash for player {}", (Object)player.getName().getString());
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error attempting to drop Sacred Ash for player {}", (Object)player.getName().getString(), (Object)e);
        }
    }
}

