/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.event;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.events.CobblemonEvents;
import com.cobblemon.mod.common.api.types.ElementalType;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModDataComponentTypes;
import github.jorgaomc.component.UrnProgressComponent;
import github.jorgaomc.item.UrnItem;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import kotlin.Unit;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class UrnEventHandler {
    private static final Map<UUID, ItemStack> activeUrnTracking = new HashMap<UUID, ItemStack>();

    public static void register() {
        CobblemonEvents.POKEMON_FAINTED.subscribe(Priority.NORMAL, event -> {
            try {
                Pokemon faintedPokemon = event.getPokemon();
                if (faintedPokemon == null) {
                    return Unit.INSTANCE;
                }
                if (faintedPokemon.getOwnerUUID() == null) {
                    UrnEventHandler.processWildPokemonDefeat(faintedPokemon);
                }
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error processing Pok\u00e9mon fainted event", (Throwable)e);
            }
            return Unit.INSTANCE;
        });
    }

    private static void processWildPokemonDefeat(Pokemon defeatedPokemon) {
        try {
            if (defeatedPokemon.getEntity() != null && defeatedPokemon.getEntity().level() != null) {
                defeatedPokemon.getEntity().level().players().forEach(player -> {
                    if (player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        double distance = player.distanceTo((Entity)defeatedPokemon.getEntity());
                        if (distance <= 32.0) {
                            UrnEventHandler.processDefeat(serverPlayer, defeatedPokemon);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Could not process wild pokemon defeat location-based", (Throwable)e);
        }
    }

    private static void processDefeat(ServerPlayer player, Pokemon defeatedPokemon) {
        UUID playerId = player.getUUID();
        boolean hasProcessedUrn = false;
        if (activeUrnTracking.containsKey(playerId)) {
            ItemStack trackedStack = activeUrnTracking.get(playerId);
            if (UrnEventHandler.isValidUrnForTracking(trackedStack, (Player)player, defeatedPokemon)) {
                UrnEventHandler.updateUrnProgress(player, trackedStack, defeatedPokemon);
                hasProcessedUrn = true;
            } else {
                activeUrnTracking.remove(playerId);
            }
        }
        if (!hasProcessedUrn) {
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                UrnItem urnItem;
                ItemStack stack = player.getInventory().getItem(i);
                if (!(stack.getItem() instanceof UrnItem) || UrnEventHandler.isUrnComplete(stack) || !UrnEventHandler.isMatchingType(defeatedPokemon, (urnItem = (UrnItem)stack.getItem()).getPokemonType())) continue;
                activeUrnTracking.put(playerId, stack);
                UrnEventHandler.updateUrnProgress(player, stack, defeatedPokemon);
                break;
            }
        }
    }

    private static boolean isValidUrnForTracking(ItemStack stack, Player player, Pokemon defeatedPokemon) {
        Item item = stack.getItem();
        if (item instanceof UrnItem) {
            UrnItem urnItem = (UrnItem)item;
            if (UrnEventHandler.isUrnComplete(stack)) {
                return false;
            }
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStack inventoryStack = player.getInventory().getItem(i);
                if (inventoryStack != stack) continue;
                return UrnEventHandler.isMatchingType(defeatedPokemon, urnItem.getPokemonType());
            }
        }
        return false;
    }

    private static boolean isMatchingType(Pokemon pokemon, String requiredType) {
        for (ElementalType type : pokemon.getTypes()) {
            if (!type.getName().equalsIgnoreCase(requiredType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isUrnComplete(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof UrnItem) {
            UrnItem urnItem = (UrnItem)item;
            if (stack.has(ModDataComponentTypes.URN_PROGRESS_COMPONENT)) {
                UrnProgressComponent progress = (UrnProgressComponent)stack.get(ModDataComponentTypes.URN_PROGRESS_COMPONENT);
                return progress.isComplete(urnItem.getRequiredProgress());
            }
        }
        return false;
    }

    private static void updateUrnProgress(ServerPlayer player, ItemStack stack, Pokemon defeatedPokemon) {
        Item item = stack.getItem();
        if (item instanceof UrnItem) {
            UrnItem urnItem = (UrnItem)item;
            if (stack.has(ModDataComponentTypes.URN_PROGRESS_COMPONENT)) {
                UrnProgressComponent currentProgress = (UrnProgressComponent)stack.get(ModDataComponentTypes.URN_PROGRESS_COMPONENT);
                UrnProgressComponent newProgress = currentProgress.withIncrementedProgress();
                stack.set(ModDataComponentTypes.URN_PROGRESS_COMPONENT, (Object)newProgress);
                int progress = newProgress.progress();
                int requiredProgress = urnItem.getRequiredProgress();
                ChatFormatting typeColor = UrnItem.getTypeFormatting(urnItem.getPokemonType());
                player.displayClientMessage((Component)Component.translatable((String)"item.legendarymonuments.urn.update", (Object[])new Object[]{defeatedPokemon.getSpecies().getName(), progress, requiredProgress}).withStyle(typeColor), true);
                if (newProgress.isComplete(requiredProgress)) {
                    player.displayClientMessage((Component)Component.translatable((String)"item.legendarymonuments.urn.complete").withStyle(ChatFormatting.GREEN), false);
                }
            }
        }
    }
}

