/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModItems;
import github.jorgaomc.world.dimension.HallOfOriginTeleporter;
import github.jorgaomc.world.dimension.HallOfOriginWorld;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.item.ItemStack;

public class AzureFluteTeleporter {
    public static void register() {
        UseItemCallback.EVENT.register((player, world, hand) -> {
            ItemStack stack = player.getItemInHand(hand);
            if (stack.is(ModItems.AZURE_FLUTE)) {
                if (!world.isClientSide() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    LegendaryMonuments.LOGGER.info("Player {} used Azure Flute", (Object)player.getName().getString());
                    if (world.dimension() == HallOfOriginWorld.HALL_OF_ORIGIN_WORLD_KEY) {
                        HallOfOriginTeleporter.teleportFromHallOfOrigin(serverPlayer);
                    } else {
                        HallOfOriginTeleporter.teleportToHallOfOrigin(serverPlayer);
                        serverPlayer.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 60, 4, false, false));
                        if (!serverPlayer.isCreative()) {
                            stack.shrink(1);
                        }
                        MinecraftServer server = serverPlayer.getServer();
                        server.overworld().getServer().execute(() -> AzureFluteTeleporter.scheduleTask(server, 60, () -> {
                            Commands commandManager = server.getCommands();
                            CommandSourceStack source = server.createCommandSourceStack();
                            LegendaryMonuments.LOGGER.info("Attempting to spawn Arceus");
                            commandManager.performPrefixedCommand(source, "execute at @e[name=arceus,type=armor_stand,limit=1] run pokespawn arceus lvl=90 moves=punishment,judgment,refresh,cosmicpower");
                            AzureFluteTeleporter.scheduleTask(server, 20, () -> {
                                CommandSourceStack silentSource = server.createCommandSourceStack().withSuppressedOutput();
                                commandManager.performPrefixedCommand(silentSource, "execute at @e[name=arceus,type=armor_stand,limit=1] run data merge entity @e[type=cobblemon:pokemon,distance=..5,limit=1,sort=nearest] {PersistenceRequired:1b}");
                                LegendaryMonuments.LOGGER.info("Applied persistence to Arceus");
                            });
                        }));
                    }
                    player.getCooldowns().addCooldown(ModItems.AZURE_FLUTE, 40);
                }
                return InteractionResultHolder.success((Object)stack);
            }
            return InteractionResultHolder.pass((Object)stack);
        });
        LegendaryMonuments.LOGGER.info("Registered Azure Flute teleporter callbacks");
    }

    private static void scheduleTask(MinecraftServer server, int ticks, Runnable task) {
        new Thread(() -> {
            try {
                Thread.sleep((long)ticks * 50L);
                server.execute(task);
            }
            catch (InterruptedException e) {
                LegendaryMonuments.LOGGER.error("Task scheduling interrupted", (Throwable)e);
            }
        }).start();
    }
}

