/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;

public class DistortionPortalItem
extends Item {
    private static final ResourceKey<Level> DISTORTION_WORLD = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"distortion_world"));

    public DistortionPortalItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.getItemInHand(hand);
        if (!world.isClientSide && user instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)user;
            if (player.level().dimension().equals(DISTORTION_WORLD)) {
                this.teleportToOverworldSpawn(player);
            } else {
                this.teleportToDistortionWorld(player);
            }
        }
        return InteractionResultHolder.sidedSuccess((Object)stack, (boolean)world.isClientSide);
    }

    private void teleportToDistortionWorld(ServerPlayer player) {
        ServerLevel targetWorld = player.getServer().getLevel(DISTORTION_WORLD);
        if (targetWorld == null) {
            return;
        }
        BlockPos targetPos = player.blockPosition();
        Vec3 targetVec = new Vec3((double)targetPos.getX() + 0.5, (double)targetPos.getY(), (double)targetPos.getZ() + 0.5);
        DimensionTransition target = new DimensionTransition(targetWorld, targetVec, player.getDeltaMovement(), player.getYRot(), player.getXRot(), DimensionTransition.DO_NOTHING);
        player.changeDimension(target);
    }

    private void teleportToOverworldSpawn(ServerPlayer player) {
        ServerLevel overworld = player.getServer().overworld();
        if (overworld == null) {
            return;
        }
        BlockPos spawnPos = player.getRespawnPosition();
        ResourceKey spawnDim = player.getRespawnDimension();
        BlockPos targetPos = spawnPos != null && spawnDim != null && spawnDim.equals(Level.OVERWORLD) ? spawnPos : overworld.getSharedSpawnPos();
        Vec3 targetVec = new Vec3((double)targetPos.getX() + 0.5, (double)targetPos.getY(), (double)targetPos.getZ() + 0.5);
        DimensionTransition target = new DimensionTransition(overworld, targetVec, player.getDeltaMovement(), player.getYRot(), player.getXRot(), DimensionTransition.DO_NOTHING);
        player.changeDimension(target);
    }
}

