/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class FullmoonWhistleItem
extends Item {
    private static final double SHINY_CHANCE = 0.02;

    public FullmoonWhistleItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (world.isClientSide) {
            return InteractionResultHolder.success((Object)stack);
        }
        boolean successful = this.spawnCresselia(world, player);
        if (successful) {
            world.playSound(null, player.blockPosition(), SoundEvents.BEACON_ACTIVATE, SoundSource.PLAYERS, 1.0f, 1.0f);
            stack.shrink(1);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    private boolean spawnCresselia(Level world, Player player) {
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        try {
            Random random = new Random();
            boolean isShiny = random.nextDouble() < 0.02;
            PokemonProperties properties = new PokemonProperties();
            properties.setSpecies("Cresselia");
            properties.setLevel(Integer.valueOf(50));
            if (isShiny) {
                properties.setShiny(Boolean.valueOf(true));
            }
            Pokemon pokemon = properties.create();
            PokemonEntity entity = new PokemonEntity((Level)serverWorld, pokemon, CobblemonEntities.POKEMON);
            double spawnX = player.getX() + player.getLookAngle().x * 3.0;
            double spawnY = player.getY() + 1.0;
            double spawnZ = player.getZ() + player.getLookAngle().z * 3.0;
            this.spawnCresseliaEffect(serverWorld, new BlockPos((int)spawnX, (int)spawnY, (int)spawnZ));
            entity.setPos(spawnX, spawnY, spawnZ);
            serverWorld.addFreshEntity((Entity)entity);
            if (isShiny) {
                player.displayClientMessage((Component)Component.literal((String)"The Fullmoon Whistle echoes with lunar beauty! ").withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.BOLD}).append((Component)Component.literal((String)"A SHINY Cresselia appears!").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})), false);
            } else {
                player.displayClientMessage((Component)Component.literal((String)"The Fullmoon Whistle's melody resonates! ").withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.BOLD}).append((Component)Component.literal((String)"A Cresselia appears!").withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD})), false);
            }
            LegendaryMonuments.LOGGER.info("Spawned {} Cresselia for player {}", (Object)(isShiny ? "shiny" : "regular"), (Object)player.getName().getString());
            return true;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Failed to spawn Cresselia", (Throwable)e);
            player.displayClientMessage((Component)Component.literal((String)"The Fullmoon Whistle's sound fades away unsuccessfully.").withStyle(ChatFormatting.RED), true);
            return false;
        }
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"item.legendarymonuments.fullmoon_whistle.tooltip.1").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.legendarymonuments.fullmoon_whistle.tooltip.2").withStyle(ChatFormatting.LIGHT_PURPLE));
        super.appendHoverText(stack, context, tooltip, type);
    }

    private void spawnCresseliaEffect(ServerLevel world, BlockPos pos) {
        int i;
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ILLUSIONER_PREPARE_MIRROR, SoundSource.NEUTRAL, 1.0f, 0.6f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BEACON_AMBIENT, SoundSource.NEUTRAL, 0.8f, 0.7f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (i = 0; i < 5; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 10.0;
            double offsetZ = (random.nextDouble() - 0.5) * 10.0;
            int height = 0;
            while (height < 20) {
                int h = height++;
                double x = (double)pos.getX() + offsetX;
                double z = (double)pos.getZ() + offsetZ;
                world.getServer().execute(() -> world.getServer().getCommands().performPrefixedCommand(source, String.format("particle minecraft:end_rod %.2f %.2f %.2f 0.1 0.1 0.1 0.01 3 force", x, (double)pos.getY() + (double)h * 0.5, z)));
            }
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.7 0.5 0.9 1.5 ~ ~1 ~ 3 2 3 0.05 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.9 0.7 1.0 1.2 ~ ~1 ~ 3 2 3 0.05 80 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:firework ~ ~2 ~ 3 2 3 0.05 70 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:enchant ~ ~1 ~ 3 2 3 0.5 150 force");
        for (i = 0; i < 36; ++i) {
            double angle = (double)i * Math.PI / 18.0;
            double x = (double)pos.getX() + Math.cos(angle) * 3.0;
            double z = (double)pos.getZ() + Math.sin(angle) * 3.0;
            if (!(angle > 1.5707963267948966) || !(angle < 4.71238898038469)) continue;
            world.getServer().getCommands().performPrefixedCommand(source, String.format("particle minecraft:end_rod %.2f %.2f %.2f 0.1 0.1 0.1 0.01 1 force", x, (double)pos.getY() + 1.0, z));
        }
        world.getServer().execute(() -> {
            try {
                Thread.sleep(600L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:cloud ~ ~1 ~ 2 0.5 2 0.01 20 force");
                for (int i = 0; i < 24; ++i) {
                    double angle = (double)i * Math.PI / 12.0;
                    double x = (double)pos.getX() + Math.cos(angle) * 2.0;
                    double z = (double)pos.getZ() + Math.sin(angle) * 2.0;
                    world.getServer().getCommands().performPrefixedCommand(source, String.format("particle minecraft:dust 0.8 0.8 1.0 1.0 %.2f %.2f %.2f 0.05 0.05 0.05 0 3 force", x, (double)pos.getY() + 2.0, z));
                }
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ILLUSIONER_MIRROR_MOVE, SoundSource.NEUTRAL, 1.0f, 0.7f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }
}

