/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import github.jorgaomc.particles.ModParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;

public class GalarParticleItem
extends Item {
    public GalarParticleItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos blockPos = context.getClickedPos();
        BlockPos blockPos2 = blockPos.relative(context.getClickedFace());
        if (GalarParticleItem.applyBoneMeal(context.getItemInHand(), world, blockPos)) {
            if (!world.isClientSide) {
                world.levelEvent(1505, blockPos, 0);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        BlockState blockState = world.getBlockState(blockPos);
        boolean bl = blockState.isFaceSturdy((BlockGetter)world, blockPos, context.getClickedFace());
        if (bl && GalarParticleItem.applyBoneMeal(context.getItemInHand(), world, blockPos2)) {
            if (!world.isClientSide) {
                world.levelEvent(1505, blockPos2, 0);
            }
            return InteractionResult.sidedSuccess((boolean)world.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static boolean applyBoneMeal(ItemStack stack, Level world, BlockPos pos) {
        BonemealableBlock fertilizable;
        BlockState blockState = world.getBlockState(pos);
        Block block = blockState.getBlock();
        if (block instanceof BonemealableBlock && (fertilizable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)world, pos, blockState)) {
            if (world instanceof ServerLevel) {
                if (fertilizable.isBonemealSuccess(world, world.random, pos, blockState)) {
                    fertilizable.performBonemeal((ServerLevel)world, world.random, pos, blockState);
                    GalarParticleItem.spawnGalarParticles((ServerLevel)world, pos);
                    world.playSound(null, pos, SoundEvents.BONE_MEAL_USE, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                stack.shrink(1);
            }
            return true;
        }
        return false;
    }

    private static void spawnGalarParticles(ServerLevel world, BlockPos pos) {
        for (int offsetX = -1; offsetX <= 1; ++offsetX) {
            for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                double f;
                double e;
                double d;
                int i;
                BlockPos particlePos = pos.offset(offsetX, 0, offsetZ);
                if (world.getBlockState(particlePos.above()).canOcclude()) continue;
                for (i = 0; i < 2; ++i) {
                    d = world.random.nextGaussian() * 0.02;
                    e = world.random.nextGaussian() * 0.02;
                    f = world.random.nextGaussian() * 0.02;
                    world.sendParticles((ParticleOptions)ModParticles.GROW1, (double)particlePos.getX() + 0.5 + world.random.nextDouble() * 0.5 - 0.25, (double)particlePos.getY() + 0.2 + world.random.nextDouble(), (double)particlePos.getZ() + 0.5 + world.random.nextDouble() * 0.5 - 0.25, 1, d, e, f, 0.0);
                }
                for (i = 0; i < 2; ++i) {
                    d = world.random.nextGaussian() * 0.02;
                    e = world.random.nextGaussian() * 0.02;
                    f = world.random.nextGaussian() * 0.02;
                    world.sendParticles((ParticleOptions)ModParticles.GROW2, (double)particlePos.getX() + 0.5 + world.random.nextDouble() * 0.5 - 0.25, (double)particlePos.getY() + 0.2 + world.random.nextDouble(), (double)particlePos.getZ() + 0.5 + world.random.nextDouble() * 0.5 - 0.25, 1, d, e, f, 0.0);
                }
                for (i = 0; i < 2; ++i) {
                    d = world.random.nextGaussian() * 0.02;
                    e = world.random.nextGaussian() * 0.02;
                    f = world.random.nextGaussian() * 0.02;
                    world.sendParticles((ParticleOptions)ModParticles.GROW3, (double)particlePos.getX() + 0.5 + world.random.nextDouble() * 0.5 - 0.25, (double)particlePos.getY() + 0.2 + world.random.nextDouble(), (double)particlePos.getZ() + 0.5 + world.random.nextDouble() * 0.5 - 0.25, 1, d, e, f, 0.0);
                }
            }
        }
    }
}

