/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import github.jorgaomc.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class GalarianTorchItem
extends BlockItem {
    public GalarianTorchItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    protected BlockState getPlacementState(BlockPlaceContext context) {
        Direction side = context.getClickedFace();
        BlockPos placePos = context.getClickedPos();
        BlockPos attachPos = placePos.relative(side.getOpposite());
        BlockState attachState = context.getLevel().getBlockState(attachPos);
        if (side == Direction.UP) {
            return ModBlocks.GALARIAN_TORCH.getStateForPlacement(context);
        }
        if (side.getAxis().isHorizontal()) {
            boolean isLadderBlock = attachState.getBlock().getClass().getSimpleName().toLowerCase().contains("ladder");
            if (isLadderBlock) {
                return null;
            }
            Direction facing = side;
            BlockState wallTorchState = (BlockState)ModBlocks.GALARIAN_WALL_TORCH.defaultBlockState().setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)facing);
            boolean isLeafBlock = attachState.getBlock().getClass().getSimpleName().toLowerCase().contains("leaves");
            if (isLeafBlock || wallTorchState.canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) {
                return wallTorchState;
            }
        }
        return ModBlocks.GALARIAN_TORCH.getStateForPlacement(context);
    }
}

