/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class KeldeoDangoItem
extends Item {
    private static final double SHINY_CHANCE = 0.02;

    public KeldeoDangoItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (world.isClientSide) {
            return InteractionResultHolder.success((Object)stack);
        }
        boolean successful = this.spawnKeldeo(world, player);
        if (successful) {
            world.playSound(null, player.blockPosition(), SoundEvents.BEACON_ACTIVATE, SoundSource.PLAYERS, 1.0f, 1.0f);
            stack.shrink(1);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    private boolean spawnKeldeo(Level world, Player player) {
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        try {
            Random random = new Random();
            boolean isShiny = random.nextDouble() < 0.02;
            PokemonProperties properties = new PokemonProperties();
            properties.setSpecies("Keldeo");
            properties.setLevel(Integer.valueOf(50));
            if (isShiny) {
                properties.setShiny(Boolean.valueOf(true));
            }
            Pokemon pokemon = properties.create();
            PokemonEntity entity = new PokemonEntity((Level)serverWorld, pokemon, CobblemonEntities.POKEMON);
            double spawnX = player.getX() + player.getLookAngle().x * 3.0;
            double spawnY = player.getY() + 1.0;
            double spawnZ = player.getZ() + player.getLookAngle().z * 3.0;
            this.spawnKeldeoEffect(serverWorld, new BlockPos((int)spawnX, (int)spawnY, (int)spawnZ));
            entity.setPos(spawnX, spawnY, spawnZ);
            serverWorld.addFreshEntity((Entity)entity);
            if (isShiny) {
                player.displayClientMessage((Component)Component.literal((String)"The Curry of Justice tasted amazingly! ").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}).append((Component)Component.literal((String)"A SHINY Keldeo appears!").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})), false);
            } else {
                player.displayClientMessage((Component)Component.literal((String)"The Curry of Justice tasted great! ").withStyle(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}).append((Component)Component.literal((String)"A Keldeo appears!").withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD})), false);
            }
            LegendaryMonuments.LOGGER.info("Spawned {} Keldeo for player {}", (Object)(isShiny ? "shiny" : "regular"), (Object)player.getName().getString());
            return true;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Failed to spawn Keldeo", (Throwable)e);
            player.displayClientMessage((Component)Component.literal((String)"The Curry of Justice fizzles out unsuccessfully.").withStyle(ChatFormatting.RED), true);
            return false;
        }
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"item.legendarymonuments.curry_of_justice.tooltip.1").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.legendarymonuments.curry_of_justice.tooltip.2").withStyle(ChatFormatting.BLUE));
        super.appendHoverText(stack, context, tooltip, type);
    }

    private void spawnKeldeoEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.HORSE_GALLOP, SoundSource.NEUTRAL, 1.0f, 1.2f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.DOLPHIN_SPLASH, SoundSource.NEUTRAL, 1.0f, 1.0f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int height = 0; height < 8; ++height) {
            int h = height;
            world.getServer().execute(() -> world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:splash ~ " + ((double)pos.getY() + (double)h * 0.5) + " ~ 1 0.1 1 0.1 20 force"));
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.0 0.6 1.0 1.5 ~ ~1 ~ 3 2 3 0.05 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.9 0.2 0.3 1.0 ~ ~1 ~ 3 2 3 0.05 70 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:splash ~ ~1 ~ 3 2 3 0.4 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:bubble_column_up ~ ~1 ~ 2 2 2 0.2 100 force");
        for (int i = 0; i < 24; ++i) {
            double angle = (double)i * Math.PI / 12.0;
            double distance = 3.0;
            double x = (double)pos.getX() + Math.cos(angle) * distance;
            double z = (double)pos.getZ() + Math.sin(angle) * distance;
            world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.6 0.5 0.2 1.0 " + x + " " + ((double)pos.getY() + 0.1) + " " + z + " 0.2 0.0 0.2 0 1 force");
        }
        world.getServer().execute(() -> {
            try {
                Thread.sleep(300L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:splash ~ ~1 ~ 2 2 2 0.2 80 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:end_rod ~ ~1.5 ~ 0.2 1.5 0.2 0.05 50 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.HORSE_JUMP, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }
}

