/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class NewmoonWhistleItem
extends Item {
    private static final double SHINY_CHANCE = 0.02;

    public NewmoonWhistleItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (world.isClientSide) {
            return InteractionResultHolder.success((Object)stack);
        }
        boolean successful = this.spawnDarkrai(world, player);
        if (successful) {
            world.playSound(null, player.blockPosition(), SoundEvents.BEACON_ACTIVATE, SoundSource.PLAYERS, 1.0f, 1.0f);
            stack.shrink(1);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    private boolean spawnDarkrai(Level world, Player player) {
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        try {
            Pokemon pokemon;
            Random random = new Random();
            boolean isShiny = random.nextDouble() < 0.02;
            PokemonProperties properties = new PokemonProperties();
            properties.setSpecies("darkrai");
            properties.setLevel(Integer.valueOf(50));
            if (isShiny) {
                properties.setShiny(Boolean.valueOf(true));
            }
            LegendaryMonuments.LOGGER.info("Created Darkrai pokemon object: {}", (Object)((pokemon = properties.create()) != null ? 1 : 0));
            PokemonEntity entity = new PokemonEntity((Level)serverWorld, pokemon, CobblemonEntities.POKEMON);
            LegendaryMonuments.LOGGER.info("Created Darkrai entity object: {}", (Object)(entity != null ? 1 : 0));
            double spawnX = player.getX() + player.getLookAngle().x * 3.0;
            double spawnY = player.getY() + 1.0;
            double spawnZ = player.getZ() + player.getLookAngle().z * 3.0;
            entity.setPos(spawnX, spawnY, spawnZ);
            try {
                this.spawnDarkraiEffect(serverWorld, new BlockPos((int)spawnX, (int)spawnY, (int)spawnZ));
            }
            catch (Exception e) {
                LegendaryMonuments.LOGGER.error("Error in particle effect but continuing with spawn", (Throwable)e);
            }
            boolean spawned = serverWorld.addFreshEntity((Entity)entity);
            LegendaryMonuments.LOGGER.info("Darkrai entity spawn result: {}", (Object)spawned);
            if (isShiny) {
                player.displayClientMessage((Component)Component.literal((String)"The Newmoon Whistle creates an eerie void! ").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD}).append((Component)Component.literal((String)"A SHINY Darkrai appears!").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})), false);
            } else {
                player.displayClientMessage((Component)Component.literal((String)"The Newmoon Whistle summons shadows! ").withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD}).append((Component)Component.literal((String)"A Darkrai appears!").withStyle(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.BOLD})), false);
            }
            LegendaryMonuments.LOGGER.info("Spawned {} Darkrai for player {}", (Object)(isShiny ? "shiny" : "regular"), (Object)player.getName().getString());
            return spawned;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Failed to spawn Darkrai", (Throwable)e);
            player.displayClientMessage((Component)Component.literal((String)"The Newmoon Whistle's darkness dissipates unsuccessfully.").withStyle(ChatFormatting.RED), true);
            return false;
        }
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"item.legendarymonuments.newmoon_whistle.tooltip.1").withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.legendarymonuments.newmoon_whistle.tooltip.2").withStyle(ChatFormatting.DARK_PURPLE));
        super.appendHoverText(stack, context, tooltip, type);
    }

    private void spawnDarkraiEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.WITHER_AMBIENT, SoundSource.HOSTILE, 0.7f, 0.4f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.HOSTILE, 0.6f, 0.5f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int radius = 1; radius < 12; ++radius) {
            int r = radius;
            world.getServer().execute(() -> world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:large_smoke ~ ~1 ~ " + (double)r * 0.3 + " 0.5 " + (double)r * 0.3 + " 0.01 " + r * 2 + " force"));
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        for (int i = 0; i < 5; ++i) {
            double offsetX = (random.nextDouble() - 0.5) * 8.0;
            double offsetZ = (random.nextDouble() - 0.5) * 8.0;
            world.getServer().getCommands().performPrefixedCommand(source, String.format("particle minecraft:portal %s %s %s 0.7 1.0 0.7 0.5 100 force", (double)pos.getX() + offsetX, pos.getY(), (double)pos.getZ() + offsetZ));
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.1 0.0 0.1 1.5 ~ ~1 ~ 4 2 4 0.05 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:sculk_soul ~ ~1 ~ 5 2 5 0.1 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:soul_fire_flame ~ ~1 ~ 3 2 3 0.05 80 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:reverse_portal ~ ~1 ~ 1 1 1 0.1 100 force");
        world.getServer().execute(() -> {
            try {
                Thread.sleep(500L);
                for (int radius = 1; radius < 10; radius += 2) {
                    int r = radius;
                    world.getServer().execute(() -> {
                        for (int i = 0; i < 36; ++i) {
                            double angle = (double)i * Math.PI / 18.0;
                            double x = (double)pos.getX() + Math.cos(angle) * (double)r;
                            double z = (double)pos.getZ() + Math.sin(angle) * (double)r;
                            world.getServer().getCommands().performPrefixedCommand(source, String.format("particle minecraft:dust 0.0 0.0 0.0 1.0 %s %s %s 0.0 0.0 0.0 0 1 force", x, (double)pos.getY() + 0.5, z));
                        }
                    });
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.VEX_AMBIENT, SoundSource.HOSTILE, 0.7f, 0.5f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }
}

