/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModItems;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ProofOfConquestAItem
extends Item {
    private static final double SHINY_CHANCE = 0.02;

    public ProofOfConquestAItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (world.isClientSide) {
            return InteractionResultHolder.success((Object)stack);
        }
        boolean successful = this.spawnAzelf(world, player);
        if (successful) {
            world.playSound(null, player.blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 1.0f, 1.2f);
            ItemStack plumeStack = new ItemStack((ItemLike)ModItems.AZELF_FANG, 1);
            if (!player.getInventory().add(plumeStack)) {
                player.drop(plumeStack, false);
            }
            stack.shrink(1);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    private boolean spawnAzelf(Level world, Player player) {
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        try {
            Random random = new Random();
            boolean isShiny = random.nextDouble() < 0.02;
            PokemonProperties properties = new PokemonProperties();
            properties.setSpecies("Azelf");
            properties.setLevel(Integer.valueOf(50));
            if (isShiny) {
                properties.setShiny(Boolean.valueOf(true));
            }
            Pokemon pokemon = properties.create();
            PokemonEntity entity = new PokemonEntity((Level)serverWorld, pokemon, CobblemonEntities.POKEMON);
            double spawnX = player.getX() + player.getLookAngle().x * 3.0;
            double spawnY = player.getY() + 1.0;
            double spawnZ = player.getZ() + player.getLookAngle().z * 3.0;
            this.spawnAzelfEffect(serverWorld, new BlockPos((int)spawnX, (int)spawnY, (int)spawnZ));
            entity.setPos(spawnX, spawnY, spawnZ);
            serverWorld.addFreshEntity((Entity)entity);
            if (isShiny) {
                player.displayClientMessage((Component)Component.literal((String)"The Proof of Conquest blazes with determination! ").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}).append((Component)Component.literal((String)"A SHINY Azelf appears!").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})), false);
            } else {
                player.displayClientMessage((Component)Component.literal((String)"The Proof of Conquest surges with willpower! ").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}).append((Component)Component.literal((String)"An Azelf appears!").withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD})), false);
            }
            player.displayClientMessage((Component)Component.literal((String)"You've received a Azelf's Fang!").withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}), false);
            LegendaryMonuments.LOGGER.info("Spawned {} Azelf for player {}", (Object)(isShiny ? "shiny" : "regular"), (Object)player.getName().getString());
            return true;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Failed to spawn Azelf", (Throwable)e);
            player.displayClientMessage((Component)Component.literal((String)"The Proof of Conquest loses its resolve.").withStyle(ChatFormatting.RED), true);
            return false;
        }
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"item.legendarymonuments.proof_of_conquest_a.tooltip.1").withStyle(ChatFormatting.YELLOW));
        super.appendHoverText(stack, context, tooltip, type);
    }

    private void spawnAzelfEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ILLUSIONER_PREPARE_MIRROR, SoundSource.NEUTRAL, 0.8f, 1.5f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LIGHTNING_BOLT_THUNDER, SoundSource.NEUTRAL, 0.6f, 1.8f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int height = 0; height < 12; ++height) {
            int h = height;
            world.getServer().execute(() -> world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:enchant ~ " + ((double)pos.getY() + (double)h * 0.3) + " ~ 1.2 0.1 1.2 0.15 20 force"));
            try {
                Thread.sleep(35L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.2 0.5 1.0 1.5 ~ ~1 ~ 3 2 3 0.05 140 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 1.0 0.9 0.2 1.2 ~ ~1 ~ 3 2 3 0.05 90 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:electric_spark ~ ~1 ~ 2 2 2 0.3 80 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:end_rod ~ ~1.5 ~ 0.2 1.5 0.2 0.08 60 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:totem_of_undying ~ ~1 ~ 1.5 1 1.5 0.1 25 force");
        for (int i = 0; i < 24; ++i) {
            double angle = (double)i * Math.PI / 12.0;
            double distance = 4.0;
            double x = (double)pos.getX() + Math.cos(angle) * distance;
            double z = (double)pos.getZ() + Math.sin(angle) * distance;
            world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.3 0.6 1.0 1.3 " + x + " " + ((double)pos.getY() + 0.8) + " " + z + " 0.1 0.3 0.1 0 2 force");
            world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 1.0 0.8 0.1 1.0 " + x + " " + ((double)pos.getY() + 1.2) + " " + z + " 0.1 0.2 0.1 0 1 force");
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:poof ~ ~1 ~ 2 1.5 2 0.1 40 force");
        world.getServer().execute(() -> {
            try {
                Thread.sleep(200L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:electric_spark ~ ~1 ~ 4 0.2 4 0.2 120 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:totem_of_undying ~ ~1.5 ~ 2 1 2 0.05 20 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BEACON_POWER_SELECT, SoundSource.NEUTRAL, 1.0f, 1.3f);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.1 0.4 0.9 2.0 ~ ~1 ~ 2.5 2 2.5 0.1 70 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.9 0.8 0.1 2.0 ~ ~1 ~ 2.5 2 2.5 0.1 50 force");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        world.getServer().execute(() -> {
            try {
                Thread.sleep(450L);
                for (int i = 0; i < 16; ++i) {
                    int boltIndex = i;
                    world.getServer().execute(() -> {
                        double angle = (double)boltIndex * Math.PI / 8.0;
                        double distance = 3.0 + random.nextDouble() * 2.0;
                        double boltX = (double)pos.getX() + Math.cos(angle) * distance;
                        double boltZ = (double)pos.getZ() + Math.sin(angle) * distance;
                        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:electric_spark " + boltX + " " + ((double)pos.getY() + 0.5 + random.nextDouble()) + " " + boltZ + " 0 0.3 0 0.05 3 force");
                    });
                    try {
                        Thread.sleep(60L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ILLUSIONER_PREPARE_MIRROR, SoundSource.NEUTRAL, 1.0f, 1.2f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }
}

