/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModItems;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ProofOfConquestMItem
extends Item {
    private static final double SHINY_CHANCE = 0.02;

    public ProofOfConquestMItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (world.isClientSide) {
            return InteractionResultHolder.success((Object)stack);
        }
        boolean successful = this.spawnMesprit(world, player);
        if (successful) {
            world.playSound(null, player.blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 1.0f, 1.2f);
            ItemStack plumeStack = new ItemStack((ItemLike)ModItems.MESPRIT_PLUME, 1);
            if (!player.getInventory().add(plumeStack)) {
                player.drop(plumeStack, false);
            }
            stack.shrink(1);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    private boolean spawnMesprit(Level world, Player player) {
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        try {
            Random random = new Random();
            boolean isShiny = random.nextDouble() < 0.02;
            PokemonProperties properties = new PokemonProperties();
            properties.setSpecies("Mesprit");
            properties.setLevel(Integer.valueOf(50));
            if (isShiny) {
                properties.setShiny(Boolean.valueOf(true));
            }
            Pokemon pokemon = properties.create();
            PokemonEntity entity = new PokemonEntity((Level)serverWorld, pokemon, CobblemonEntities.POKEMON);
            double spawnX = player.getX() + player.getLookAngle().x * 3.0;
            double spawnY = player.getY() + 1.0;
            double spawnZ = player.getZ() + player.getLookAngle().z * 3.0;
            this.spawnMespritEffect(serverWorld, new BlockPos((int)spawnX, (int)spawnY, (int)spawnZ));
            entity.setPos(spawnX, spawnY, spawnZ);
            serverWorld.addFreshEntity((Entity)entity);
            if (isShiny) {
                player.displayClientMessage((Component)Component.literal((String)"The Proof of Conquest overflows with psychic energy! ").withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.BOLD}).append((Component)Component.literal((String)"A SHINY Mesprit appears!").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})), false);
            } else {
                player.displayClientMessage((Component)Component.literal((String)"The Proof of Conquest resonates with emotion! ").withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.BOLD}).append((Component)Component.literal((String)"A Mesprit appears!").withStyle(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.BOLD})), false);
            }
            player.displayClientMessage((Component)Component.literal((String)"You've received a Mesprit's Plume!").withStyle(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.ITALIC}), false);
            LegendaryMonuments.LOGGER.info("Spawned {} Mesprit for player {}", (Object)(isShiny ? "shiny" : "regular"), (Object)player.getName().getString());
            return true;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Failed to spawn Mesprit", (Throwable)e);
            player.displayClientMessage((Component)Component.literal((String)"The Proof of Conquest fails to resonate.").withStyle(ChatFormatting.RED), true);
            return false;
        }
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"item.legendarymonuments.proof_of_conquest_m.tooltip.1").withStyle(ChatFormatting.LIGHT_PURPLE));
        super.appendHoverText(stack, context, tooltip, type);
    }

    private void spawnMespritEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ILLUSIONER_PREPARE_MIRROR, SoundSource.NEUTRAL, 0.8f, 1.5f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AMETHYST_BLOCK_CHIME, SoundSource.NEUTRAL, 1.0f, 1.3f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int height = 0; height < 10; ++height) {
            int h = height;
            world.getServer().execute(() -> world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:enchant ~ " + ((double)pos.getY() + (double)h * 0.4) + " ~ 1.5 0.1 1.5 0.1 15 force"));
            try {
                Thread.sleep(40L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 1.0 0.4 0.8 1.5 ~ ~1 ~ 3 2 3 0.05 120 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.8 0.2 0.6 1.0 ~ ~1 ~ 3 2 3 0.05 80 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:heart ~ ~1.5 ~ 2 1 2 0.1 20 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:portal ~ ~1 ~ 2 2 2 0.3 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:end_rod ~ ~1.5 ~ 0.3 1.2 0.3 0.05 40 force");
        for (int i = 0; i < 32; ++i) {
            double angle = (double)i * Math.PI / 16.0;
            double distance = 3.5;
            double x = (double)pos.getX() + Math.cos(angle) * distance;
            double z = (double)pos.getZ() + Math.sin(angle) * distance;
            world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.9 0.3 0.7 1.0 " + x + " " + ((double)pos.getY() + 0.5) + " " + z + " 0.1 0.1 0.1 0 1 force");
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:soul ~ ~1 ~ 2 1.5 2 0.05 60 force");
        world.getServer().execute(() -> {
            try {
                Thread.sleep(250L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:enchant ~ ~1 ~ 4 0.1 4 0.1 150 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:heart ~ ~2 ~ 1.5 1 1.5 0.05 15 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.NEUTRAL, 0.8f, 1.5f);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 1.0 0.5 0.9 2.0 ~ ~1 ~ 2 2 2 0.1 80 force");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        world.getServer().execute(() -> {
            try {
                Thread.sleep(500L);
                for (int i = 0; i < 8; ++i) {
                    int heartIndex = i;
                    world.getServer().execute(() -> {
                        double heartX = (double)pos.getX() + (random.nextDouble() - 0.5) * 4.0;
                        double heartZ = (double)pos.getZ() + (random.nextDouble() - 0.5) * 4.0;
                        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:heart " + heartX + " " + ((double)pos.getY() + 0.5) + " " + heartZ + " 0 0.5 0 0.02 1 force");
                    });
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ILLUSIONER_PREPARE_MIRROR, SoundSource.NEUTRAL, 0.8f, 1.5f);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }
}

