/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModItems;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ProofOfConquestUItem
extends Item {
    private static final double SHINY_CHANCE = 0.02;

    public ProofOfConquestUItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (world.isClientSide) {
            return InteractionResultHolder.success((Object)stack);
        }
        boolean successful = this.spawnUxie(world, player);
        if (successful) {
            world.playSound(null, player.blockPosition(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.PLAYERS, 1.0f, 1.2f);
            ItemStack plumeStack = new ItemStack((ItemLike)ModItems.UXIE_CLAW, 1);
            if (!player.getInventory().add(plumeStack)) {
                player.drop(plumeStack, false);
            }
            stack.shrink(1);
        }
        return InteractionResultHolder.success((Object)stack);
    }

    private boolean spawnUxie(Level world, Player player) {
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        try {
            Random random = new Random();
            boolean isShiny = random.nextDouble() < 0.02;
            PokemonProperties properties = new PokemonProperties();
            properties.setSpecies("Uxie");
            properties.setLevel(Integer.valueOf(50));
            if (isShiny) {
                properties.setShiny(Boolean.valueOf(true));
            }
            Pokemon pokemon = properties.create();
            PokemonEntity entity = new PokemonEntity((Level)serverWorld, pokemon, CobblemonEntities.POKEMON);
            double spawnX = player.getX() + player.getLookAngle().x * 3.0;
            double spawnY = player.getY() + 1.0;
            double spawnZ = player.getZ() + player.getLookAngle().z * 3.0;
            this.spawnUxieEffect(serverWorld, new BlockPos((int)spawnX, (int)spawnY, (int)spawnZ));
            entity.setPos(spawnX, spawnY, spawnZ);
            serverWorld.addFreshEntity((Entity)entity);
            if (isShiny) {
                player.displayClientMessage((Component)Component.literal((String)"The Proof of Conquest radiates infinite knowledge! ").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).append((Component)Component.literal((String)"A SHINY Uxie appears!").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD})), false);
            } else {
                player.displayClientMessage((Component)Component.literal((String)"The Proof of Conquest glows with ancient wisdom! ").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}).append((Component)Component.literal((String)"A Uxie appears!").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD})), false);
            }
            player.displayClientMessage((Component)Component.literal((String)"You've received a Uxie's Claw!").withStyle(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.ITALIC}), false);
            LegendaryMonuments.LOGGER.info("Spawned {} Uxie for player {}", (Object)(isShiny ? "shiny" : "regular"), (Object)player.getName().getString());
            return true;
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Failed to spawn Uxie", (Throwable)e);
            player.displayClientMessage((Component)Component.literal((String)"The Proof of Conquest's wisdom fades away.").withStyle(ChatFormatting.RED), true);
            return false;
        }
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"item.legendarymonuments.proof_of_conquest_u.tooltip.1").withStyle(ChatFormatting.GOLD));
        super.appendHoverText(stack, context, tooltip, type);
    }

    private void spawnUxieEffect(ServerLevel world, BlockPos pos) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ILLUSIONER_PREPARE_MIRROR, SoundSource.NEUTRAL, 0.8f, 1.5f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.NEUTRAL, 1.2f, 0.8f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int height = 0; height < 14; ++height) {
            int h = height;
            world.getServer().execute(() -> world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:enchant ~ " + ((double)pos.getY() + (double)h * 0.25) + " ~ 1.8 0.1 1.8 0.08 25 force"));
            try {
                Thread.sleep(45L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 1.0 0.8 0.2 1.8 ~ ~1 ~ 3.5 2 3.5 0.03 160 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 1.0 1.0 0.9 1.3 ~ ~1 ~ 3 2 3 0.04 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:glow ~ ~1.2 ~ 2.5 1.5 2.5 0.05 80 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:end_rod ~ ~1.8 ~ 0.4 1.8 0.4 0.04 70 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:note ~ ~1 ~ 2 1.5 2 0.1 15 force");
        for (int i = 0; i < 36; ++i) {
            double angle = (double)i * Math.PI / 18.0;
            double distance = 4.5;
            double x = (double)pos.getX() + Math.cos(angle) * distance;
            double z = (double)pos.getZ() + Math.sin(angle) * distance;
            world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.9 0.7 0.1 1.5 " + x + " " + ((double)pos.getY() + 0.3) + " " + z + " 0.05 0.1 0.05 0 1 force");
            if (i % 3 != 0) continue;
            world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 1.0 0.95 0.8 1.2 " + x + " " + ((double)pos.getY() + 0.8) + " " + z + " 0.05 0.2 0.05 0 1 force");
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:glow ~ ~0.5 ~ 3 0.5 3 0.02 120 force");
        world.getServer().execute(() -> {
            try {
                Thread.sleep(300L);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 1.0 0.75 0.15 2.2 ~ ~1 ~ 5 0.3 5 0.02 200 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:glow ~ ~1.5 ~ 2.5 1.2 2.5 0.03 60 force");
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.ENCHANTMENT_TABLE_USE, SoundSource.NEUTRAL, 1.0f, 0.9f);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.95 0.8 0.25 2.5 ~ ~1 ~ 3 2.5 3 0.08 100 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:note ~ ~2 ~ 3 1 3 0.05 20 force");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        world.getServer().execute(() -> {
            try {
                Thread.sleep(550L);
                for (int i = 0; i < 12; ++i) {
                    int waveIndex = i;
                    world.getServer().execute(() -> {
                        double angle = (double)waveIndex * Math.PI / 6.0;
                        double distance = 2.5 + random.nextDouble() * 2.5;
                        double waveX = (double)pos.getX() + Math.cos(angle) * distance;
                        double waveZ = (double)pos.getZ() + Math.sin(angle) * distance;
                        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:glow " + waveX + " " + ((double)pos.getY() + 0.8 + random.nextDouble() * 0.5) + " " + waveZ + " 0 0.2 0 0.02 2 force");
                        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:dust 0.9 0.75 0.2 1.0 " + waveX + " " + ((double)pos.getY() + 1.2) + " " + waveZ + " 0.1 0.1 0.1 0 1 force");
                    });
                    try {
                        Thread.sleep(80L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.NEUTRAL, 1.0f, 1.2f);
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:enchant ~ ~1 ~ 4 2 4 0.05 80 force");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }
}

