/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import github.jorgaomc.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class RedChainItem
extends Item {
    private final boolean isBroken;

    public RedChainItem(Item.Properties settings, boolean isBroken) {
        super(settings);
        this.isBroken = isBroken;
    }

    public boolean isBarVisible(ItemStack stack) {
        return this.isBroken || stack.isDamaged();
    }

    public int getBarColor(ItemStack stack) {
        if (this.isBroken) {
            float f = Math.max(0.0f, (float)(100 - stack.getDamageValue()) / 100.0f);
            return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
        }
        float f = Math.max(0.0f, (float)(stack.getMaxDamage() - stack.getDamageValue()) / (float)stack.getMaxDamage());
        return Mth.hsvToRgb((float)(f / 3.0f), (float)1.0f, (float)1.0f);
    }

    public int getBarWidth(ItemStack stack) {
        if (this.isBroken) {
            int damage = stack.getDamageValue();
            int durability = 100 - damage;
            return Math.round(13.0f * (float)durability / 100.0f);
        }
        return Math.round(13.0f - (float)stack.getDamageValue() * 13.0f / (float)stack.getMaxDamage());
    }

    public ItemStack getRecipeRemainder(ItemStack stack) {
        if (!this.isBroken && stack.isDamageableItem()) {
            ItemStack brokenChain = new ItemStack((ItemLike)ModItems.FRAGMENTED_RED_CHAIN);
            brokenChain.setDamageValue(100);
            return brokenChain;
        }
        return ItemStack.EMPTY;
    }

    public boolean hasCraftingRemainingItem() {
        return !this.isBroken;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        if (!this.isBroken) {
            return false;
        }
        return ingredient.is(ModItems.ORIGIN_INGOT);
    }

    public static ItemStack repairInAnvil(ItemStack brokenChain, ItemStack repairMaterial, @Nullable Player player) {
        ItemStack result;
        if (!brokenChain.is(ModItems.FRAGMENTED_RED_CHAIN) || !repairMaterial.is(ModItems.ORIGIN_INGOT)) {
            return ItemStack.EMPTY;
        }
        int repairAmount = Math.min(repairMaterial.getCount(), 10);
        int durabilityRestored = repairAmount * 10;
        int currentDurability = brokenChain.getMaxDamage() - brokenChain.getDamageValue();
        int newDurability = Math.min(100, currentDurability + durabilityRestored);
        if (newDurability >= 100) {
            result = new ItemStack((ItemLike)ModItems.RED_CHAIN);
            result.setDamageValue(0);
        } else {
            result = new ItemStack((ItemLike)ModItems.FRAGMENTED_RED_CHAIN);
            result.setDamageValue(100 - newDurability);
        }
        result.applyComponents(brokenChain.getComponents());
        result.setDamageValue(newDurability >= 100 ? 0 : 100 - newDurability);
        if (player != null && player.level() != null) {
            player.level().playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ANVIL_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        return result;
    }

    public void onCraftedBy(ItemStack stack, Level world, Player player) {
        if (!this.isBroken && stack.getDamageValue() >= stack.getMaxDamage()) {
            ItemStack brokenVersion = new ItemStack((ItemLike)ModItems.FRAGMENTED_RED_CHAIN);
            brokenVersion.setDamageValue(brokenVersion.getMaxDamage());
        }
    }

    public boolean isBroken() {
        return this.isBroken;
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"item.legendarymonuments.red_chain.tooltip.1").withStyle(ChatFormatting.GOLD));
        tooltip.add((Component)Component.translatable((String)"item.legendarymonuments.red_chain.tooltip.2").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltip, type);
    }
}

