/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.cobblemon.mod.common.api.battles.model.actor.BattleActor;
import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.battles.pokemon.BattlePokemon;
import com.cobblemon.mod.common.item.battle.BagItem;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class SacredAshItem
extends Item
implements BagItem {
    public SacredAshItem(Item.Properties settings) {
        super(settings);
    }

    public String getItemName() {
        return "Sacred Ash";
    }

    public Item getReturnItem() {
        return Items.AIR;
    }

    public boolean canUse(PokemonBattle battle, BattlePokemon target) {
        return target.getHealth() < target.getMaxHealth() || target.getHealth() <= 0 || this.needsPPRestore(target);
    }

    public boolean canStillUse(ServerPlayer player, PokemonBattle battle, BattleActor actor, BattlePokemon target, ItemStack stack) {
        return this.canUse(battle, target) && stack.getCount() > 0;
    }

    public String getShowdownInput(BattleActor actor, BattlePokemon battlePokemon, String data) {
        return "sacredash";
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (world.isClientSide) {
            return InteractionResultHolder.success((Object)stack);
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResultHolder.fail((Object)stack);
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        PlayerPartyStore party = Cobblemon.INSTANCE.getStorage().getParty(serverPlayer);
        boolean anyHealed = false;
        for (int i = 0; i < party.size(); ++i) {
            boolean wasHealed;
            Pokemon pokemon = party.get(i);
            if (pokemon == null || !(wasHealed = this.healPokemon(pokemon))) continue;
            anyHealed = true;
        }
        if (anyHealed) {
            player.displayClientMessage((Component)Component.translatable((String)"item.legendarymonuments.sacred_ash.heal_success"), true);
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
            return InteractionResultHolder.consume((Object)stack);
        }
        player.displayClientMessage((Component)Component.translatable((String)"item.legendarymonuments.sacred_ash.no_effect"), true);
        return InteractionResultHolder.fail((Object)stack);
    }

    private boolean healPokemon(Pokemon pokemon) {
        boolean wasHealed = false;
        boolean isFainted = pokemon.isFainted();
        boolean hasLowHealth = pokemon.getCurrentHealth() < pokemon.getMaxHealth();
        boolean hasLowPP = pokemon.getMoveSet().getMoves().stream().anyMatch(move -> move != null && move.getCurrentPp() < move.getMaxPp());
        if (isFainted || hasLowHealth || hasLowPP) {
            if (isFainted || hasLowHealth) {
                pokemon.setCurrentHealth(pokemon.getMaxHealth());
                wasHealed = true;
            }
            if (hasLowPP) {
                pokemon.getMoveSet().getMoves().forEach(move -> {
                    if (move != null && move.getCurrentPp() < move.getMaxPp()) {
                        move.setCurrentPp(move.getMaxPp());
                    }
                });
                wasHealed = true;
            }
        }
        return wasHealed;
    }

    private boolean needsPPRestore(BattlePokemon battlePokemon) {
        return true;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"item.legendarymonuments.sacred_ash.tooltip").withStyle(ChatFormatting.GRAY));
        super.appendHoverText(stack, context, tooltip, type);
    }
}

