/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TitanHammer
extends DiggerItem {
    private static final Map<UUID, Long> LAST_AOE_ATTACK = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> LAST_QUAKE_ATTACK = new HashMap<UUID, Long>();
    private static final long AOE_COOLDOWN = 1000L;
    private static final long QUAKE_COOLDOWN = 3000L;
    private static final int MAX_CHARGE_TICKS = 60;

    public TitanHammer(Tier material, Item.Properties settings) {
        super(material, BlockTags.MINEABLE_WITH_PICKAXE, settings);
    }

    public static ItemAttributeModifiers createAttributeModifiers() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"titan_hammer_attack_damage"), 7.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"titan_hammer_attack_speed"), -3.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_KNOCKBACK, new AttributeModifier(ResourceLocation.fromNamespaceAndPath((String)"legendarymonuments", (String)"titan_hammer_knockback"), 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 15;
    }

    public static boolean isValidEnchantment(Holder<Enchantment> enchantment) {
        return enchantment.is(Enchantments.SHARPNESS) || enchantment.is(Enchantments.SMITE) || enchantment.is(Enchantments.BANE_OF_ARTHROPODS) || enchantment.is(Enchantments.FORTUNE) || enchantment.is(Enchantments.SILK_TOUCH) || enchantment.is(Enchantments.EFFICIENCY) || enchantment.is(Enchantments.UNBREAKING) || enchantment.is(Enchantments.MENDING) || enchantment.is(Enchantments.FIRE_ASPECT) || enchantment.is(Enchantments.LOOTING);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof Player) {
            Player player = (Player)attacker;
            Level level = attacker.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                this.performAoeAttack(player, target, serverWorld);
                this.attemptStagger(target);
            }
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    private void performAoeAttack(Player player, LivingEntity target, ServerLevel world) {
        UUID playerId;
        long currentTime = System.currentTimeMillis();
        if (currentTime - LAST_AOE_ATTACK.getOrDefault(playerId = player.getUUID(), 0L) < 1000L) {
            return;
        }
        LAST_AOE_ATTACK.put(playerId, currentTime);
        AABB aoeBox = AABB.ofSize((Vec3)target.position(), (double)4.0, (double)4.0, (double)4.0);
        List nearbyMobs = world.getEntitiesOfClass(LivingEntity.class, aoeBox, entity -> entity != target && entity != player && entity.isAlive());
        for (LivingEntity mob : nearbyMobs) {
            mob.hurt(world.damageSources().playerAttack(player), 4.0f);
            Vec3 knockbackDirection = mob.position().subtract(target.position()).normalize();
            if (!(knockbackDirection.lengthSqr() > 0.0)) continue;
            mob.push(knockbackDirection.x * 0.5, 0.2, knockbackDirection.z * 0.5);
            mob.hurtMarked = true;
        }
        world.sendParticles((ParticleOptions)ParticleTypes.SWEEP_ATTACK, target.getX(), target.getY() + 1.0, target.getZ(), 5, 1.0, 0.5, 1.0, 0.1);
        world.playSound(null, target.getX(), target.getY(), target.getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    private void attemptStagger(LivingEntity target) {
        if (target.level().getRandom().nextFloat() < 0.25f) {
            target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 12, 2, false, false));
            Level level = target.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)level;
                serverWorld.sendParticles((ParticleOptions)ParticleTypes.CRIT, target.getX(), target.getY() + 1.0, target.getZ(), 3, 0.3, 0.3, 0.3, 0.1);
            }
        }
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack, LivingEntity user) {
        return 60;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player user, InteractionHand hand) {
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)user.getItemInHand(hand));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        if (user instanceof Player) {
            Player player = (Player)user;
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                this.performQuakeAttack(player, serverWorld, 60, stack);
            }
        }
        return stack;
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player player = (Player)user;
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                int chargeTime = 60 - remainingUseTicks;
                this.performQuakeAttack(player, serverWorld, chargeTime, stack);
            }
        }
    }

    private void performQuakeAttack(Player player, ServerLevel world, int chargeTime, ItemStack hammerStack) {
        UUID playerId;
        long currentTime = System.currentTimeMillis();
        if (currentTime - LAST_QUAKE_ATTACK.getOrDefault(playerId = player.getUUID(), 0L) < 3000L) {
            return;
        }
        LAST_QUAKE_ATTACK.put(playerId, currentTime);
        boolean isLongCharge = chargeTime >= 40;
        double radius = isLongCharge ? 4.0 : 2.5;
        float baseDamage = isLongCharge ? 12.0f : 8.0f;
        AABB attackBox = AABB.ofSize((Vec3)player.position(), (double)(radius * 2.0), (double)(radius * 2.0), (double)(radius * 2.0));
        List targets = world.getEntitiesOfClass(LivingEntity.class, attackBox, entity -> entity != player && entity.isAlive());
        for (LivingEntity target : targets) {
            double knockbackStrength;
            if (isLongCharge) {
                float finalDamage = this.calculateEnchantedDamage(hammerStack, target, baseDamage, (Level)world);
                DamageSource damageSource = this.createEnchantedDamageSource(world, player, hammerStack);
                target.hurt(damageSource, finalDamage);
                this.applyEnchantmentEffects(hammerStack, target, world);
            }
            Vec3 knockbackDirection = target.position().subtract(player.position()).normalize();
            double d = knockbackStrength = isLongCharge ? 1.5 : 1.0;
            if (!(knockbackDirection.lengthSqr() > 0.0)) continue;
            target.push(knockbackDirection.x * knockbackStrength, 0.3, knockbackDirection.z * knockbackStrength);
            target.hurtMarked = true;
        }
        if (isLongCharge) {
            world.sendParticles((ParticleOptions)ParticleTypes.EXPLOSION, player.getX(), player.getY(), player.getZ(), 8, radius / 2.0, 0.5, radius / 2.0, 0.1);
            world.playSound(null, player.getX(), player.getY(), player.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.PLAYERS, 1.0f, 0.8f);
        } else {
            world.sendParticles((ParticleOptions)ParticleTypes.POOF, player.getX(), player.getY(), player.getZ(), 15, radius / 2.0, 0.2, radius / 2.0, 0.2);
            world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.PLAYER_ATTACK_STRONG, SoundSource.PLAYERS, 1.0f, 0.7f);
        }
    }

    private DamageSource createEnchantedDamageSource(ServerLevel world, Player player, ItemStack weapon) {
        DamageSource damageSource = world.damageSources().playerAttack(player);
        return damageSource;
    }

    private float calculateEnchantedDamage(ItemStack stack, LivingEntity target, float baseDamage, Level world) {
        int baneLevel;
        Optional baneEntry;
        int smiteLevel;
        Optional smiteEntry;
        int sharpnessLevel;
        float damage = baseDamage;
        ItemEnchantments enchantments = stack.getEnchantments();
        Registry enchantmentRegistry = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Optional sharpnessEntry = enchantmentRegistry.getHolder(Enchantments.SHARPNESS);
        if (sharpnessEntry.isPresent() && (sharpnessLevel = enchantments.getLevel((Holder)sharpnessEntry.get())) > 0) {
            damage += (float)sharpnessLevel * 1.5f;
        }
        if ((smiteEntry = enchantmentRegistry.getHolder(Enchantments.SMITE)).isPresent() && (smiteLevel = enchantments.getLevel((Holder)smiteEntry.get())) > 0 && target.getType().is(EntityTypeTags.UNDEAD)) {
            damage += (float)smiteLevel * 2.5f;
        }
        if ((baneEntry = enchantmentRegistry.getHolder(Enchantments.BANE_OF_ARTHROPODS)).isPresent() && (baneLevel = enchantments.getLevel((Holder)baneEntry.get())) > 0 && target.getType().is(EntityTypeTags.ARTHROPOD)) {
            damage += (float)baneLevel * 2.5f;
            target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 20 + baneLevel * 10, baneLevel - 1));
        }
        return damage;
    }

    private void applyEnchantmentEffects(ItemStack stack, LivingEntity target, ServerLevel world) {
        int lootingLevel;
        Optional lootingEntry;
        int fireAspectLevel;
        ItemEnchantments enchantments = stack.getEnchantments();
        Registry enchantmentRegistry = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Optional fireAspectEntry = enchantmentRegistry.getHolder(Enchantments.FIRE_ASPECT);
        if (fireAspectEntry.isPresent() && (fireAspectLevel = enchantments.getLevel((Holder)fireAspectEntry.get())) > 0) {
            target.igniteForSeconds((float)(fireAspectLevel * 4));
            world.sendParticles((ParticleOptions)ParticleTypes.FLAME, target.getX(), target.getY() + 1.0, target.getZ(), 5, 0.3, 0.5, 0.3, 0.1);
        }
        if ((lootingEntry = enchantmentRegistry.getHolder(Enchantments.LOOTING)).isPresent() && (lootingLevel = enchantments.getLevel((Holder)lootingEntry.get())) > 0) {
            world.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, target.getX(), target.getY() + 1.0, target.getZ(), lootingLevel * 2, 0.2, 0.5, 0.2, 0.1);
        }
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity miner) {
        if (miner instanceof Player) {
            Player player = (Player)miner;
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                this.performAreaMining(player, serverWorld, pos, stack);
            }
        }
        return super.mineBlock(stack, world, state, pos, miner);
    }

    private void performAreaMining(Player player, ServerLevel world, BlockPos center, ItemStack stack) {
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos targetPos;
                    BlockState targetState;
                    if (x == 0 && y == 0 && z == 0 || !this.canAttackBlock(targetState = world.getBlockState(targetPos = center.offset(x, y, z)), (Level)world, targetPos, player) || !targetState.is(BlockTags.MINEABLE_WITH_PICKAXE)) continue;
                    this.mineBlockWithEnchantments(world, targetPos, targetState, player, stack);
                    if (!stack.isDamageableItem()) continue;
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)player.getUsedItemHand()));
                }
            }
        }
    }

    private void mineBlockWithEnchantments(ServerLevel world, BlockPos pos, BlockState state, Player player, ItemStack tool) {
        Optional fortuneEntry;
        ItemEnchantments enchantments = tool.getEnchantments();
        Registry enchantmentRegistry = world.registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        boolean hasSilkTouch = false;
        int fortuneLevel = 0;
        Optional silkTouchEntry = enchantmentRegistry.getHolder(Enchantments.SILK_TOUCH);
        if (silkTouchEntry.isPresent()) {
            boolean bl = hasSilkTouch = enchantments.getLevel((Holder)silkTouchEntry.get()) > 0;
        }
        if ((fortuneEntry = enchantmentRegistry.getHolder(Enchantments.FORTUNE)).isPresent()) {
            fortuneLevel = enchantments.getLevel((Holder)fortuneEntry.get());
        }
        world.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
        if (hasSilkTouch) {
            Block.popResource((Level)world, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)state.getBlock()));
        } else {
            List<ItemStack> drops = Block.getDrops((BlockState)state, (ServerLevel)world, (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos), (Entity)player, (ItemStack)tool);
            if (fortuneLevel > 0) {
                drops = this.applyFortuneToDrops(drops, fortuneLevel, world.getRandom());
            }
            for (ItemStack drop : drops) {
                Block.popResource((Level)world, (BlockPos)pos, (ItemStack)drop);
            }
        }
        world.playSound(null, pos, state.getSoundType().getBreakSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        world.sendParticles((ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK, state), (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, 10, 0.3, 0.3, 0.3, 0.1);
    }

    private List<ItemStack> applyFortuneToDrops(List<ItemStack> drops, int fortuneLevel, RandomSource random) {
        ArrayList<ItemStack> fortuneDrops = new ArrayList<ItemStack>();
        for (ItemStack drop : drops) {
            ItemStack fortuneDrop = drop.copy();
            if (this.isFortuneApplicable(drop)) {
                int multiplier = 1;
                for (int i = 0; i < fortuneLevel; ++i) {
                    if (!(random.nextFloat() < 0.33f)) continue;
                    ++multiplier;
                }
                fortuneDrop.setCount(drop.getCount() * multiplier);
            }
            fortuneDrops.add(fortuneDrop);
        }
        return fortuneDrops;
    }

    private boolean isFortuneApplicable(ItemStack drop) {
        return drop.is(Items.COAL) || drop.is(Items.DIAMOND) || drop.is(Items.EMERALD) || drop.is(Items.LAPIS_LAZULI) || drop.is(Items.REDSTONE) || drop.is(Items.QUARTZ) || drop.is(Items.GLOWSTONE_DUST) || drop.is(Items.COPPER_INGOT) || drop.is(Items.RAW_COPPER) || drop.is(Items.RAW_IRON) || drop.is(Items.RAW_GOLD);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (state.is(BlockTags.MINEABLE_WITH_PICKAXE)) {
            return this.getTier().getSpeed();
        }
        return 1.0f;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack ingredient) {
        return this.getTier().getRepairIngredient().test(ingredient) || super.isValidRepairItem(stack, ingredient);
    }
}

