/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.TrinketItem;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public class TitanPauldron
extends TrinketItem {
    public TitanPauldron(Item.Properties settings) {
        super(settings);
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getModifiers(ItemStack stack, SlotReference slot, LivingEntity entity, ResourceLocation slotId) {
        Multimap modifiers = super.getModifiers(stack, slot, entity, slotId);
        modifiers.put((Object)Attributes.ARMOR, (Object)new AttributeModifier(slotId, 3.0, AttributeModifier.Operation.ADD_VALUE));
        modifiers.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(slotId, 0.2, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        modifiers.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(slotId, 3.0, AttributeModifier.Operation.ADD_VALUE));
        return modifiers;
    }

    public void tick(ItemStack stack, SlotReference slot, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.level().isClientSide && player.tickCount % 40 == 0) {
                player.addEffect(new MobEffectInstance(MobEffects.LUCK, 60, 0, false, false));
                player.addEffect(new MobEffectInstance(MobEffects.DIG_SPEED, 60, 0, false, false));
            }
        }
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        tooltip.add((Component)Component.translatable((String)"attribute.name.generic.armor").append(": +3").withStyle(ChatFormatting.BLUE));
        tooltip.add((Component)Component.translatable((String)"attribute.name.generic.movement_speed").append(": +20%").withStyle(ChatFormatting.YELLOW));
        tooltip.add((Component)Component.translatable((String)"attribute.name.generic.attack_damage").append(": +3").withStyle(ChatFormatting.RED));
        tooltip.add((Component)Component.translatable((String)"item.effect.minecraft.luck").withStyle(ChatFormatting.GREEN));
        tooltip.add((Component)Component.translatable((String)"item.effect.minecraft.haste").withStyle(ChatFormatting.GOLD));
        super.appendHoverText(stack, context, tooltip, type);
    }
}

