/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.item;

import com.cobblemon.mod.common.CobblemonEntities;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.MoveSet;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.entity.pokemon.PokemonEntity;
import com.cobblemon.mod.common.pokemon.Pokemon;
import github.jorgaomc.LegendaryMonuments;
import github.jorgaomc.ModDataComponentTypes;
import github.jorgaomc.ModItems;
import github.jorgaomc.component.UrnProgressComponent;
import java.util.List;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class UrnItem
extends Item {
    private final String pokemonName;
    private final String pokemonType;
    private final boolean isGalarian;
    private final int requiredProgress;
    private static final SoundEvent THUNDER_SOUND = SoundEvents.LIGHTNING_BOLT_THUNDER;
    private static final SoundEvent EXPLODE_SOUND = (SoundEvent)SoundEvents.GENERIC_EXPLODE.value();
    private static final SoundSource AMBIENT = SoundSource.AMBIENT;

    public UrnItem(String pokemonName, String pokemonType, boolean isGalarian) {
        super(new Item.Properties().stacksTo(1).component(ModDataComponentTypes.URN_PROGRESS_COMPONENT, (Object)new UrnProgressComponent(0)));
        this.pokemonName = pokemonName;
        this.pokemonType = pokemonType;
        this.isGalarian = isGalarian;
        this.requiredProgress = isGalarian ? 75 : 50;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (world.isClientSide) {
            return InteractionResultHolder.success((Object)stack);
        }
        UrnProgressComponent progressComponent = (UrnProgressComponent)stack.getOrDefault(ModDataComponentTypes.URN_PROGRESS_COMPONENT, (Object)new UrnProgressComponent(0));
        if (progressComponent.isComplete(this.requiredProgress)) {
            this.spawnLegendaryPokemon(world, player);
            stack.shrink(1);
            return InteractionResultHolder.success((Object)stack);
        }
        ChatFormatting progressColor = UrnItem.getTypeFormatting(this.pokemonType);
        player.displayClientMessage((Component)Component.translatable((String)"item.legendarymonuments.urn.progress", (Object[])new Object[]{progressComponent.progress(), this.requiredProgress}).withStyle(progressColor), true);
        return InteractionResultHolder.success((Object)stack);
    }

    private void spawnLegendaryPokemon(Level world, Player player) {
        if (!(world instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        Random random = new Random();
        boolean isShiny = random.nextDouble() < 0.02;
        double spawnX = player.getX() + player.getLookAngle().x * 3.0;
        double spawnY = player.getY() + 1.0;
        double spawnZ = player.getZ() + player.getLookAngle().z * 3.0;
        try {
            this.spawnLegendaryBirdEffect(serverWorld, player, new BlockPos((int)spawnX, (int)spawnY, (int)spawnZ), this.pokemonType);
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error creating particle effect for {}", (Object)this.pokemonName, (Object)e);
        }
        if (this.isGalarian) {
            this.spawnGalarianPokemon(serverWorld, player, isShiny);
        } else {
            this.spawnRegularPokemon(serverWorld, player, isShiny);
        }
        if (this.pokemonName.equalsIgnoreCase("moltres")) {
            player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)ModItems.MOLTEN_STONE));
            player.displayClientMessage((Component)Component.translatable((String)"item.legendarymonuments.urn.stone.received", (Object[])new Object[]{"Molten Stone"}).withStyle(ChatFormatting.RED), false);
        } else if (this.pokemonName.equalsIgnoreCase("articuno")) {
            player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)ModItems.ARCTIC_STONE));
            player.displayClientMessage((Component)Component.translatable((String)"item.legendarymonuments.urn.stone.received", (Object[])new Object[]{"Arctic Stone"}).withStyle(ChatFormatting.AQUA), false);
        } else if (this.pokemonName.equalsIgnoreCase("zapdos")) {
            player.getInventory().placeItemBackInInventory(new ItemStack((ItemLike)ModItems.ZAP_STONE));
            player.displayClientMessage((Component)Component.translatable((String)"item.legendarymonuments.urn.stone.received", (Object[])new Object[]{"Zap Stone"}).withStyle(ChatFormatting.YELLOW), false);
        }
    }

    private void spawnRegularPokemon(ServerLevel world, Player player, boolean isShiny) {
        try {
            Pokemon pokemon;
            PokemonProperties properties = new PokemonProperties();
            properties.setSpecies(this.pokemonName.toLowerCase());
            properties.setLevel(Integer.valueOf(40));
            if (isShiny) {
                properties.setShiny(Boolean.valueOf(true));
            }
            if ((pokemon = properties.create()) == null) {
                LegendaryMonuments.LOGGER.error("Failed to create Pok\u00e9mon object for {}", (Object)this.pokemonName);
                player.displayClientMessage((Component)Component.literal((String)"Failed to summon Pok\u00e9mon").withStyle(ChatFormatting.RED), true);
                return;
            }
            this.removeMementoMove(pokemon);
            PokemonEntity entity = new PokemonEntity((Level)world, pokemon, CobblemonEntities.POKEMON);
            if (entity == null) {
                LegendaryMonuments.LOGGER.error("Failed to create entity for {}", (Object)this.pokemonName);
                player.displayClientMessage((Component)Component.literal((String)"Failed to summon Pok\u00e9mon").withStyle(ChatFormatting.RED), true);
                return;
            }
            double spawnX = player.getX() + player.getLookAngle().x * 3.0;
            double spawnY = player.getY() + 1.0;
            double spawnZ = player.getZ() + player.getLookAngle().z * 3.0;
            entity.setPos(spawnX, spawnY, spawnZ);
            boolean spawned = world.addFreshEntity((Entity)entity);
            if (!spawned) {
                LegendaryMonuments.LOGGER.error("Failed to spawn {} for player {}", (Object)this.pokemonName, (Object)player.getName().getString());
                int x = (int)Math.floor(spawnX);
                int y = (int)Math.floor(spawnY);
                int z = (int)Math.floor(spawnZ);
                String command = "pokespawnat " + x + " " + y + " " + z + " " + this.pokemonName + " lvl=40 move1=!memento";
                if (isShiny) {
                    command = command + " shiny";
                }
                world.getServer().getCommands().performPrefixedCommand(world.getServer().createCommandSourceStack(), command);
            }
            ChatFormatting typeColor = UrnItem.getTypeFormatting(this.pokemonType);
            String pokemonDisplayName = this.pokemonName.substring(0, 1).toUpperCase() + this.pokemonName.substring(1);
            if (isShiny) {
                player.displayClientMessage((Component)Component.literal((String)"\u2728 ").withStyle(ChatFormatting.YELLOW).append((Component)Component.translatable((String)"item.legendarymonuments.urn.spawned.shiny", (Object[])new Object[]{pokemonDisplayName}).withStyle(typeColor)), false);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"item.legendarymonuments.urn.spawned", (Object[])new Object[]{pokemonDisplayName}).withStyle(typeColor), false);
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error spawning {}", (Object)this.pokemonName, (Object)e);
            player.displayClientMessage((Component)Component.literal((String)"Failed to summon Pok\u00e9mon").withStyle(ChatFormatting.RED), true);
        }
    }

    private void spawnGalarianPokemon(ServerLevel world, Player player, boolean isShiny) {
        try {
            double spawnX = player.getX() + player.getLookAngle().x * 3.0;
            double spawnY = player.getY() + 1.0;
            double spawnZ = player.getZ() + player.getLookAngle().z * 3.0;
            int x = (int)Math.floor(spawnX);
            int y = (int)Math.floor(spawnY);
            int z = (int)Math.floor(spawnZ);
            String command = "pokespawnat " + x + " " + y + " " + z + " " + this.pokemonName + " galarian lvl=50 move1=!memento";
            if (isShiny) {
                command = command + " shiny";
            }
            LegendaryMonuments.LOGGER.info("Executing command: {}", (Object)command);
            world.getServer().getCommands().performPrefixedCommand(world.getServer().createCommandSourceStack(), command);
            ChatFormatting typeColor = UrnItem.getTypeFormatting(this.pokemonType);
            String pokemonDisplayName = "Galarian " + this.pokemonName.substring(0, 1).toUpperCase() + this.pokemonName.substring(1);
            if (isShiny) {
                player.displayClientMessage((Component)Component.literal((String)"\u2728 ").withStyle(ChatFormatting.YELLOW).append((Component)Component.translatable((String)"item.legendarymonuments.urn.spawned.shiny", (Object[])new Object[]{pokemonDisplayName}).withStyle(typeColor)), false);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"item.legendarymonuments.urn.spawned", (Object[])new Object[]{pokemonDisplayName}).withStyle(typeColor), false);
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.error("Error spawning Galarian {}", (Object)this.pokemonName, (Object)e);
            player.displayClientMessage((Component)Component.literal((String)"Failed to summon Galarian Pok\u00e9mon").withStyle(ChatFormatting.RED), true);
        }
    }

    private void removeMementoMove(Pokemon pokemon) {
        try {
            MoveSet moveSet = pokemon.getMoveSet();
            for (int i = 0; i < 4; ++i) {
                Move move = moveSet.get(i);
                if (move == null || !"memento".equalsIgnoreCase(move.getName())) continue;
                moveSet.setMove(i, null);
                LegendaryMonuments.LOGGER.info("Removed Memento move from spawned {}", (Object)this.pokemonName);
                break;
            }
        }
        catch (Exception e) {
            LegendaryMonuments.LOGGER.warn("Failed to remove Memento move from {}: {}", (Object)this.pokemonName, (Object)e.getMessage());
        }
    }

    public String getPokemonType() {
        return this.pokemonType;
    }

    public int getRequiredProgress() {
        return this.requiredProgress;
    }

    public static ChatFormatting getTypeFormatting(String type) {
        return switch (type.toLowerCase()) {
            case "fire" -> ChatFormatting.RED;
            case "electric" -> ChatFormatting.YELLOW;
            case "ice" -> ChatFormatting.AQUA;
            case "water" -> ChatFormatting.BLUE;
            case "grass" -> ChatFormatting.GREEN;
            case "poison" -> ChatFormatting.DARK_PURPLE;
            case "fairy" -> ChatFormatting.LIGHT_PURPLE;
            case "fighting" -> ChatFormatting.GOLD;
            case "psychic" -> ChatFormatting.LIGHT_PURPLE;
            case "ghost" -> ChatFormatting.DARK_PURPLE;
            case "dark" -> ChatFormatting.DARK_PURPLE;
            case "dragon" -> ChatFormatting.DARK_RED;
            case "ground" -> ChatFormatting.GOLD;
            case "rock" -> ChatFormatting.GRAY;
            case "steel" -> ChatFormatting.GRAY;
            default -> ChatFormatting.WHITE;
        };
    }

    private void spawnLegendaryBirdEffect(ServerLevel world, Player player, BlockPos pos, String elementType) {
        RandomSource random = world.getRandom();
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), THUNDER_SOUND, AMBIENT, 1.0f, 0.8f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), EXPLODE_SOUND, AMBIENT, 0.7f, 1.2f);
        CommandSourceStack source = world.getServer().createCommandSourceStack().withPosition(pos.getCenter()).withLevel(world).withSuppressedOutput();
        for (int i = 0; i < 5; ++i) {
            int delay = i * 10;
            world.getServer().execute(() -> {
                try {
                    Thread.sleep(delay);
                    for (int j = 0; j < 36; ++j) {
                        double angle = (double)j * Math.PI / 18.0;
                        double radius = 3.0;
                        double x = (double)pos.getX() + Math.cos(angle) * radius;
                        double z = (double)pos.getZ() + Math.sin(angle) * radius;
                        world.getServer().getCommands().performPrefixedCommand(source, String.format("particle minecraft:cloud %s %s %s 0.2 0.2 0.2 0.02 1 force", x, (double)pos.getY() + 1.5, z));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        switch (elementType.toLowerCase()) {
            case "fire": {
                this.createFireBirdEffect(world, source, pos);
                break;
            }
            case "electric": {
                this.createElectricBirdEffect(world, source, pos);
                break;
            }
            case "ice": {
                this.createIceBirdEffect(world, source, pos);
                break;
            }
            default: {
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:end_rod ~ ~1 ~ 2 2 2 0.1 50 force");
                world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:explosion ~ ~1 ~ 2 2 2 0.1 10 force");
            }
        }
    }

    private void createFireBirdEffect(ServerLevel world, CommandSourceStack source, BlockPos pos) {
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flame ~ ~1 ~ 3 2 3 0.1 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:lava ~ ~1 ~ 2 1 2 0.1 30 force");
        for (int height = 0; height < 8; ++height) {
            int h = height;
            world.getServer().execute(() -> world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flame ~ " + ((double)pos.getY() + (double)h * 0.5) + " ~ 1 0.1 1 0.1 20 force"));
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.BLAZE_SHOOT, AMBIENT, 1.0f, 0.8f);
    }

    private void createElectricBirdEffect(ServerLevel world, CommandSourceStack source, BlockPos pos) {
        for (int i = 0; i < 5; ++i) {
            double offsetX = (world.getRandom().nextDouble() - 0.5) * 5.0;
            double offsetZ = (world.getRandom().nextDouble() - 0.5) * 5.0;
            LightningBolt lightning = new LightningBolt(EntityType.LIGHTNING_BOLT, (Level)world);
            lightning.moveTo((double)pos.getX() + offsetX, (double)pos.getY(), (double)pos.getZ() + offsetZ);
            lightning.setVisualOnly(true);
            world.addFreshEntity((Entity)lightning);
        }
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:electric_spark ~ ~1 ~ 3 2 3 0.5 100 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:flash ~ ~1 ~ 0.3 0.3 0.3 0.1 10 force");
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.LIGHTNING_BOLT_IMPACT, AMBIENT, 1.0f, 1.0f);
    }

    private void createIceBirdEffect(ServerLevel world, CommandSourceStack source, BlockPos pos) {
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:snowflake ~ ~1 ~ 3 2 3 0.05 150 force");
        world.getServer().getCommands().performPrefixedCommand(source, "particle minecraft:item_snowball ~ ~1 ~ 3 2 3 0.1 100 force");
        for (int radius = 1; radius < 8; radius += 2) {
            int r = radius;
            world.getServer().execute(() -> {
                for (int i = 0; i < 36; ++i) {
                    double angle = (double)i * Math.PI / 18.0;
                    double x = (double)pos.getX() + Math.cos(angle) * (double)r;
                    double z = (double)pos.getZ() + Math.sin(angle) * (double)r;
                    world.getServer().getCommands().performPrefixedCommand(source, String.format("particle minecraft:dust 0.8 0.9 1.0 1.5 %s %s %s 0.1 0.0 0.1 0 1 force", x, (double)pos.getY() + 0.1, z));
                }
            });
            try {
                Thread.sleep(75L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.GLASS_BREAK, AMBIENT, 1.0f, 0.6f);
        world.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.AMETHYST_BLOCK_CHIME, AMBIENT, 1.0f, 0.8f);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag type) {
        if (!stack.has(ModDataComponentTypes.URN_PROGRESS_COMPONENT)) {
            return;
        }
        UrnProgressComponent progressComponent = (UrnProgressComponent)stack.get(ModDataComponentTypes.URN_PROGRESS_COMPONENT);
        tooltip.add((Component)Component.translatable((String)"item.legendarymonuments.urn.tooltip.type", (Object[])new Object[]{this.pokemonType}).withStyle(ChatFormatting.GRAY));
        tooltip.add((Component)Component.translatable((String)"item.legendarymonuments.urn.tooltip.progress", (Object[])new Object[]{progressComponent.progress(), this.requiredProgress}).withStyle(progressComponent.isComplete(this.requiredProgress) ? ChatFormatting.GREEN : ChatFormatting.YELLOW));
        if (progressComponent.isComplete(this.requiredProgress)) {
            tooltip.add((Component)Component.translatable((String)"item.legendarymonuments.urn.tooltip.ready").withStyle(ChatFormatting.GREEN));
        } else {
            tooltip.add((Component)Component.translatable((String)"item.legendarymonuments.urn.tooltip.instruction").withStyle(ChatFormatting.GRAY));
        }
        super.appendHoverText(stack, context, tooltip, type);
    }
}

