/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.mixin;

import github.jorgaomc.ModItems;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AnvilMenu.class})
public class AnvilScreenHandlerMixin {
    @Shadow
    @Final
    private DataSlot cost;
    @Shadow
    private int repairItemCountCost;
    @Shadow
    @Nullable
    private String itemName;

    @Inject(method={"updateResult"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleRedChainRepair(CallbackInfo ci) {
        AnvilMenu handler = (AnvilMenu)this;
        ItemStack leftStack = handler.getSlot(0).getItem();
        ItemStack rightStack = handler.getSlot(1).getItem();
        if (leftStack.is(ModItems.FRAGMENTED_RED_CHAIN) && rightStack.is(ModItems.ORIGIN_INGOT)) {
            ItemStack result;
            int ingotCount = Math.min(rightStack.getCount(), 10);
            int durabilityToRestore = ingotCount * 10;
            int currentDamage = leftStack.getDamageValue();
            int newDamage = Math.max(0, currentDamage - durabilityToRestore);
            if (newDamage <= 0) {
                result = new ItemStack((ItemLike)ModItems.RED_CHAIN);
                result.setDamageValue(0);
            } else {
                result = new ItemStack((ItemLike)ModItems.FRAGMENTED_RED_CHAIN);
                result.setDamageValue(newDamage);
            }
            result.applyComponents(leftStack.getComponents());
            result.setDamageValue(newDamage);
            int namingCost = 0;
            if (this.itemName != null && !this.itemName.isEmpty()) {
                if (this.itemName.trim().isEmpty()) {
                    result.remove(DataComponents.CUSTOM_NAME);
                    namingCost = 1;
                } else if (!this.itemName.equals(leftStack.getHoverName().getString())) {
                    result.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)this.itemName));
                    namingCost = 1;
                }
            }
            this.cost.set(Math.max(1, ingotCount + namingCost));
            this.repairItemCountCost = ingotCount;
            handler.getSlot(2).set(result);
            ci.cancel();
            return;
        }
        if (leftStack.is(ModItems.RED_CHAIN) || leftStack.is(ModItems.FRAGMENTED_RED_CHAIN)) {
            if (leftStack.is(ModItems.RED_CHAIN)) {
                this.cost.set(0);
                this.repairItemCountCost = 0;
                handler.getSlot(2).set(ItemStack.EMPTY);
                ci.cancel();
                return;
            }
            if (!rightStack.is(ModItems.ORIGIN_INGOT)) {
                this.cost.set(0);
                this.repairItemCountCost = 0;
                handler.getSlot(2).set(ItemStack.EMPTY);
                ci.cancel();
                return;
            }
        }
    }
}

