/*
 * Decompiled with CFR 0.152.
 */
package github.jorgaomc.mixin;

import github.jorgaomc.blocks.SanctuaryBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ServerPlayerGameMode;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerPlayerGameMode.class})
public class BlockEventMixin {
    @Shadow
    @Final
    protected ServerPlayer player;

    @Inject(method={"tryBreakBlock"}, at={@At(value="HEAD")}, cancellable=true)
    private void onTryBreakBlock(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        if (!this.player.isCreative() && SanctuaryBlock.isBlockBreakingBlocked(this.player.level(), pos)) {
            this.player.displayClientMessage((Component)Component.literal((String)"This area is protected by a Sanctuary Block. You cannot break blocks here.").withStyle(ChatFormatting.RED), true);
            cir.setReturnValue((Object)false);
        }
    }
}

